/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.NetFileAttributeExtractor;
import com.sun.portal.netfile.NetFileContext;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class NetFileContextImpl
implements NetFileContext,
SSOTokenListener {
    private AMUser user;
    private String szUserName;
    private AMStoreConnection connection;
    private Map userAttributes;
    private Locale userLocale;
    private String HTMLCharset;
    private Debug debug = null;
    private boolean applyDefault = false;

    public NetFileContextImpl(SSOToken token) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        try {
            this.connection = new AMStoreConnection(token);
            this.applyDefault = false;
            this.getAMUserObject(token);
            this.szUserName = token.getPrincipal().getName();
            this.userAttributes = this.getServiceAttributes("srapNetFileService");
        }
        catch (SSOException ssoe) {
            this.applyDefault = true;
            return;
        }
    }

    private Map[] getIPSPreferences() {
        Map[] nfAttrs = new HashMap[]{this.userAttributes == null ? this.getServiceAttributes("srapNetFileService") : this.userAttributes, this.getGlobalAttributes("srapNetFileService")};
        return nfAttrs;
    }

    private void getAMUserObject(SSOToken token) throws SSOException {
        this.user = this.connection.getUser(token.getPrincipal().getName());
    }

    private Map getServiceAttributes(String szServiceName) {
        try {
            Map serviceAttrs = szServiceName == null || szServiceName.length() == 0 ? this.user.getServiceAttributes("srapNetFileService") : this.user.getServiceAttributes(szServiceName);
            return serviceAttrs;
        }
        catch (SSOException ssoe) {
            ssoe.printStackTrace();
        }
        catch (AMException ame) {
            ame.printStackTrace();
        }
        return null;
    }

    private Map getGlobalAttributes(String szServiceName) {
        Map attrs = null;
        if (szServiceName == null || szServiceName.length() == 0) {
            return null;
        }
        try {
            AMSchema schema = this.connection.getSchema(szServiceName, AMSchema.Type.GLOBAL);
            attrs = schema.getAttributeDefaults();
            schema = null;
        }
        catch (AMException ame) {
            ame.printStackTrace();
        }
        return attrs;
    }

    public String getOrganizationAttribute(String szServiceName, String szAttributeName, String szDefaultVal) {
        String value;
        String val;
        block9: {
            String orgDN = null;
            val = szDefaultVal;
            value = szDefaultVal;
            try {
                orgDN = this.user.getOrganizationDN();
                if (orgDN == null) {
                    return null;
                }
                AMOrganization org = this.connection.getOrganization(orgDN);
                if (org.orgTemplateExists(szServiceName)) {
                    AMTemplate temp = org.getTemplate(szServiceName, 302);
                    Set vals = temp.getAttribute(szAttributeName);
                    if (vals != null && vals.size() > 0) {
                        Iterator iter = vals.iterator();
                        value = (String)iter.next();
                    }
                    break block9;
                }
                AMSchema schema = this.connection.getSchema(szServiceName, AMSchema.Type.ORGANIZATION);
                Map mapVals = schema.getAttributeDefaults();
                NetFileAttributeExtractor nfAttrExtr = new NetFileAttributeExtractor(mapVals);
                String data = nfAttrExtr.getString(szAttributeName, szDefaultVal);
                if (data == null || data.equals("")) {
                    if (this.applyDefault) {
                        return szDefaultVal;
                    }
                    break block9;
                }
                this.debug.message(szAttributeName + " Org Attribute obtained thru schema is " + data);
                return data;
            }
            catch (AMException ame) {
                this.debug.error("AMException in getting Org Attribute " + (Object)((Object)ame));
                ame.printStackTrace();
            }
            catch (SSOException ssoe) {
                this.debug.error("SSOException in getting Org Attribute " + (Object)((Object)ssoe));
                ssoe.printStackTrace();
            }
            catch (Exception e) {
                this.debug.error("Exception in getting Org Attribute " + e);
                e.printStackTrace();
            }
        }
        val = value;
        return val;
    }

    public Vector getOrganizationAttributeValues(String serviceName, String attributeName) {
        Vector<Object> data;
        block10: {
            String orgDN = null;
            data = null;
            try {
                orgDN = this.user.getOrganizationDN();
                if (orgDN == null) {
                    return null;
                }
                AMOrganization org = this.connection.getOrganization(orgDN);
                if (org.orgTemplateExists(serviceName)) {
                    AMTemplate template = org.getTemplate(serviceName, 302);
                    Set values = template.getAttribute(attributeName);
                    if (values != null && values.size() > 0) {
                        data = new Vector<Object>();
                        Iterator iter = values.iterator();
                        while (iter.hasNext()) {
                            data.add(iter.next());
                        }
                    }
                    break block10;
                }
                AMSchema schema = this.connection.getSchema(serviceName, AMSchema.Type.ORGANIZATION);
                Map mapVals = schema.getAttributeDefaults();
                Set keys = mapVals.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    Set values;
                    String attrib = (String)i.next();
                    if (!attrib.equalsIgnoreCase(attributeName) || (values = (Set)mapVals.get(attrib)) == null) continue;
                    data = new Vector();
                    Object[] obj = values.toArray();
                    int index = 0;
                    while (index < obj.length) {
                        data.add(obj[index]);
                        ++index;
                    }
                    break;
                }
            }
            catch (AMException ame) {
                ame.printStackTrace();
            }
            catch (SSOException ssoe) {
                ssoe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public Map[] getPreferences() {
        try {
            return this.getIPSPreferences();
        }
        catch (Exception e) {
            if (this.debug.messageEnabled()) {
                this.debug.message("Error in getting preferences", (Throwable)e);
            }
            return null;
        }
    }

    public boolean savePreferences(Map prefs) throws Exception {
        try {
            this.user.setAttributes(prefs);
        }
        catch (AMException pe) {
            this.debug.error("Preferences not saved", (Throwable)pe);
            return false;
        }
        catch (SSOException pe) {
            this.debug.error("Preferences not saved", (Throwable)pe);
            return false;
        }
        catch (Exception e) {
            this.debug.error("Preferences not saved", (Throwable)e);
            return false;
        }
        try {
            this.user.store();
            return true;
        }
        catch (Exception e) {
            this.debug.error("Preferences not saved", (Throwable)e);
            return false;
        }
    }

    public void ssoTokenChanged(SSOTokenEvent event) {
        try {
            SSOToken token = event.getToken();
            int type = event.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPolicyAssigned() throws AMException, SSOException {
        Map attrs = null;
        Set vals = null;
        attrs = this.user.getPolicy("srapNetFileService");
        if (attrs == null || attrs.isEmpty()) {
            if (this.isDebugEnabled() && this.debug.messageEnabled()) {
                this.debug.message("No policy attribute is defined for NetFile service");
            }
            return false;
        }
        vals = (Set)attrs.get("sunPortalNetFileExecute");
        if (vals == null || vals.size() < 1) {
            if (this.isDebugEnabled()) {
                this.debug.message("No policy enabled for this user");
            }
            return false;
        }
        return Boolean.valueOf((String)vals.iterator().next());
    }

    public boolean isServiceAssigned(String szServiceName) throws AMException, SSOException {
        Set vals = null;
        vals = this.user.getAssignedServices();
        if (vals == null || vals.isEmpty()) {
            if (this.isDebugEnabled() && this.debug.messageEnabled()) {
                this.debug.message("NetFile service has not been assigned for the user");
            }
            return false;
        }
        Iterator iter = vals.iterator();
        while (iter.hasNext()) {
            String szAServiceName = (String)iter.next();
            if (!szAServiceName.equals(szServiceName)) continue;
            return true;
        }
        return false;
    }

    public boolean isExecutable() {
        try {
            return this.isPolicyAssigned() && this.isServiceAssigned("srapNetFileService");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isSessionValid(SSOToken token) {
        try {
            if (token == null) {
                return false;
            }
            SSOTokenManager manager = SSOTokenManager.getInstance();
            if (!manager.isValidToken(token)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Locale getUserLocale() {
        Locale locale = null;
        try {
            Map data = this.getServiceAttributes("iPlanetAMUserService");
            Set values = (Set)data.get("preferredlocale");
            NetFileAttributeExtractor nfAttr = new NetFileAttributeExtractor(data);
            String locstr = nfAttr.getString("preferredlocale", "en_US");
            StringTokenizer locst = new StringTokenizer(locstr, "_");
            if (locst.countTokens() > 0) {
                String lang = locst.hasMoreTokens() ? locst.nextToken() : "";
                String country = locst.hasMoreTokens() ? locst.nextToken() : "";
                String variant = locst.hasMoreTokens() ? locst.nextToken() : "";
                while (locst.hasMoreTokens()) {
                    variant = variant + "_" + locst.nextToken();
                }
                locale = new Locale(lang, country, variant);
            } else {
                locale = new Locale("en", "US");
            }
            this.userLocale = locale;
            if (this.debug.messageEnabled()) {
                this.debug.message("Locale is " + this.userLocale.toString());
            }
            if (this.debug.messageEnabled()) {
                this.debug.message(this.userLocale.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug.error("UserLocale Error is ", (Throwable)e);
            return null;
        }
        return locale;
    }

    public void determineHTMLCharset(HttpServletRequest req) {
        AMClientDetector amCD = new AMClientDetector();
        String clientType = amCD.getClientType(req);
        try {
            Client clientObj = Client.getInstance((String)clientType);
            this.HTMLCharset = clientObj.getCharset(this.getUserLocale());
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("HTML Charset is " + this.HTMLCharset);
        }
        amCD = null;
        Object var3_3 = null;
    }

    public String getHTMLCharset() {
        return this.HTMLCharset;
    }

    public String getMailPreferences() {
        String fromAddr = "";
        String replyToAddr = "";
        String imapSrvr = "";
        String smtpSrvr = "";
        String imapUserId = "";
        String defaultMailDom = "";
        StringBuffer sb = new StringBuffer();
        Map mailData = this.getServiceAttributes("SunPortalNetMailService");
        if (mailData == null || mailData.isEmpty()) {
            if (this.isDebugEnabled() && this.debug.messageEnabled()) {
                this.debug.message("NetFile service has not been assigned for the user");
            }
            return "";
        }
        NetFileAttributeExtractor nfAttr = new NetFileAttributeExtractor(mailData);
        imapSrvr = nfAttr.getString("sunPortalNetmailIMAPServerName", "");
        smtpSrvr = nfAttr.getString("sunPortalNetmailSMTPServerName", "");
        imapUserId = nfAttr.getString("sunPortalNetmailIMAPUserid", "");
        defaultMailDom = nfAttr.getString("sunPortalNetmailDefaultMailDomain", "");
        replyToAddr = nfAttr.getString("sunPortalNetmailReplyToAddress", "");
        if (imapSrvr != null && imapSrvr.length() != 0) {
            defaultMailDom = imapSrvr;
        }
        if (smtpSrvr != null && smtpSrvr.length() != 0) {
            defaultMailDom = smtpSrvr;
        }
        if (defaultMailDom != null && defaultMailDom.length() != 0) {
            fromAddr = imapUserId + "@" + defaultMailDom;
        }
        if (fromAddr == null) {
            sb.append("sunPortalUserFromAddress").append("=").append("").append("\n");
        } else {
            sb.append("sunPortalUserFromAddress").append("=").append(fromAddr).append("\n");
        }
        if (replyToAddr == null) {
            if (fromAddr == null) {
                sb.append("sunPortalUserReplyToAddress").append("=").append("").append("\n");
            } else {
                sb.append("sunPortalUserReplyToAddress").append("=").append(fromAddr).append("\n");
            }
        } else if (replyToAddr.length() == 0) {
            if (fromAddr != null) {
                sb.append("sunPortalUserReplyToAddress").append("=").append(fromAddr).append("\n");
            }
        } else {
            sb.append("sunPortalUserReplyToAddress").append("=").append(replyToAddr).append("\n");
        }
        sb.append("mailserver").append("=").append(defaultMailDom).append("\n");
        return sb.toString();
    }

    public Hashtable getMailAttributesAsCollection() {
        String fromAddr = "";
        String replyToAddr = "";
        String imapSrvr = "";
        String smtpSrvr = "";
        String imapUserId = "";
        String defaultMailDom = "";
        Hashtable<String, String> htMailData = new Hashtable<String, String>();
        Map mailData = this.getServiceAttributes("SunPortalNetMailService");
        if (mailData == null || mailData.isEmpty()) {
            if (this.isDebugEnabled() && this.debug.messageEnabled()) {
                this.debug.message("NetFile service has not been assigned for the user");
            }
            return null;
        }
        NetFileAttributeExtractor nfAttr = new NetFileAttributeExtractor(mailData);
        imapSrvr = nfAttr.getString("sunPortalNetmailIMAPServerName", "");
        smtpSrvr = nfAttr.getString("sunPortalNetmailSMTPServerName", "");
        imapUserId = nfAttr.getString("sunPortalNetmailIMAPUserid", "");
        defaultMailDom = nfAttr.getString("sunPortalNetmailDefaultMailDomain", "");
        replyToAddr = nfAttr.getString("sunPortalNetmailReplyToAddress", "");
        if (imapSrvr != null && imapSrvr.length() != 0) {
            defaultMailDom = imapSrvr;
        }
        if (smtpSrvr != null && smtpSrvr.length() != 0) {
            defaultMailDom = smtpSrvr;
        }
        if (defaultMailDom != null && defaultMailDom.length() != 0) {
            fromAddr = imapUserId + "@" + defaultMailDom;
        }
        if (fromAddr == null) {
            htMailData.put("sunPortalUserFromAddress", "");
        } else {
            htMailData.put("sunPortalUserFromAddress", fromAddr);
        }
        if (replyToAddr == null) {
            if (fromAddr == null) {
                htMailData.put("sunPortalUserReplyToAddress", "");
            } else {
                htMailData.put("sunPortalUserReplyToAddress", fromAddr);
            }
        } else if (replyToAddr.length() == 0) {
            if (fromAddr != null) {
                htMailData.put("sunPortalUserReplyToAddress", fromAddr);
            }
        } else {
            htMailData.put("sunPortalUserReplyToAddress", replyToAddr);
        }
        htMailData.put("mailserver", defaultMailDom);
        return htMailData;
    }

    public boolean isDebugEnabled() {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
            if (this.debug.getState() != 0) {
                return true;
            }
            this.debug = null;
        }
        return false;
    }

    public Map getUserPreferences() throws Exception {
        throw new UnsupportedOperationException("Method not implemented");
    }
}

