/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.AddressList;
import com.sun.portal.netmail.protocol.Controller;
import com.sun.portal.netmail.protocol.Folder;
import com.sun.portal.netmail.protocol.MessagePart;
import com.sun.portal.netmail.protocol.Requestor;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class Message
extends MessagePart
implements Cloneable,
Serializable,
Requestor {
    public Folder folder;
    public long UID = -1L;
    public AddressList from = new AddressList();
    public AddressList to = new AddressList();
    public AddressList cc = new AddressList();
    public AddressList replyto = new AddressList();
    public String subj = "";
    public Date date = new Date();
    public int intsize = 0;
    public MessagePart[] messageParts = new MessagePart[0];
    public int sizeLines = 0;
    public String fullheader = null;
    int IMAPnum = 0;
    public static final byte recentFlag = 1;
    public static final byte answeredFlag = 2;
    public static final byte deletedFlag = 4;
    public static final byte seenFlag = 8;
    public byte flags = 0;
    public byte serverFlags = 0;
    transient byte resyncFlags;
    public static final int statusDeleted = 0;
    public static final int statusSeen = 1;
    public static final int statusReplied = 2;
    public static final int statusUnread = 3;
    public static final int statusNew = 4;
    public int statusweight = 0;
    Message originalMessage;
    public boolean isAttachment = false;
    Vector targetMessages;
    Vector targetFolderRefs;
    public transient boolean found = false;
    public transient int displayIndex = -1;
    public transient String griddate = null;
    public static final int copyOK = 0;
    public static final int copyNOFOLDER = 1;
    public static final int copyOTHER = 2;

    public MessagePart.Ref getRef() {
        return new Ref(this);
    }

    public Message(Folder folder, int n) {
        this.folder = folder;
        this.originalMessage = null;
        this.setIMAPnumber(n);
        this.markStatus();
    }

    public Message(Message message, int n) {
        super(message, n);
        this.folder = message.folder;
        this.originalMessage = null;
        this.setIMAPnumber(message.IMAPnumber());
        this.markStatus();
    }

    public int load(Controller controller, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.messageParts.length) {
            if (bl) {
                n += this.messageParts[n2].load(controller, bl, bl2, bl3);
            } else if (this.messageParts[n2].getMIMEType().equalsIgnoreCase("text/plain")) {
                n += this.messageParts[n2].load(controller, bl, bl2, bl3);
                break;
            }
            ++n2;
        }
        return n;
    }

    public void loadFullHeader(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 14, this.getRef());
    }

    public void copyTo(Controller controller, Folder folder) {
        try {
            Message message = (Message)this.clone();
            message.setIMAPnumber(0);
            message.UID = folder.nextCloneUID--;
            folder.addMessage(message);
            if (this.targetMessages == null) {
                this.targetMessages = new Vector();
                this.targetFolderRefs = new Vector();
            }
            this.targetMessages.addElement(message);
            Folder.Ref ref = folder.getRef();
            this.targetFolderRefs.addElement(ref);
            message.originalMessage = this;
            Serializable[] serializableArray = new Serializable[]{this.getRef(), ref};
            controller.getRequest().startOp((Requestor)this, 8, serializableArray);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    synchronized void resync(Controller controller) {
        if (this.isClone()) {
            return;
        }
        if (this.targetMessages != null) {
            int n = 0;
            while (n < this.targetMessages.size()) {
                Message message = (Message)this.targetMessages.elementAt(n);
                if (message != null && message.folder != null && !message.folder.isDeleted) {
                    if (!this.flagsMatchForCopy(message)) {
                        this.setFlagsFromMsg(controller, message);
                    }
                    Folder.Ref ref = (Folder.Ref)this.targetFolderRefs.elementAt(n);
                    controller.getRequest().startOp((Requestor)this, 8, new Serializable[]{this.getRef(), ref});
                }
                ++n;
            }
        }
        if (this.targetMessages != null && this.flags != this.resyncFlags || this.flags != this.serverFlags) {
            this.setFlagsFromMsg(controller, this);
        }
    }

    public synchronized void setFlag(Controller controller, byte by, boolean bl) {
        if ((this.flags & by) != 0 == bl && (this.serverFlags & by) != 0 == bl) {
            return;
        }
        this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
        if (this.folder != null && this.UID != -1L) {
            Serializable[] serializableArray = new Serializable[]{this.getRef(), new Byte(this.flags)};
            controller.getRequest().startOp((Requestor)this, 13, serializableArray);
        }
        this.markStatus();
    }

    public synchronized void setFlagsFromMsg(Controller controller, Message message) {
        if (this.folder != null && this.UID != -1L) {
            Serializable[] serializableArray = new Serializable[]{this.getRef(), new Byte(message.flags)};
            controller.getRequest().startOp((Requestor)this, 13, serializableArray);
        }
        this.resyncFlags = message.flags;
    }

    public synchronized void opCompleted(Controller controller, int n, Serializable[] serializableArray, Serializable[] serializableArray2) {
        switch (n) {
            case 13: {
                byte by = (Byte)serializableArray2[0];
                if (by == -1) break;
                this.resyncFlags = this.serverFlags = by;
                this.flags = this.serverFlags;
                this.markStatus();
                break;
            }
            case 8: {
                int n2 = (Integer)serializableArray2[0];
                Message message = null;
                int n3 = 0;
                while (n3 < this.targetFolderRefs.size()) {
                    Folder.Ref ref = (Folder.Ref)this.targetFolderRefs.elementAt(n3);
                    if (ref == serializableArray[1]) {
                        message = (Message)this.targetMessages.elementAt(n3);
                        this.targetMessages.removeElementAt(n3);
                        this.targetFolderRefs.removeElementAt(n3);
                        message.folder.removeMessage(message);
                        if (this.targetMessages.size() != 0) break;
                        this.targetFolderRefs = null;
                        this.targetMessages = null;
                        break;
                    }
                    ++n3;
                }
                if (n2 == 0) break;
                if (serializableArray2.length > 1) {
                    System.out.println((String)((Object)serializableArray2[1]));
                }
                controller.copyFailed(this, message, n2);
                break;
            }
            case 14: {
                this.fullheader = (String)((Object)serializableArray2[0]);
            }
        }
        controller.messageUpdated(this);
    }

    void updateFlags(Controller controller, byte by) {
        this.resyncFlags = this.serverFlags = by;
        this.flags = this.serverFlags;
        this.markStatus();
        controller.messageUpdated(this);
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.originalMessage != null) {
            return this.originalMessage.clone();
        }
        Message message = (Message)super.clone();
        message.originalMessage = this;
        message.displayIndex = -1;
        message.date = new Date(this.date.getTime());
        message.to = (AddressList)this.to.clone();
        message.from = (AddressList)this.from.clone();
        message.cc = (AddressList)this.cc.clone();
        message.replyto = (AddressList)this.replyto.clone();
        message.messageParts = new MessagePart[this.messageParts.length];
        int n = 0;
        while (n < this.messageParts.length) {
            message.messageParts[n] = (MessagePart)this.messageParts[n].clone();
            ++n;
        }
        return message;
    }

    public boolean flagsChanged() {
        return this.flags != this.serverFlags;
    }

    public boolean flagsMatchForCopy(Message message) {
        return message.flags == this.serverFlags;
    }

    public int getSize() {
        return this.intsize;
    }

    public void markStatus() {
        this.statusweight = (this.flags & 4) != 0 ? 0 : ((this.flags & 2) != 0 ? 2 : ((this.flags & 1) != 0 && (this.flags & 8) == 0 ? 4 : ((this.flags & 8) != 0 ? 1 : 3)));
    }

    public void setUID(int n) {
        this.UID = n;
    }

    public long UID() {
        return this.UID;
    }

    public void setIMAPnumber(int n) {
        this.IMAPnum = n;
    }

    public int IMAPnumber() {
        return this.IMAPnum;
    }

    public int statusWeight() {
        return this.statusweight;
    }

    public boolean isDeleted() {
        return (this.flags & 4) != 0;
    }

    public boolean isAttachment() {
        return this.parent != null || this.isAttachment;
    }

    public boolean isReadOnly() {
        return this.isAttachment() || this.folder == null || this.folder.isReadOnly;
    }

    public boolean isExpunged() {
        MessagePart messagePart = this;
        while (messagePart.parent != null) {
            messagePart = messagePart.parent;
        }
        Message message = messagePart;
        return message.folder == null;
    }

    public boolean isClone() {
        return this.originalMessage != null;
    }

    public boolean isCached() {
        int n = 0;
        while (n < this.messageParts.length) {
            if (!this.messageParts[n].isCached()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasAttachments() {
        return this.messageParts.length > 1;
    }

    public String getMIMEType() {
        return "message/rfc822";
    }

    public static class Ref
    extends MessagePart.Ref
    implements Serializable {
        public Folder.Ref folder;
        public long UID;

        public Ref(Message message) {
            super(message);
            if (message.folder != null) {
                this.folder = message.folder.getRef();
            }
            this.UID = message.UID;
        }

        public String toArgString() {
            String string = "";
            if (this.UID >= 0L && this.folder != null) {
                string = string + this.folder.toArgString() + "&UID=" + this.UID;
            }
            string = string + super.toArgString();
            return string;
        }
    }
}

