/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CLIPSubCommand {
    private String subCommandName;
    private List orderedOptions;
    private Map validOptions;
    private Map defaultOptionValues;
    private int minOperands;
    private int maxOperands;
    private String subCommandHelp;
    private String operandsHelp;

    public CLIPSubCommand(String string, CLIPOption[] cLIPOptionArray, int n, int n2, String string2, String string3) throws IllegalArgumentException {
        this.setSubCommandName(string);
        this.setOptions(string, cLIPOptionArray);
        this.setMinOperands(string, n);
        this.setMaxOperands(string, n, n2);
        this.setSubCommandHelp(string, string3);
        this.setOperandsHelp(string, string2);
    }

    public String getSubCommandName() {
        return this.subCommandName;
    }

    public List getOrderedOptions() {
        return this.orderedOptions;
    }

    public Map getValidOptions() {
        return this.validOptions;
    }

    public Map getDefaultOptionValues() {
        return this.defaultOptionValues;
    }

    public int getMinOperands() {
        return this.minOperands;
    }

    public int getMaxOperands() {
        return this.maxOperands;
    }

    public String getSubCommandHelp() {
        return this.subCommandHelp;
    }

    public String getOperandsHelp() {
        return this.operandsHelp;
    }

    private void setSubCommandName(String string) {
        if (string != null) {
            CLIPParser.verifyName(string, "CLIPSubCommand");
        }
        this.subCommandName = string;
    }

    private void setOptions(String string, CLIPOption[] cLIPOptionArray) {
        CLIPOption cLIPOption = new CLIPOption("help", null, 0, "false", "optionHelp");
        this.validOptions = new HashMap();
        this.orderedOptions = new ArrayList();
        this.validOptions.put(cLIPOption.getLongName(), cLIPOption);
        this.orderedOptions.add(cLIPOption);
        if (cLIPOptionArray != null) {
            int n = 0;
            while (n < cLIPOptionArray.length) {
                if (cLIPOptionArray[n] == null) {
                    throw new IllegalArgumentException("CLIPSubCommand: " + string + "', option instances can not be NULL");
                }
                if (this.validOptions.containsKey(cLIPOptionArray[n].getLongName())) {
                    throw new IllegalArgumentException("CLIPSubCommand: " + string + "', option long names can not be duplicated within a CLIPParser instance");
                }
                this.validOptions.put(cLIPOptionArray[n].getLongName(), cLIPOptionArray[n]);
                this.orderedOptions.add(cLIPOptionArray[n]);
                if (cLIPOptionArray[n].getShortName() != null) {
                    if (this.validOptions.containsKey(cLIPOptionArray[n].getShortName())) {
                        throw new IllegalArgumentException("CLIPSubCommand: " + string + "', option short names can not be duplicated within a CLIPParser instance");
                    }
                    this.validOptions.put(cLIPOptionArray[n].getShortName(), cLIPOptionArray[n]);
                }
                ++n;
            }
        }
        this.setDefaultOptionValues(cLIPOptionArray);
    }

    private void setDefaultOptionValues(CLIPOption[] cLIPOptionArray) {
        this.defaultOptionValues = new HashMap();
        if (cLIPOptionArray != null) {
            int n = 0;
            while (n < cLIPOptionArray.length) {
                String[] stringArray = cLIPOptionArray[n].getDefaultValues();
                if (stringArray != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        arrayList.add(stringArray[n2]);
                        ++n2;
                    }
                    this.defaultOptionValues.put(cLIPOptionArray[n].getLongName(), arrayList);
                }
                ++n;
            }
        }
    }

    private void setMinOperands(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("CLIPSubCommand: " + string + "', minimum number of operands can not be less than zero");
        }
        this.minOperands = n;
    }

    private void setMaxOperands(String string, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("CLIPSubCommand: " + string + "', maximum number of operands can not be less than minimum number of operands");
        }
        this.maxOperands = n2;
    }

    private void setSubCommandHelp(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("CLIPSubCommand: " + string + "', sub command help can not be NULL");
        }
        this.subCommandHelp = CLIPSpec.getLocaleHelper().getLocalizedString(string2);
    }

    private void setOperandsHelp(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("CLIPSubCommand: " + string + "', operands help can not be NULL");
        }
        this.operandsHelp = CLIPSpec.getLocaleHelper().getLocalizedString(string2);
    }

    public String toString() {
        return "\nSubCommandName: " + this.subCommandName + "\n" + "OrderedOptions: " + this.orderedOptions + "\n" + "Valid Options: " + this.validOptions + "\n" + "Default Option Values: " + this.defaultOptionValues + "\n" + "Min Operands: " + this.minOperands + "\n" + "Max Operands: " + this.maxOperands + "\n" + "Sub Command Help: " + this.subCommandHelp + "\n" + "Operands Help: " + this.operandsHelp + "\n";
    }
}

