/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.LocaleHelper;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.clip.CLIHandler;
import com.sun.portal.rewriter.util.clip.CLIPException;
import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSubCommand;
import com.sun.portal.rewriter.util.xml.Document;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class CLIPSpec {
    private static final String SUB_COMMAND_XPATH = "\\\\CLIPToolSpec\\SUBCommand";
    private static final String COMMON_OPTIONS_XPATH = "\\\\CLIPToolSpec\\CommonOptions\\Option";
    private static final String HELP = "help";
    private static final String NAME = "name";
    private static final String COMMAND_HANDLER = "commandHandler";
    private static final String LOCALE_BASE = "localeBase";
    private static final String MIN_OPERANDS = "minOperands";
    private static final String MAX_OPERANDS = "maxOperands";
    private static final String OPERANDS_HELP = "operandsHelp";
    private static final String LONG_NAME = "longName";
    private static final String SHORT_NAME = "shortName";
    private static final String TYPE = "type";
    private static final String DEFAULT_VALUES = "defaultValues";
    private static String localeBase;
    private static String specFile;
    private String toolName;
    private String toolVersion;
    private Class commandHandler;
    private String commandHandlerClassName;
    private CLIPParser clipParser;
    private CLIPOption[] commonOptions;

    public CLIPSpec(String string) {
        this.setCLIPParser(string);
    }

    public CLIPParser getCLIPParser() {
        return this.clipParser;
    }

    private void setCLIPParser(String string) {
        try {
            Node node = Document.create(string, false, false).getRootNode();
            this.setMetaData(node);
            this.setCommonOptions(node);
            Node[] nodeArray = node.selectNodes(SUB_COMMAND_XPATH);
            CLIPSubCommand[] cLIPSubCommandArray = new CLIPSubCommand[nodeArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                cLIPSubCommandArray[n] = this.createSubCommand(nodeArray[n]);
                ++n;
            }
            this.clipParser = new CLIPParser(cLIPSubCommandArray, node.getAttributeValue(HELP));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setMetaData(Node node) {
        try {
            this.toolName = node.getAttributeValue(NAME);
            this.toolVersion = node.getAttributeValue("version");
            this.commandHandlerClassName = node.getAttributeValue(COMMAND_HANDLER);
            this.commandHandler = Class.forName(this.commandHandlerClassName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
            System.exit(0);
        }
    }

    private void setCommonOptions(Node node) throws Exception {
        ArrayList<CLIPOption> arrayList = new ArrayList<CLIPOption>();
        Node[] nodeArray = node.selectNodes(COMMON_OPTIONS_XPATH);
        int n = 0;
        while (n < nodeArray.length) {
            arrayList.add(CLIPSpec.createOption(nodeArray[n]));
            ++n;
        }
        this.commonOptions = arrayList.toArray(new CLIPOption[0]);
    }

    private CLIPSubCommand createSubCommand(Node node) throws Exception {
        return new CLIPSubCommand(node.getAttributeValue(NAME), this.getOptions(node), Integer.parseInt(node.getAttributeValue(MIN_OPERANDS)), Integer.parseInt(node.getAttributeValue(MAX_OPERANDS)), node.getAttributeValue(OPERANDS_HELP), node.getAttributeValue(HELP));
    }

    private CLIPOption[] getOptions(Node node) throws Exception {
        ArrayList<CLIPOption> arrayList = new ArrayList<CLIPOption>(Arrays.asList(this.commonOptions));
        Node[] nodeArray = Node.getChildNodes(node, "Option");
        int n = 0;
        while (n < nodeArray.length) {
            arrayList.add(CLIPSpec.createOption(nodeArray[n]));
            ++n;
        }
        return arrayList.toArray(CLIPOption.EMTPY_CLIP_OPTION_ARRAY);
    }

    private static CLIPOption createOption(Node node) throws Exception {
        return new CLIPOption(node.getAttributeValue(LONG_NAME), node.getAttributeValue(SHORT_NAME), CLIPSpec.getInteger(node.getAttributeValue(TYPE)), node.getAttributeValue(DEFAULT_VALUES), node.getAttributeValue(HELP));
    }

    public void doDefaultTasks(String[] stringArray) throws CLIPException {
        String string = CLIPParser.scanForStdExitOptions(stringArray);
        if (string != null && string.equals("--version")) {
            this.printVersionInfo();
        }
        this.clipParser.verifyArguments(stringArray);
        this.checkForHelp(stringArray);
    }

    private void printVersionInfo() {
        System.err.println(CLIPSpec.getLocaleHelper().getLocalizedString("versionName"));
        String[] stringArray = StringHelper.splitString(this.toolVersion, ".", 2);
        Object[] objectArray = new Object[]{stringArray[0], stringArray[1]};
        System.err.println(CLIPSpec.getLocaleHelper().getLocalizedString("versionNum", objectArray));
        System.err.println(CLIPSpec.getLocaleHelper().getLocalizedString("versionProduct"));
        System.err.println(CLIPSpec.getLocaleHelper().getLocalizedString("versionRelease"));
        System.err.println(CLIPSpec.getLocaleHelper().getLocalizedString("versionLegal"));
        System.exit(0);
    }

    private void checkForHelp(String[] stringArray) {
        if (this.clipParser.needsHelp(stringArray)) {
            System.out.println(this.clipParser.getHelp(stringArray));
            System.exit(0);
        }
    }

    public Object executeCommand(String[] stringArray) {
        try {
            CLIHandler cLIHandler = (CLIHandler)this.commandHandler.newInstance();
            return cLIHandler.executeCommand(this, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
            System.exit(0);
            return null;
        }
    }

    public String toString() {
        return "Tool Name: " + this.toolName + "\n" + this.clipParser.toString();
    }

    private static int getInteger(String string) {
        String string2 = string.trim();
        if (string2.equalsIgnoreCase("REGULAR")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("BOOLEAN")) {
            return 0;
        }
        return -1;
    }

    public static LocaleHelper getLocaleHelper() {
        return LocaleHelper.getLocaleHelper(localeBase);
    }

    private static String[] removeFirstTwoArguments(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length <= 2) {
            stringArray2 = Constants.EMPTY_STRING_ARRAY;
        } else {
            stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        }
        return stringArray2;
    }

    private static Locale findLocale(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if ((stringArray[n].equals("-l") || stringArray[n].equals("--locale")) && n < stringArray.length - 1) {
                Locale locale = LocaleHelper.getLocale(stringArray[n + 1]);
                return locale;
            }
            ++n;
        }
        return Locale.getDefault();
    }

    public static void main(String[] stringArray) throws CLIPException {
        String[] stringArray2 = CLIPSpec.setToolData(stringArray);
        String string = Resource.read(specFile);
        if (string.trim().length() == 0) {
            Debug.recordError("CLI Spec file: " + specFile + " not found or permisstion denied (contanct ips vendor)");
            System.exit(0);
        }
        CLIPSpec cLIPSpec = new CLIPSpec(string);
        cLIPSpec.doDefaultTasks(stringArray2);
        cLIPSpec.executeCommand(stringArray2);
    }

    public static String[] setToolData(String[] stringArray) {
        try {
            specFile = stringArray[0];
            localeBase = stringArray[1];
        }
        catch (Exception exception) {
            System.out.println("Script File should prepend two parms i.e 1.CLI Spec File Location and  2.Locale Base");
        }
        Debug.developerMessage("FileName:" + specFile);
        Debug.developerMessage("LocaleBase:" + localeBase);
        String[] stringArray2 = CLIPSpec.removeFirstTwoArguments(stringArray);
        if (stringArray2.length == 0) {
            stringArray2 = new String[]{"--help"};
        }
        Locale locale = CLIPSpec.findLocale(stringArray2);
        LocaleHelper.store(localeBase, locale);
        return stringArray2;
    }
}

