/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js;

import com.sun.portal.rewriter.Data;
import com.sun.portal.rewriter.DataRule;
import com.sun.portal.rewriter.RewriterTestInputs;
import com.sun.portal.rewriter.engines.js.JSDataRule;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class Function
extends JSDataRule {
    private Data name;
    private Data paramPatterns;
    private List parsedParamPatterns;

    public Function(String string, String string2, String string3) {
        super("Functions", string, "");
        this.name = new Data(StringHelper.normalize(string2));
        this.paramPatterns = new Data(StringHelper.normalize(string3));
    }

    public Function(Node node) {
        this(node.getAttributeValue("type"), node.getAttributeValue("name"), node.getAttributeValue("paramPatterns"));
    }

    public String getName() {
        return this.name.value;
    }

    public String getParamPatterns() {
        return this.paramPatterns.value;
    }

    private Collection getParsedPatterns() {
        if (this.parsedParamPatterns == null) {
            this.parsedParamPatterns = this.parseParamPatterns(this.paramPatterns.value);
        }
        return this.parsedParamPatterns;
    }

    private List parseParamPatterns(String string) {
        if (string.length() == 0) {
            return Constants.EMPTY_LIST;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        List list = DataRule.parsePatterns(string);
        int n = 0;
        while (n < list.size()) {
            arrayList.add(StringHelper.splitString(list.get(n).toString(), ","));
            ++n;
        }
        return arrayList;
    }

    public boolean matches(DataRule dataRule) {
        if (dataRule == null && !(dataRule instanceof Function)) {
            return false;
        }
        Function function = (Function)dataRule;
        if (this.getTypeCode() == function.getTypeCode()) {
            if (DataRule.match(this.name, function.getName())) {
                return true;
            }
        } else {
            Debug.error("Bug in JSParser Functions:Source Type : " + this.getType() + "With Object Type : " + function.getType());
        }
        return false;
    }

    public boolean isValid() {
        return DataRule.doBasicValidation(new String[]{this.name.value, this.paramPatterns.value});
    }

    public String[] getParamSpec(int n) {
        Object[] objectArray = Constants.EMPTY_STRING_ARRAY;
        if (this.getParsedPatterns().size() > 0) {
            objectArray = (String[])this.parsedParamPatterns.get(0);
        }
        if (n > objectArray.length) {
            Object[] objectArray2 = new String[n];
            Arrays.fill(objectArray2, "");
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("<").append("Function").append(" ").append("type").append("=").append("\"").append(this.getType()).append("\"").append(" ").append("name").append("=").append("\"").append(this.name).append("\"").append(" ").append("paramPatterns").append("=").append("\"").append(this.getParamPatterns()).append("\"").append(" ").append("/>").append("\n");
        return stringBuffer.toString();
    }

    public static Function cycleMatche(Function function, int n, String string, String string2) {
        function.name.value = string;
        function.setTypeCode(n);
        return function;
    }

    public static void main(String[] stringArray) {
        Function[] functionArray = RewriterTestInputs.defaultJSFunctions;
        int n = 0;
        while (n < functionArray.length) {
            Debug.println(functionArray[n].toXML());
            ++n;
        }
    }
}

