/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.html;

import com.sun.portal.rewriter.DataRuleCollection;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.CompositeRewriter;
import com.sun.portal.rewriter.engines.common.Attribute;
import com.sun.portal.rewriter.engines.html.Applet;
import com.sun.portal.rewriter.engines.html.Form;
import com.sun.portal.rewriter.engines.html.HTMLRules;
import com.sun.portal.rewriter.engines.html.JSToken;
import java.util.List;

public final class HTMLRewriter
extends AbstractRewriter {
    private final DataRuleCollection htmlFormRules;
    private final DataRuleCollection htmlAppletRules;
    private final DataRuleCollection htmlAttributeRules;
    private final DataRuleCollection htmlJSTokenRules;

    public HTMLRewriter(CompositeRewriter compositeRewriter, RuleSet ruleSet) {
        super(compositeRewriter, ruleSet, "text/html");
        HTMLRules hTMLRules = this.ruleSet.getHTMLRules();
        this.htmlFormRules = hTMLRules.getForms();
        this.htmlAppletRules = hTMLRules.getApplets();
        this.htmlAttributeRules = hTMLRules.getAttributes();
        this.htmlJSTokenRules = hTMLRules.getJSTokens();
    }

    protected String plugableRewriter(String string, Translator translator) {
        return this.parseHTML(string, translator);
    }

    private String parseHTML(String string, Translator translator) {
        return this.getCompositeRewriter().getUniversalRewriter().rewrite(string, translator);
    }

    public boolean formMatch(Form form, List list) {
        Form form2 = (Form)this.htmlFormRules.findMatch(form);
        if (form2 != null) {
            list.addAll(form2.getParsedPatterns());
            return true;
        }
        return false;
    }

    public boolean appletMatch(Applet applet, List list) {
        Applet applet2 = (Applet)this.htmlAppletRules.findMatch(applet);
        if (applet2 != null) {
            list.addAll(applet2.getParsedPatterns());
            return true;
        }
        return false;
    }

    public boolean attributeMatch(Attribute attribute, List list) {
        Attribute attribute2 = (Attribute)this.htmlAttributeRules.findMatch(attribute);
        if (attribute2 != null) {
            list.addAll(attribute2.getParsedPatterns());
            return true;
        }
        return false;
    }

    public boolean jsTokenMatch(JSToken jSToken) {
        return this.htmlJSTokenRules.contains(jSToken);
    }

    public String parseSPAN(String string, Translator translator) {
        String string2 = string.trim();
        if (string2.startsWith("http://") || string2.startsWith("https://")) {
            return translator.convert2Absolute(string);
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

