/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SmartMap
implements Map {
    private Map originalMap = null;
    private ThreadLocal mapCopies = new ThreadLocal();

    private SmartMap() {
    }

    public SmartMap(Map m) {
        this.originalMap = m;
    }

    protected void copyIfNecessary() {
        HashMap m = this.getCopiedMap();
        if (m == null) {
            m = new HashMap(this.originalMap);
            this.mapCopies.set(m);
        }
    }

    protected Map getCopiedMap() {
        Map m = (Map)this.mapCopies.get();
        return m;
    }

    public Map getMap() {
        Map m = this.getCopiedMap();
        if (m == null) {
            m = this.originalMap;
        }
        return m;
    }

    public void revert() {
        this.mapCopies.set(null);
    }

    public void evolve() {
        this.originalMap = this.getMap();
    }

    public boolean isCopied() {
        return this.getCopiedMap() != null;
    }

    public Map cloneOriginalMap() {
        return new HashMap(this.originalMap);
    }

    public void clear() {
        this.copyIfNecessary();
        this.getMap().clear();
    }

    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    public boolean containsValue(Object val) {
        return this.getMap().containsValue(val);
    }

    public Set entrySet() {
        return this.getMap().entrySet();
    }

    public Object get(Object key) {
        return this.getMap().get(key);
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public Set keySet() {
        return this.getMap().keySet();
    }

    public Object put(Object key, Object val) {
        this.copyIfNecessary();
        return this.getMap().put(key, val);
    }

    public void putAll(Map t) {
        this.copyIfNecessary();
        this.getMap().putAll(t);
    }

    public Object remove(Object key) {
        this.copyIfNecessary();
        return this.getMap().remove(key);
    }

    public int size() {
        return this.getMap().size();
    }

    public Collection values() {
        return this.getMap().values();
    }

    public String toString() {
        String s = this.getMap().toString();
        if (this.getCopiedMap() != null) {
            String id = Thread.currentThread().getName();
            s = s + " (copied, id=" + id + ")";
        } else {
            s = s + " (original)";
        }
        return s;
    }
}

