/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextFactory;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.context.SessionEvent;
import com.sun.portal.desktop.context.SessionListener;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class PSDesktopContextFactory
implements DesktopContextFactory,
SessionListener {
    private HashMap desktopContexts = new HashMap();
    protected DesktopAppContext desktopAppContext = null;
    protected ServletConfig initConfig = null;

    public void init(ServletConfig sc) {
        this.initConfig = sc;
        this.initDesktopAppContext();
    }

    public DesktopAppContext getDesktopAppContext() {
        if (this.desktopAppContext == null) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): not initialized");
        }
        DesktopAppContextThreadLocalizer.set(this.desktopAppContext);
        return this.desktopAppContext;
    }

    protected synchronized void initDesktopAppContext() {
        String desktopAppContextClassName = this.initConfig.getInitParameter("desktopAppContextClassName");
        if (desktopAppContextClassName == null) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): could not get desktop app context class name");
        }
        try {
            this.desktopAppContext = (DesktopAppContext)Class.forName(desktopAppContextClassName).newInstance();
            this.desktopAppContext.init(this.initConfig);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", iae);
        }
        catch (ClassCastException cce) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", cce);
        }
        catch (InstantiationException ie) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", ie);
        }
        catch (SecurityException se) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", se);
        }
    }

    public DesktopContext getDesktopContext(HttpServletRequest req) {
        DesktopContext context = null;
        int i = PerfThreadLocalizer.mark();
        String sid = this.desktopAppContext.getSessionID(req);
        context = (DesktopContext)this.desktopContexts.get(sid);
        if (context == null) {
            HashMap hashMap = this.desktopContexts;
            synchronized (hashMap) {
                context = (DesktopContext)this.desktopContexts.get(sid);
                if (context == null) {
                    String desktopContextClassName = this.desktopAppContext.getDesktopContextClassName();
                    try {
                        context = (DesktopContext)Class.forName(desktopContextClassName).newInstance();
                        context.init(req);
                        context.addSessionListener(this);
                        this.desktopContexts.put(sid, context);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", cnfe);
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", ncdfe);
                    }
                    catch (IllegalAccessException iae) {
                        throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", iae);
                    }
                    catch (ClassCastException cce) {
                        throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", cce);
                    }
                    catch (InstantiationException ie) {
                        throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", ie);
                    }
                    catch (SecurityException se) {
                        throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", se);
                    }
                }
            }
        }
        context.setLastAccess(System.currentTimeMillis());
        DesktopContextThreadLocalizer.set(context);
        ProviderContextThreadLocalizer.set(context.getContainerProviderContext());
        PerfThreadLocalizer.add(i, "PSDesktopContextFactory.getDesktopContext()");
        return context;
    }

    public synchronized void sessionDestroyed(SessionEvent se) {
        String sid = se.getSessionID();
        HashMap hashMap = this.desktopContexts;
        synchronized (hashMap) {
            this.desktopContexts.remove(sid);
        }
    }
}

