/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.util.GWDebug;

public class SessionKeepAlive
implements Runnable {
    private long activateTime = 0L;
    private boolean status = true;
    private NetletGroupManager manager = null;
    private long maxIdleTime = 0L;
    private final long interval = 100L;

    public SessionKeepAlive(NetletGroupManager ng, long idleTime) {
        this.maxIdleTime = idleTime;
        this.manager = ng;
        this.init();
    }

    private void init() {
        this.maxIdleTime *= 60000L;
        this.activateTime = this.maxIdleTime / 100L;
    }

    public void run() {
        long calculatedTime = 0L;
        NetletGroup userNetletTraffic = null;
        long checkTime = 2L * this.activateTime + 5L;
        SSOTokenManager ssoTokenManager = null;
        try {
            ssoTokenManager = SSOTokenManager.getInstance();
        }
        catch (SSOException se) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SessionKeepAlive: Unable to get SSOTokenManager instance -> " + (Object)((Object)se));
            }
            this.status = false;
        }
        while (this.status) {
            try {
                String[] ssoTokenIDs = NetletGroupManager.getRegisteredSessions();
                int i = 0;
                while (i < ssoTokenIDs.length) {
                    String ssoTokenID = ssoTokenIDs[i];
                    if (ssoTokenID != null && ssoTokenID.trim().length() != 0) {
                        userNetletTraffic = NetletGroupManager.getNetletGroup(ssoTokenID);
                        if (System.currentTimeMillis() - userNetletTraffic.getUserLoginTime() >= userNetletTraffic.getMaxSessionTime()) {
                            NetletGroupManager.unregister(ssoTokenID);
                        } else {
                            calculatedTime = System.currentTimeMillis() - userNetletTraffic.getLastActivityTime();
                            if (calculatedTime < checkTime) {
                                if (userNetletTraffic.needToExtend()) {
                                    SSOToken token = null;
                                    try {
                                        token = ssoTokenManager.createSSOToken(ssoTokenID);
                                    }
                                    catch (SSOException ssoe) {
                                        token = null;
                                    }
                                    if (!(token != null && ssoTokenManager.isValidToken(token) || userNetletTraffic.getNetletRunUponLogout())) {
                                        NetletGroupManager.unregister(ssoTokenID);
                                    }
                                }
                            } else if (calculatedTime >= this.maxIdleTime) {
                                NetletGroupManager.unregister(ssoTokenID);
                            }
                        }
                    } else {
                        NetletGroupManager.unregister(ssoTokenID);
                    }
                    ++i;
                }
                Thread.sleep(this.activateTime);
            }
            catch (InterruptedException ie) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("SessionKeepAlive: Caught interrrupted exception -> " + ie);
                }
                this.status = false;
            }
        }
    }
}

