/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.FtpFile;
import com.sun.portal.netfile.servlet.NetFileContext;
import com.sun.portal.netfile.servlet.NetFileContextImpl;
import com.sun.portal.netfile.servlet.NetFileLogManager;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.servlet.NetFileServlet;
import com.sun.portal.netfile.servlet.NetWareFile;
import com.sun.portal.netfile.servlet.NfsFile;
import com.sun.portal.netfile.servlet.SerializedRequestProcessor;
import com.sun.portal.netfile.servlet.WinFile;
import com.sun.portal.netfile.shared.NetFileException;
import com.sun.portal.netfile.transport.NetFileRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetFileUploadServlet
extends HttpServlet {
    private Debug debug = null;
    private NetFileLogManager lm_log_manager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        if (this.lm_log_manager == null) {
            this.lm_log_manager = NetFileServlet.logManager;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGetPost(request, response);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGetPost(HttpServletRequest request, HttpServletResponse response) {
        manager = null;
        ssoToken = null;
        nfContext = null;
        nfRes = null;
        nfReq = null;
        pathInfo = null;
        s_temp_local_file = null;
        f_temp_local_file = null;
        oops_to_applet = null;
        ht_request_parameters = null;
        s_machine_encoding = null;
        locale = null;
        s_temporary_directory = null;
        s_destination_file = null;
        o_temp_local_file = null;
        ba_file_block = null;
        message = null;
        isException = false;
        try {
            block44: {
                block42: {
                    block43: {
                        block41: {
                            block40: {
                                block39: {
                                    oips_from_applet = new ObjectInputStream((InputStream)request.getInputStream());
                                    serialRequest = (Serializable[])oips_from_applet.readObject();
                                    if (serialRequest != null) break block39;
                                    var31_26 = null;
                                    ** GOTO lbl177
                                }
                                nfReq = (NetFileRequest)serialRequest[0];
                                if (nfReq != null) break block40;
                                ** GOTO lbl183
                            }
                            seqNo = (Long)nfReq.getParameter("UploadSequenceNumber");
                            if (seqNo != null) break block41;
                            ** GOTO lbl190
                        }
                        ht_request_parameters = new Hashtable<String, String>();
                        if (seqNo != 1L) break block42;
                        try {
                            s_machine_encoding = (String)nfReq.getParameter("CharSet");
                            locale = (String)nfReq.getParameter("Locale");
                        }
                        catch (NetFileException nfe) {
                            this.writeErrorDebug("Exception in getting parameters from request", nfe);
                        }
                        nfRes = this.getUserLocaleBundle(locale);
                        manager = SSOTokenManager.getInstance();
                        ssoToken = manager.createSSOToken(this.extractSession(request));
                        nfContext = new NetFileContextImpl(ssoToken);
                        if (this.validateSession(request, ssoToken, nfContext)) break block43;
                        ** GOTO lbl197
                    }
                    s_temporary_directory = (String)nfReq.getParameter("sunPortalNetFileTempDir");
                    this.writeDebug("Temporary directory=" + s_temporary_directory);
                    s_destination_file = (String)nfReq.getParameter("FileName");
                    o_temp_local_file = nfReq.getParameter("s_temp_local_file");
                    if (o_temp_local_file == null) {
                        s_temp_local_file = new Long(System.currentTimeMillis()).toString() + s_destination_file;
                        try {
                            localTempFile = new File(s_temporary_directory);
                            if (!localTempFile.exists()) {
                                localTempFile.mkdirs();
                            }
                            s_temp_local_file = localTempFile.getAbsolutePath() + File.separator + s_temp_local_file;
                        }
                        catch (Exception e) {
                            this.writeErrorDebug("Error creating temp directory", e);
                            throw new NetFileException(500, "<html>Could not obtain file as the directory to hold temprary files <br> could not be created. Please seek administrator's assistance</html>");
                        }
                        smbLocation = (String)nfReq.getParameter("sunPortalNetFileSMBClientLocation");
                        mimeLocation = (String)nfReq.getParameter("sunPortalNetFileMimetypesConfigFileLocation");
                        pathInfo = new String[]{smbLocation, mimeLocation};
                        f = new File(s_temp_local_file);
                        if (!f.exists()) {
                            f.createNewFile();
                        }
                        try {
                            message = this.moveFile(s_temp_local_file, nfRes, s_machine_encoding, s_temporary_directory, nfReq, ssoToken, pathInfo);
                            if (!message.startsWith("ERROR:")) ** GOTO lbl90
                            isException = true;
                        }
                        catch (NetFileException e) {
                            this.writeErrorDebug("Exception in moving file to destination server", e);
                            isException = true;
                            throw e;
                        }
                    }
                    break block44;
                }
                o_temp_local_file = nfReq.getParameter("s_temp_local_file");
                s_temp_local_file = (String)o_temp_local_file;
            }
            ba_file_block = (byte[])nfReq.getRequestObject();
            bytesReadOnClient = (Integer)nfReq.getParameter("BytesReadOnClient");
            b_is_last_block = (Boolean)nfReq.getParameter("b_is_final_request");
            is_last_block = b_is_last_block;
            this.writeDebug("Local file=" + s_temp_local_file);
            if (bytesReadOnClient >= 0 && !isException) {
                this.writeDebug("Bytes to be written to local file are " + bytesReadOnClient);
                f = new File(s_temp_local_file);
                if (!f.exists()) {
                    f.createNewFile();
                }
                fops_temp_local_file = new FileOutputStream(f.getAbsolutePath(), true);
                fops_temp_local_file.write(ba_file_block, 0, bytesReadOnClient);
                fops_temp_local_file.close();
            }
            if (is_last_block) {
                manager = SSOTokenManager.getInstance();
                ssoToken = manager.createSSOToken(this.extractSession(request));
                nfContext = new NetFileContextImpl(ssoToken);
                try {
                    s_machine_encoding = (String)nfReq.getParameter("CharSet");
                    locale = (String)nfReq.getParameter("Locale");
                }
                catch (NetFileException nfe) {
                    this.writeErrorDebug("Exception in getting parameters from request", nfe);
                }
                smbLocation = (String)nfReq.getParameter("sunPortalNetFileSMBClientLocation");
                mimeLocation = (String)nfReq.getParameter("sunPortalNetFileMimetypesConfigFileLocation");
                pathInfo = new String[]{smbLocation, mimeLocation};
                s_temporary_directory = (String)nfReq.getParameter("sunPortalNetFileTempDir");
                nfRes = this.getUserLocaleBundle(locale);
                this.writeDebug("Temporary directory=" + s_temporary_directory);
                try {
                    message = this.moveFile(s_temp_local_file, nfRes, s_machine_encoding, s_temporary_directory, nfReq, ssoToken, pathInfo);
                }
                catch (NetFileException e) {
                    this.writeDebug("Exception in moving file to destination server", e);
                    throw e;
                }
            }
            if (message != null) {
                ht_request_parameters.put("Status", message);
            } else {
                ht_request_parameters.put("Status", "OK");
            }
            ht_request_parameters.put("s_temp_local_file", s_temp_local_file);
            this.writeDebug("Going to write to the applet");
            ops_to_applet = response.getOutputStream();
            oops_to_applet = new ObjectOutputStream((OutputStream)ops_to_applet);
            oops_to_applet.writeObject(ht_request_parameters);
            oops_to_applet.flush();
            ** GOTO lbl204
        }
        catch (Throwable e) {
            if (nfRes == null) {
                if (locale == null) {
                    try {
                        locale = (String)nfReq.getParameter("Locale");
                    }
                    catch (NetFileException nfe) {
                        this.writeErrorDebug("Exception in getting locale parameter from request", nfe);
                    }
                    if (locale == null) {
                        locale = Locale.getDefault().toString();
                    }
                }
                try {
                    nfRes = this.getUserLocaleBundle(locale);
                }
                catch (Throwable thr) {
                    this.writeDebug("Could not obtain resource bundle to report exception");
                }
                if (s_temp_local_file != null) {
                    f_temp_local_file = new File(s_temp_local_file);
                }
                this.doCleanUp(f_temp_local_file);
            }
            this.processException(ht_request_parameters, nfRes, e, s_machine_encoding, oops_to_applet);
            var31_31 = null;
            try {
                oops_to_applet.close();
                return;
            }
            catch (Exception e) {
                this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
                return;
            }
        }
        {
            catch (Throwable var30_52) {
                var31_32 = null;
                ** try [egrp 9[TRYBLOCK] [9 : 1098->1106)] { 
lbl172:
                // 1 sources

                oops_to_applet.close();
                throw var30_52;
lbl174:
                // 1 sources

                catch (Exception e) {
                    this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
                }
                throw var30_52;
            }
lbl177:
            // 1 sources

            ** try [egrp 9[TRYBLOCK] [9 : 1098->1106)] { 
lbl178:
            // 1 sources

            oops_to_applet.close();
            return;
lbl180:
            // 1 sources

            catch (Exception e) {
                this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
            }
            return;
lbl183:
            // 1 sources

            var31_27 = null;
            ** try [egrp 9[TRYBLOCK] [9 : 1098->1106)] { 
lbl185:
            // 1 sources

            oops_to_applet.close();
            return;
lbl187:
            // 1 sources

            catch (Exception e) {
                this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
            }
            return;
lbl190:
            // 1 sources

            var31_28 = null;
            ** try [egrp 9[TRYBLOCK] [9 : 1098->1106)] { 
lbl192:
            // 1 sources

            oops_to_applet.close();
            return;
lbl194:
            // 1 sources

            catch (Exception e) {
                this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
            }
            return;
lbl197:
            // 1 sources

            var31_29 = null;
            ** try [egrp 9[TRYBLOCK] [9 : 1098->1106)] { 
lbl199:
            // 1 sources

            oops_to_applet.close();
            return;
lbl201:
            // 1 sources

            catch (Exception e) {
                this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
            }
            return;
lbl204:
            // 1 sources

            var31_30 = null;
            try {}
            catch (Exception e) {}
            this.debug.error("NetFileUploadServlet:Error in writing to applet " + e);
            return;
            oops_to_applet.close();
            return;
        }
    }

    private void processException(Hashtable ht_request_parameters, NetFileResource nfRes, Throwable e, String s_machine_encoding, ObjectOutputStream oops_to_applet) {
        block9: {
            try {
                String message = null;
                this.writeErrorDebug("Exception uploading a file", (Exception)e);
                if (e instanceof NetFileException) {
                    if (s_machine_encoding == null) {
                        s_machine_encoding = "UTF8";
                    }
                    this.writeDebug("Message from=" + message);
                    if (nfRes != null) {
                        // empty if block
                    }
                    this.writeDebug("Message from=" + message);
                }
                if (ht_request_parameters == null) {
                    throw new Exception("ht_request_parameters is null");
                }
                if (oops_to_applet != null) {
                    try {
                        ht_request_parameters.put("s_status", "ERROR:" + message);
                        this.writeDebug("Sending " + ht_request_parameters);
                        oops_to_applet.writeObject(ht_request_parameters);
                        oops_to_applet.flush();
                        this.writeDebug("Sent the message");
                    }
                    catch (Exception ex) {
                        this.writeErrorDebug("Exception sending error message after exception in upload of file", ex);
                    }
                }
            }
            catch (Exception ex) {
                if (!this.debug.messageEnabled()) break block9;
                this.writeErrorDebug("Exception logging exception in upload of file", ex);
            }
        }
        this.writeDebug("Processing error over");
    }

    private void doCleanUp(File serverTempFile) {
        if (serverTempFile != null && serverTempFile.exists()) {
            serverTempFile.delete();
        }
    }

    private String moveFile(String s_temp_local_file, NetFileResource nfRes, String s_machine_encoding, String tempDir, NetFileRequest nfReq, SSOToken ssoToken, String[] pathInfo) throws Throwable {
        String message = "ERROR:Unable to upload file";
        String s_destination_file = (String)nfReq.getParameter("FileName");
        String s_temporary_directory = tempDir;
        String domain = (String)nfReq.getParameter("NTDomName");
        String machine = (String)nfReq.getParameter("SystemName");
        String type = (String)nfReq.getParameter("SysType");
        String user_name = (String)nfReq.getParameter("UserID");
        String directory = (String)nfReq.getParameter("Dir");
        String share = (String)nfReq.getParameter("ShareName");
        String password = (String)nfReq.getParameter("SharePwd");
        this.writeDebug("Uploading file:" + s_temp_local_file);
        message = this.uploadFile(user_name, password, machine, domain, type, directory, share, s_temp_local_file, s_destination_file, s_temporary_directory, nfRes, s_machine_encoding, ssoToken, pathInfo);
        this.writeDebug("Message from FileOption=" + message);
        return message;
    }

    String uploadFile(String usernam, String passwrd, String machnam, String domainname, String machtyp, String dir, String VMSnam, String localfilenam, String remotefilename, String tempdir, NetFileResource nfRes, String s_machine_encoding, SSOToken ssoToken, String[] pathInfo) throws NetFileException {
        String text = "";
        this.writeDebug("username=" + usernam + ",machnam=" + machnam + ",machtyp=" + machtyp + ",VMSnam=" + VMSnam + ",remotefilename=" + remotefilename + ",dir=" + dir + ",tempdir=" + tempdir + ",domainname=" + domainname + ",localfilenam=" + localfilenam);
        try {
            if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                WinFile ppf = new WinFile(this.lm_log_manager, s_machine_encoding, ssoToken, pathInfo);
                text = ppf.putPCFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, domainname, nfRes);
            } else if (machtyp.indexOf("FTP", 0) >= 0) {
                FtpFile pff = new FtpFile(this.lm_log_manager, s_machine_encoding);
                text = pff.putFTPFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, nfRes);
            } else if (machtyp.indexOf("NFS", 0) >= 0) {
                NfsFile pnff = new NfsFile(this.lm_log_manager, s_machine_encoding);
                text = pnff.putNFSFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, tempdir, nfRes);
            } else if (machtyp.indexOf("NETWARE", 0) >= 0) {
                NetWareFile nff = new NetWareFile(this.lm_log_manager, s_machine_encoding);
                text = nff.putFTPFile(usernam, passwrd, machnam, VMSnam, localfilenam, remotefilename, dir, nfRes);
            }
        }
        catch (Exception e) {
            text = "ERROR:" + e.getMessage();
            this.writeErrorDebug("Error putting a file", e);
        }
        this.writeDebug("Upload file result=" + text);
        return text;
    }

    private boolean validateSession(HttpServletRequest req, SSOToken ssoToken, NetFileContext nfContext) {
        String nfid = null;
        String session = null;
        nfid = req.getHeader("nfid");
        Cookie[] cookie = req.getCookies();
        if (cookie == null) {
            return false;
        }
        if (nfid == null) {
            return false;
        }
        int i = 0;
        while (i < cookie.length) {
            if (cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) {
                session = cookie[i].getValue();
            }
            ++i;
        }
        if (session == null || session.equals("")) {
            return false;
        }
        if (session.equals(nfid)) {
            try {
                if (ssoToken == null) {
                    return false;
                }
                return nfContext.isSessionValid(ssoToken) && nfContext.isExecutable();
            }
            catch (Exception e) {
                this.writeErrorDebug("General Exception in NetFileUploadServlet", e);
                return false;
            }
        }
        return false;
    }

    private String extractSession(HttpServletRequest req) {
        String session = null;
        Cookie[] cookie = req.getCookies();
        if (cookie != null) {
            int i = 0;
            while (i < cookie.length) {
                if (cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) {
                    session = cookie[i].getValue();
                }
                ++i;
            }
        }
        return session;
    }

    private NetFileResource getUserLocaleBundle(String s_locale) throws Throwable {
        NetFileResource nfRes = null;
        nfRes = SerializedRequestProcessor.getResourceMap(s_locale, "srapNetFileServletJava2");
        if (nfRes == null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("NetFile resource object for bundle srapNetFileServletJava2 not found in resource map for locale " + s_locale);
            }
            nfRes = new NetFileResource("srapNetFileServletJava2", s_locale);
        } else if (this.debug.messageEnabled()) {
            this.debug.message("NetFile resource object for bundle srapNetFileServletJava2 found in resource map for locale " + s_locale);
        }
        return nfRes;
    }

    protected void writeDebug(String szMsg) {
        this.writeDebug(szMsg, null);
    }

    protected void writeDebug(String szMsg, Exception e) {
        if (this.debug != null && this.debug.messageEnabled()) {
            if (e != null) {
                this.debug.message(szMsg, (Throwable)e);
            } else {
                this.debug.message(szMsg);
            }
        }
    }

    protected void writeErrorDebug(String szError, Exception e) {
        if (this.debug != null) {
            if (e != null) {
                this.debug.error(szError, (Throwable)e);
            } else {
                this.debug.error(szError);
            }
        }
    }
}

