/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.sun.portal.netfile.shared.NetFileException;
import com.sun.portal.netfile.transport.NetFileResponse;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetFileResponseGenerator {
    HttpServletRequest request;
    HttpServletResponse response;
    Vector requestData;
    Object responseData;
    NetFileResponse nfResp;

    public NetFileResponseGenerator(HttpServletRequest req, HttpServletResponse res, Vector reqData, Object respData) throws NetFileException {
        this.request = req;
        this.response = res;
        this.requestData = reqData;
        this.responseData = respData;
    }

    public void generateResponse(ObjectOutputStream oos) throws NetFileException {
        try {
            if (oos == null) {
                throw new NetFileException(6, "Object Output Stream could not be obtained.");
            }
            oos.writeObject(this.nfResp);
            oos.close();
        }
        catch (StreamCorruptedException ste) {
            ste.printStackTrace();
            throw new NetFileException(6, "Object Output Stream could not be obtained.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new NetFileException(6, "Object Output Stream could not be obtained.");
        }
    }

    public void createDefaultResponse() throws NetFileException {
        this.nfResp = new NetFileResponse((String)this.requestData.get(0), (String)this.requestData.get(1));
    }

    public void createDefaultFailureResponse() throws NetFileException {
        this.nfResp = new NetFileResponse((String)this.requestData.get(0), (String)this.requestData.get(1));
        this.nfResp.setNetFileResponseType(2100);
        this.nfResp.setNetFileResponseObject(this.responseData);
    }

    public void setResponseType(int i) {
        this.nfResp.setNetFileResponseType(i);
    }

    public void setResponseObject(Object o) {
        this.nfResp.setNetFileResponseObject(o);
    }

    public void setNetFileResponse(Object o) {
        this.nfResp = (NetFileResponse)o;
    }

    public boolean isResponseObjectSet() {
        if (this.nfResp == null) {
            return false;
        }
        return this.nfResp.getNetFileResponseType() > 0;
    }
}

