/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.notes;

import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotesProvider
extends ProfileProviderAdapter {
    private File motdFile = null;
    private String editContainer = null;
    private String container = null;
    private static final String FIRST_NAME = "givenname";
    private static final String LAST_NAME = "sn";
    private ResourceBundle bundle = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File getLock() throws ProviderException {
        int timeout = 100;
        File lockFile = new File(this.getStringProperty("location") + ".lock");
        try {
            try {
                while (!lockFile.createNewFile()) {
                    NotesProvider notesProvider = this;
                    synchronized (notesProvider) {
                        this.wait(timeout);
                    }
                    timeout *= 2;
                }
            }
            catch (IOException ioe) {
                File file = null;
                Object var6_6 = null;
                if (lockFile == null) return file;
                lockFile.delete();
                return file;
            }
            catch (InterruptedException ie) {
                this.getProviderContext().debugError("NotesProvider.getContent()", ie);
                throw new ProviderException(" Error while waiting to read the notes file");
            }
            Object var6_5 = null;
            if (lockFile != null) {
                lockFile.delete();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (lockFile != null) {
                lockFile.delete();
            }
            throw throwable;
        }
        lockFile.deleteOnExit();
        return lockFile;
    }

    /*
     * Loose catch block
     */
    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        File lockFile;
        StringBuffer content;
        block29: {
            StringBuffer stringBuffer;
            BufferedReader in;
            block27: {
                TimeZone tz;
                Locale locale;
                int lines;
                block26: {
                    content = new StringBuffer();
                    this.motdFile = new File(this.getStringProperty("location"));
                    try {
                        this.motdFile.createNewFile();
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                    String readLines = this.getStringProperty("lines");
                    lines = Integer.parseInt(readLines);
                    locale = null;
                    locale = this.getProviderContext().getLocale();
                    String timezone = this.getStringProperty("timezone");
                    tz = TimeZone.getTimeZone(timezone);
                    if (this.bundle == null) {
                        this.bundle = this.getResourceBundle();
                    }
                    lockFile = this.getLock();
                    in = null;
                    try {
                        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.motdFile), "UTF-8"));
                        stringBuffer = null;
                        if (lockFile == null) break block26;
                        lockFile.delete();
                    }
                    catch (Throwable throwable) {
                        Object var14_13 = null;
                        if (lockFile != null) {
                            lockFile.delete();
                        }
                        throw throwable;
                    }
                    {
                        break block26;
                        catch (UnsupportedEncodingException uec) {
                            this.getProviderContext().debugError("NotesProvider.getContent()", uec);
                            throw new ProviderException("error creating input stream", uec);
                        }
                        catch (FileNotFoundException fnfe) {
                            this.getProviderContext().debugError("NotesProvider.getContent()", fnfe);
                            throw new ProviderException("error creating input stream", fnfe);
                        }
                    }
                }
                String line = null;
                String fontFace = this.getStringProperty("fontFace1");
                content.append("<table border=0 width=\"100%\" cellpadding=1 cellspacing=1>\n");
                MessageFormat mf = new MessageFormat("");
                int i = 0;
                while (i < lines) {
                    line = in.readLine();
                    if (line == null) {
                        line = "";
                    }
                    String darkColor = this.bundle.getString("darkColor");
                    String lightColor = this.bundle.getString("lightColor");
                    String bgColor = null;
                    bgColor = i % 2 == 0 ? lightColor : darkColor;
                    StringBuffer row = new StringBuffer();
                    StringTokenizer tok = new StringTokenizer(line, "|");
                    row.append("<tr>\n");
                    String dateMessage = this.bundle.getString("dateMessage");
                    mf.setLocale(locale);
                    mf.applyPattern(dateMessage);
                    ((DateFormat)mf.getFormats()[0]).setTimeZone(tz);
                    StringBuffer uid = new StringBuffer(128);
                    StringBuffer date = new StringBuffer(128);
                    StringBuffer msg = new StringBuffer();
                    String textColor = this.bundle.getString("textColor");
                    try {
                        String user = (String)tok.nextElement();
                        uid.append("<font FACE=").append("\"" + fontFace + "\" ").append("size=\"-1\" color=\"").append(textColor).append("\">").append(user).append("</font>\n");
                        String time = (String)tok.nextElement();
                        long ms = new Long(time);
                        Date d = new Date(ms);
                        String formattedDateString = mf.format(new Object[]{d}, new StringBuffer(), (FieldPosition)null).toString();
                        date.append("<font FACE=").append("\"" + fontFace + "\" ").append("size=\"-1\" color=\"").append(textColor).append("\">").append(formattedDateString).append("</font>\n");
                        String message = (String)tok.nextElement();
                        msg.append("<font FACE=").append("\"" + fontFace + "\" ").append("size=\"-1\" color=\"").append(textColor).append("\">").append(message).append("</font>\n");
                    }
                    catch (NoSuchElementException e) {
                        uid.append("<font FACE=").append("\"" + fontFace + "\" ").append("size=\"-1\" color=\"").append(bgColor).append("\">EMPTY</font>\n");
                        date.append("<font FACE=").append("\"" + fontFace + "\" ").append("size=\"-1\" color=\"").append(bgColor).append("\">EMPTY</font>\n");
                        msg.append("<font FACE=").append("\"" + fontFace + "\" ").append("size=\"-1\" color=\"").append(bgColor).append("\">EMPTY</font>\n");
                    }
                    row.append("<td width=\"10%\" align=\"left\" bgcolor=\"").append(bgColor).append("\">\n").append((Object)uid).append("\n").append("</td>\n").append("<td width=\"20%\" align=\"left\" bgcolor=\"").append(bgColor).append("\">\n").append((Object)date).append("\n").append("</td>\n").append("<td width=\"70%\" align=\"left\" bgcolor=\"").append(bgColor).append("\">\n").append((Object)msg).append("\n").append("</td>\n");
                    content.append("</tr>\n");
                    content.append((Object)row);
                    ++i;
                }
                Object var33_39 = null;
                if (in == null) break block27;
                try {
                    in.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            if (lockFile != null) {
                lockFile.delete();
            }
            break block29;
            {
                catch (IOException ioe) {
                    stringBuffer = null;
                    Object var33_40 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    if (lockFile != null) {
                        lockFile.delete();
                    }
                    return stringBuffer;
                }
            }
            catch (Throwable throwable) {
                Object var33_41 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                if (lockFile != null) {
                    lockFile.delete();
                }
                throw throwable;
            }
        }
        content.append("</table>\n");
        lockFile.delete();
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        this.editContainer = req.getParameter("provider");
        this.container = req.getParameter("containerName");
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        String newMessage = this.bundle.getString("newMessage");
        String lines = "";
        String message = "";
        if (req.getParameter("error") != null) {
            if (req.getParameter("lines") != null) {
                lines = req.getParameter("lines");
            }
            if (req.getParameter("message") != null) {
                message = req.getParameter("message");
            }
        } else {
            lines = this.getStringProperty("lines");
        }
        String fontFace = this.getStringProperty("fontFace1");
        Integer maxLines = new Integer(this.getStringProperty("maxLines"));
        String linesToDisplay = this.bundle.getString("linesToDisplay");
        MessageFormat mf = new MessageFormat(linesToDisplay);
        Locale locale = null;
        locale = this.getProviderContext().getLocale();
        mf.setLocale(locale);
        String formattedLinesToDisplay = mf.format(new Object[]{maxLines}, new StringBuffer(), (FieldPosition)null).toString();
        content.append("<TABLE>").append("<TR><TD>").append("<FONT FACE=\"" + fontFace + "\" SIZE=\"+0\">").append("<B>").append("<LABEL FOR=\"newmessage\">").append(newMessage).append("</LABEL>").append("</B>").append("</FONT></TD>").append("<TD>\n").append("<font FACE=\"" + fontFace + "\" ").append("size=\"-1\">\n").append("<INPUT TYPE=TEXT NAME=\"message\"  VALUE=\"").append(message).append("\" SIZE=60 ID=\"newmessage\">").append("</font></TD></TR>").append("<TR><TD>").append("<FONT FACE=\"" + fontFace + "\" ").append("SIZE=\"+0\">\n").append("<B>").append("<LABEL FOR=\"linestodisplay\">").append(formattedLinesToDisplay).append("</LABEL>").append("</B>").append("</FONT></TD>").append("<TD>\n").append("<font FACE=\"" + fontFace + "\" ").append("size=\"-1\">\n").append("<INPUT TYPE=TEXT NAME=\"lines\" VALUE=\"").append(lines).append("\" SIZE=4 ID=\"linestodisplay\">\n").append("</font></TD></TR>").append("</TABLE>\n");
        return content;
    }

    /*
     * Loose catch block
     */
    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        File lockFile;
        block42: {
            ArrayList<String> v;
            PrintWriter pw;
            String line;
            String msg;
            block43: {
                BufferedReader in;
                block40: {
                    block39: {
                        this.getProviderContext().contentChanged(this.getName());
                        msg = req.getParameter("message");
                        String lines = req.getParameter("lines");
                        String maxLines = this.getStringProperty("maxLines");
                        if (this.bundle == null) {
                            this.bundle = this.getResourceBundle();
                        }
                        if (lines != null && !lines.trim().equals("")) {
                            try {
                                if (Integer.parseInt(lines) > Integer.parseInt(maxLines)) {
                                    String err = this.bundle.getString("maxLinesExceeded");
                                    StringBuffer nextURLString = new StringBuffer();
                                    URL next = null;
                                    if (this.container != null && this.editContainer != null) {
                                        nextURLString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(URLEncoder.encode(this.editContainer)).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(this.container)).append("&lines=").append(URLEncoder.encode(lines)).append("&message=").append(URLEncoder.encode(msg)).append("&error=").append(URLEncoder.encode(err + " : " + maxLines));
                                        next = new URL(nextURLString.toString());
                                    }
                                    return next;
                                }
                            }
                            catch (NumberFormatException e) {
                                String err = this.bundle.getString("linesNAN");
                                throw new InvalidEditFormDataException(err);
                            }
                            catch (MalformedURLException me) {
                                throw new ProviderException("NotesProvider.processEdit() : " + me);
                            }
                            this.setStringProperty("lines", lines);
                        }
                        if (msg == null || msg.trim().equals("")) {
                            return null;
                        }
                        line = null;
                        pw = null;
                        v = new ArrayList<String>();
                        this.motdFile = new File(this.getStringProperty("location"));
                        try {
                            this.motdFile.createNewFile();
                        }
                        catch (IOException ioe) {
                            return null;
                        }
                        lockFile = this.getLock();
                        in = null;
                        try {
                            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.motdFile), "UTF-8"));
                            Object var14_18 = null;
                            if (lockFile == null) break block39;
                            lockFile.delete();
                        }
                        catch (Throwable throwable) {
                            Object var14_19 = null;
                            if (lockFile != null) {
                                lockFile.delete();
                            }
                            throw throwable;
                        }
                        {
                            break block39;
                            catch (UnsupportedEncodingException uec) {
                                this.getProviderContext().debugError("NotesProvider.processEdit()", uec);
                                throw new ProviderException("error creating input stream", uec);
                            }
                            catch (FileNotFoundException fnfe) {
                                this.getProviderContext().debugError("NotesProvider.processEdit()", fnfe);
                                throw new ProviderException("error creating input stream", fnfe);
                            }
                        }
                    }
                    while ((line = in.readLine()) != null) {
                        v.add(line);
                    }
                    Object var16_30 = null;
                    if (in == null) break block40;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                if (lockFile != null) {
                    lockFile.delete();
                }
                break block43;
                {
                    catch (IOException ioe) {
                        URL fnfe = null;
                        Object var16_31 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        if (lockFile != null) {
                            lockFile.delete();
                        }
                        return fnfe;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_32 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    if (lockFile != null) {
                        lockFile.delete();
                    }
                    throw throwable;
                }
            }
            try {
                pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.motdFile.toString()), "UTF-8")));
                Date date = new Date();
                String time = Long.toString(date.getTime());
                StringBuffer user = new StringBuffer();
                user.append(this.getProviderContext().getStringAttribute(FIRST_NAME)).append(" ").append(this.getProviderContext().getStringAttribute(LAST_NAME));
                pw.println(user.toString() + "|" + time + "|" + msg);
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    line = (String)i.next();
                    pw.println(line);
                }
                Object var19_37 = null;
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
                if (lockFile == null) break block42;
                lockFile.delete();
            }
            catch (Throwable throwable) {
                Object var19_38 = null;
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
                if (lockFile != null) {
                    lockFile.delete();
                }
                throw throwable;
            }
            {
                break block42;
                catch (UnsupportedEncodingException uec) {
                    this.getProviderContext().debugError("NotesProvider.processEdit()", uec);
                    throw new ProviderException("error creating output stream", uec);
                }
                catch (FileNotFoundException fnfe) {
                    this.getProviderContext().debugError("NotesProvider.processEdit()", fnfe);
                    throw new ProviderException("error creating output stream", fnfe);
                }
            }
        }
        lockFile.delete();
        return null;
    }
}

