/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator.kae;

import com.sun.eras.common.checkstorage.CheckStorageException;
import com.sun.eras.common.checkstorage.XmlCheckStorage;
import com.sun.vsp.km.util.ExceptionUtil;
import com.sun.vsp.km.util.KMException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class KAEUtil {
    protected static String CHARSET_NAME = "UTF-8";
    protected static String VALIDATE_PROPERTY = "http://xml.org/sax/features/validation";
    protected static String EXPIRATION_DATE = "expiration_date";

    public static StringBuffer getFile(String string) throws KMException {
        StringBuffer stringBuffer = null;
        String string2 = null;
        Properties properties = System.getProperties();
        String string3 = properties.getProperty("line.separator");
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer2 = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), CHARSET_NAME));
            stringBuffer2 = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer2.append(string2 + string3);
            }
        }
        catch (IOException iOException) {
            throw new KMException(iOException.getMessage(), 5002L);
        }
        stringBuffer = stringBuffer2;
        return stringBuffer;
    }

    public static boolean checkListExpired(String string) throws KMException {
        boolean bl = false;
        int n = KAEUtil.getDaysRemaining(string);
        bl = n < 0;
        return bl;
    }

    public static int getDaysRemaining(String string) throws KMException {
        int n = 0;
        long l = KAEUtil.getExpirationDate(string);
        long l2 = System.currentTimeMillis();
        n = (int)((l - l2) / 86400000L);
        return n;
    }

    public static long getExpirationDate(String string) throws KMException {
        long l = 0L;
        try {
            XmlCheckStorage xmlCheckStorage = new XmlCheckStorage(string);
            xmlCheckStorage.getChecks();
            l = xmlCheckStorage.getExpirationDate().getTime();
        }
        catch (CheckStorageException checkStorageException) {
            throw new KMException(ExceptionUtil.getStackTrace((Throwable)checkStorageException), 5303L);
        }
        return l;
    }

    public static boolean isChecklistOlderThan(int n, String string) throws KMException {
        boolean bl = false;
        try {
            XmlCheckStorage xmlCheckStorage = new XmlCheckStorage(string);
            xmlCheckStorage.getChecks();
            long l = xmlCheckStorage.getGenerationDate().getTime();
            long l2 = System.currentTimeMillis();
            if ((l2 - l) / 86400000L > (long)n) {
                bl = true;
            }
        }
        catch (CheckStorageException checkStorageException) {
            throw new KMException(ExceptionUtil.getStackTrace((Throwable)checkStorageException), 5303L);
        }
        return bl;
    }
}

