/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.help;

import com.sun.vsp.km.ic.help.HelpTopicIfc;
import com.sun.vsp.km.ic.icapp.ICAppObject;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HelpTopic
extends ICAppObject
implements HelpTopicIfc {
    protected Vector childList = new Vector();
    protected Hashtable childNameList = new Hashtable();
    protected String topicName;
    protected String topicDescription;
    protected String topicContent;
    protected HelpTopic parentTopic;
    protected static String TOPIC_NODE = "Topic";
    protected static String DESCRIPTION_NODE = "Description";
    protected static String CONTENT_NODE = "Content";
    protected static String HELP_NODE = "Help";
    protected static String ROOT_DESCRIPTION = "Install Check Help";
    protected static String ROOT_NAME = "HelpRoot";
    protected static String TOPIC_PATH_SEPERATOR = "::";
    protected static String NAMED_ITEM = "Name";

    protected HelpTopic(Node node) {
        super("Help", "$Revision: 1.1.1.1 $");
        this.initTopic(node);
    }

    protected HelpTopic(String string, String string2) {
        super(string, string2);
    }

    protected void initTopic(Node node) {
        if (node.getNodeName().equals(HELP_NODE)) {
            this.topicName = ROOT_NAME;
            this.topicDescription = ROOT_DESCRIPTION;
        } else if (node.getNodeName().equals(TOPIC_NODE)) {
            this.topicName = this.getTopicNameAttr(node);
        }
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeName().equals(TOPIC_NODE)) {
                    HelpTopic helpTopic = new HelpTopic(node2);
                    helpTopic.setParentTopic(this);
                    this.addChild(helpTopic);
                } else if (node2.getNodeName().equals(DESCRIPTION_NODE)) {
                    this.topicDescription = this.getTextFromNode(node2);
                } else if (node2.getNodeName().equals(CONTENT_NODE)) {
                    this.topicContent = this.getTextFromNode(node2);
                }
                node2 = node2.getNextSibling();
            }
        }
    }

    protected String getTextFromNode(Node node) {
        String string = null;
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 3 || node2.getNodeType() == 4) {
                    string = node2.getNodeValue();
                }
                node2 = node2.getNextSibling();
            }
        }
        return string;
    }

    public HelpTopic getParentTopic() {
        return this.parentTopic;
    }

    public String getTopicName() {
        return this.topicName;
    }

    protected String getTopicNameAttr(Node node) {
        String string = null;
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Attr attr = (Attr)namedNodeMap.getNamedItem(NAMED_ITEM);
            string = attr.getNodeValue();
        }
        return string;
    }

    public String getTopicDescription() {
        return this.topicDescription;
    }

    public String getTopicContent() {
        return this.topicContent;
    }

    public boolean hasContent() {
        return this.topicContent != null;
    }

    public int subTopicCount() {
        return this.childList.size();
    }

    public HelpTopic getSubTopicByName(String string) {
        return (HelpTopic)this.childNameList.get(string);
    }

    public HelpTopic getSubTopicByIndex(int n) {
        HelpTopic helpTopic = null;
        try {
            helpTopic = (HelpTopic)this.childList.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return helpTopic;
    }

    protected void addChild(HelpTopic helpTopic) {
        this.childNameList.put(helpTopic.getTopicName(), helpTopic);
        this.childList.addElement(helpTopic);
    }

    protected void setParentTopic(HelpTopic helpTopic) {
        this.parentTopic = helpTopic;
    }

    public String getTopicPath() {
        String string = null;
        if (this.getParentTopic() != null) {
            string = this.getParentTopic().getTopicPath() + TOPIC_PATH_SEPERATOR + this.getTopicName();
        } else if (this.getTopicName().equals(ROOT_NAME)) {
            string = ROOT_NAME;
        }
        return string;
    }

    protected HelpTopic getTopicByPath(String string) {
        HelpTopic helpTopic = null;
        String string2 = null;
        int n = string.indexOf(TOPIC_PATH_SEPERATOR);
        if (n == -1) {
            helpTopic = this.getTopicName().equals(string) ? this : this.getSubTopicByName(string);
        } else {
            Object var5_5 = null;
            int n2 = -1;
            string2 = string.substring(n + TOPIC_PATH_SEPERATOR.length());
            n2 = string2.indexOf(TOPIC_PATH_SEPERATOR);
            if (n2 == -1) {
                helpTopic = this.getSubTopicByName(string2);
            } else {
                String string3 = string2.substring(0, string2.indexOf(TOPIC_PATH_SEPERATOR));
                helpTopic = this.getSubTopicByName(string3).getTopicByPath(string2);
            }
        }
        return helpTopic;
    }

    public String toString() {
        return this.getTopicDescription();
    }
}

