/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.gui;

import com.sun.vsp.km.ic.gui.GuiCheck;
import com.sun.vsp.km.ic.gui.ICGui;
import com.sun.vsp.km.ic.gui.ICPanel;
import com.sun.vsp.km.ic.gui.PrintPane;
import com.sun.vsp.km.ic.icapp.TaskNotifierIfc;
import com.sun.vsp.km.ic.reports.XMLCustomerReport;
import com.sun.vsp.km.ic.reports.XMLReportElementIfc;
import com.sun.vsp.km.ic.reports.XMLReportIfc;
import com.sun.vsp.km.ic.reports.XSLTReportImpl;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.ic.validator.CheckIfc;
import com.sun.vsp.km.ic.validator.CheckResultSummaryIfc;
import com.sun.vsp.km.ic.validator.CheckResultsIfc;
import com.sun.vsp.km.ic.validator.ValidatorIfc;
import com.sun.vsp.km.ic.validator.XMLCheckResultsIfc;
import com.sun.vsp.km.util.CleanUpUtil;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.KMLogger;
import com.sun.vsp.km.valueobj.Customer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ResultsPanel
extends ICPanel {
    JLabel topInfo;
    JLabel filterInfo;
    JLabel summary;
    JLabel filePath;
    JLabel legend;
    JTextPane checkResult;
    JScrollPane left;
    JScrollPane right;
    JSplitPane splitPane;
    JComboBox filter;
    JTree checkTree;
    DefaultMutableTreeNode root;
    ImageIcon criticalPic;
    ImageIcon highPic;
    ImageIcon mediumPic;
    ImageIcon lowPic;
    ImageIcon passPic;
    ImageIcon failPic;
    ImageIcon legendPic;
    String checkError;
    String filename;
    int checkErrorNumber;
    CheckResultsIfc results;
    ValidatorIfc validator;
    CleanUpUtil clean;

    public ResultsPanel(int n, TaskNotifierIfc taskNotifierIfc) {
        super(n, taskNotifierIfc);
        this.next.setEnabled(false);
        this.print.setEnabled(true);
        this.clean = (CleanUpUtil)taskNotifierIfc.getObject("CleanUpUtil");
        this.cancel.setText(ICPanel.messages.getString("Close"));
        this.subtitle.setText(ICPanel.messages.getString("ResultTitle") + "  for  " + "host name: " + this.hostName + ",  " + "host type: " + this.hostType);
        this.print.setVisible(true);
        this.checkError = null;
        this.checkErrorNumber = 0;
        this.addContent();
    }

    public ResultsPanel(int n, TaskNotifierIfc taskNotifierIfc, CheckResultsIfc checkResultsIfc, String string) {
        super(n, taskNotifierIfc);
        this.results = checkResultsIfc;
        ICPanel.messages = ResourceBundle.getBundle("gui");
        this.clean = (CleanUpUtil)taskNotifierIfc.getObject("CleanUpUtil");
        this.subtitle.setText(ICPanel.messages.getString("Previous") + " " + string);
        this.cancel.setText(ICPanel.messages.getString("Close"));
        this.print.setVisible(true);
        this.backgroundColor = new Color(185, 185, 204);
        this.prop = ICProperties.getInstance();
        this.imageLocation = System.getProperty("ICAPP_HOME") + System.getProperty("file.separator") + this.prop.getProperty("gui_images") + System.getProperty("file.separator");
        this.checkError = null;
        this.checkErrorNumber = 0;
        this.addContent();
        this.addOldResults();
        this.layoutOldContent();
    }

    protected void addContent() {
        this.criticalPic = new ImageIcon(this.imageLocation + "critical_16_cmyk.gif");
        this.highPic = new ImageIcon(this.imageLocation + "major_16_cmyk.gif");
        this.mediumPic = new ImageIcon(this.imageLocation + "minor_16_cmyk.gif");
        this.lowPic = new ImageIcon(this.imageLocation + "minor_16_cmyk.gif");
        this.passPic = new ImageIcon(this.imageLocation + "pass.gif");
        this.failPic = new ImageIcon(this.imageLocation + "fail.gif");
        this.legendPic = new ImageIcon(this.imageLocation + "legend.gif");
        this.topInfo = new JLabel(ICPanel.messages.getString("ResultIntro"));
        this.topInfo.setFont(new Font(null, 0, 12));
        this.topInfo.setForeground(Color.black);
        this.filterInfo = new JLabel(ICPanel.messages.getString("FilterInfo"));
        this.filterInfo.setFont(new Font(null, 0, 12));
        this.filterInfo.setForeground(Color.black);
        this.legend = new JLabel(this.legendPic);
        String[] stringArray = new String[]{ICPanel.messages.getString("FailedChecks"), ICPanel.messages.getString("PassedChecks"), ICPanel.messages.getString("AllChecks")};
        this.filter = new JComboBox<String>(stringArray);
        this.filter.setSelectedIndex(2);
        this.filter.setOpaque(true);
        this.filter.setToolTipText(ICPanel.messages.getString("FilterTip"));
        this.filter.setLightWeightPopupEnabled(true);
        this.filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string == ICPanel.messages.getString("FailedChecks")) {
                    ResultsPanel.this.filterFailedResults();
                } else if (string == ICPanel.messages.getString("PassedChecks")) {
                    ResultsPanel.this.filterPassedResults();
                } else {
                    ResultsPanel.this.filterAllResults();
                }
            }
        });
        this.filter.addKeyListener(ICGui.key);
        this.checkResult = new JTextPane();
        this.checkResult.setEditable(false);
        this.right = new JScrollPane(this.checkResult);
        this.right.setHorizontalScrollBarPolicy(31);
        this.right.setVerticalScrollBarPolicy(22);
        this.right.setPreferredSize(new Dimension(10, 10));
        this.right.addKeyListener(ICGui.key);
        this.root = new DefaultMutableTreeNode(new GuiCheck("the Root, heezy"));
        this.checkTree = new JTree(this.root);
        this.checkTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ResultsPanel.this.checkTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                GuiCheck guiCheck = (GuiCheck)object;
                ResultsPanel.this.displayInfo(guiCheck);
            }
        });
        this.checkTree.addKeyListener(ICGui.key);
        this.left = new JScrollPane(this.checkTree);
        this.splitPane = new JSplitPane(1, this.left, this.right);
        this.splitPane.setDividerLocation(115);
        this.splitPane.setDividerSize(8);
        this.splitPane.setOneTouchExpandable(true);
    }

    protected void displayInfo(GuiCheck guiCheck) {
        String string = ICPanel.messages.getString("Severity") + ":  ";
        switch (guiCheck.check.getSeverity()) {
            case 1: {
                string = string + ICPanel.messages.getString("Low");
                break;
            }
            case 2: {
                string = string + ICPanel.messages.getString("Low");
                break;
            }
            case 3: {
                string = string + ICPanel.messages.getString("High");
                break;
            }
            case 4: {
                string = string + ICPanel.messages.getString("Critical");
            }
        }
        String string2 = null;
        String[] stringArray = new String[8];
        if (guiCheck.check.getPassed()) {
            string2 = ICPanel.messages.getString("Passed");
            string = ICPanel.messages.getString("Severity") + ":  " + ICPanel.messages.getString("None");
            stringArray[0] = string2 + "\n";
            stringArray[1] = string + "\n\n";
            stringArray[2] = ICPanel.messages.getString("Issue") + "\n";
            stringArray[3] = guiCheck.check.getProblemDescription() + "\n\n";
            stringArray[4] = ICPanel.messages.getString("Analysis") + "\n";
            stringArray[5] = guiCheck.check.getAnalysis() + "\n\n";
        } else if (!guiCheck.check.getPassed()) {
            string2 = ICPanel.messages.getString("Failed");
            stringArray[0] = string2 + "\n";
            stringArray[1] = string + "\n\n";
            stringArray[2] = ICPanel.messages.getString("Issue") + "\n";
            stringArray[3] = guiCheck.check.getProblemDescription() + "\n\n";
            stringArray[4] = ICPanel.messages.getString("Analysis") + "\n";
            stringArray[5] = guiCheck.check.getAnalysis() + "\n\n";
            stringArray[6] = ICPanel.messages.getString("Recommendation") + "\n";
            stringArray[7] = guiCheck.check.getRecommendation();
        }
        String[] stringArray2 = new String[]{"title", "text", "title", "text", "title", "text", "title", "text"};
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.checkResult.addStyle("title", style);
        Style style3 = this.checkResult.addStyle("text", style);
        StyleConstants.setBold(style2, true);
        StyleConstants.setFontSize(style2, 14);
        StyleConstants.setBold(style3, false);
        StyleConstants.setFontSize(style3, 12);
        Document document = this.checkResult.getDocument();
        try {
            document.remove(0, document.getLength());
            int n = 0;
            while (n < stringArray.length) {
                document.insertString(document.getLength(), stringArray[n], this.checkResult.getStyle(stringArray2[n]));
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkResult.setCaretPosition(0);
    }

    protected void filterFailedResults() {
        Document document = this.checkResult.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.checkTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GuiCheck("newRoot"));
        Iterator iterator = this.results.getFailedChecks();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (!checkIfc.getApplicability() || checkIfc.getExecutionError()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GuiCheck(checkIfc, 1));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        defaultTreeModel.setRoot(defaultMutableTreeNode);
        this.checkTree.expandPath(new TreePath(this.root));
        this.checkTree.setRootVisible(false);
    }

    protected void filterAllResults() {
        Document document = this.checkResult.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.checkTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GuiCheck("newRoot"));
        Iterator iterator = this.results.getAllChecks();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (!checkIfc.getApplicability() || checkIfc.getExecutionError()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GuiCheck(checkIfc, 1));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        defaultTreeModel.setRoot(defaultMutableTreeNode);
        this.checkTree.expandPath(new TreePath(this.root));
        this.checkTree.setRootVisible(false);
    }

    protected void filterPassedResults() {
        Document document = this.checkResult.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.checkTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GuiCheck("newRoot"));
        Iterator iterator = this.results.getPassedChecks();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (!checkIfc.getApplicability() || checkIfc.getExecutionError()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GuiCheck(checkIfc, 1));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        defaultTreeModel.setRoot(defaultMutableTreeNode);
        this.checkTree.expandPath(new TreePath(this.root));
        this.checkTree.setRootVisible(false);
    }

    public void addOldResults() {
        this.checkTree.setCellRenderer(new ICTreeRenderer());
        Iterator iterator = this.results.getAllChecks();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (checkIfc.getExecutionError()) {
                ++this.checkErrorNumber;
                continue;
            }
            if (!checkIfc.getApplicability()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GuiCheck(checkIfc, 1));
            this.root.add(defaultMutableTreeNode);
        }
        this.checkTree.expandPath(new TreePath(this.root));
        this.checkTree.setRootVisible(false);
    }

    public void addResults() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        CheckIfc checkIfc;
        ICGui.hasRun(true);
        this.content.removeAll();
        this.validator = (ValidatorIfc)this.tn.getObject("Validator");
        this.results = this.validator.getResults();
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'_'HHmmss");
        this.filename = "SUNIC" + simpleDateFormat.format(date) + ".xml";
        String string = System.getProperty("ICAPP_VAR") + System.getProperty("file.separator") + this.prop.getProperty("reports") + System.getProperty("file.separator");
        this.results.storeCheckResults(string + this.filename);
        this.checkTree.setCellRenderer(new ICTreeRenderer());
        Iterator iterator = this.results.getAllChecks();
        while (iterator.hasNext()) {
            checkIfc = (CheckIfc)iterator.next();
            if (checkIfc.getExecutionError()) {
                this.checkError = this.checkError == null ? "     " + checkIfc.getCheckNumber() + "\n" : this.checkError + "     " + checkIfc.getCheckNumber() + "\n";
                ++this.checkErrorNumber;
                continue;
            }
            if (!checkIfc.getApplicability()) continue;
            defaultMutableTreeNode = new DefaultMutableTreeNode(new GuiCheck(checkIfc, 1));
            this.root.add(defaultMutableTreeNode);
        }
        this.checkTree.expandPath(new TreePath(this.root));
        this.checkTree.setRootVisible(false);
        checkIfc = (Customer)this.tn.getObject("Customer");
        defaultMutableTreeNode = null;
        XMLReportIfc xMLReportIfc = null;
        XMLReportIfc xMLReportIfc2 = null;
        int n = this.filename.lastIndexOf(46);
        String string2 = this.filename.substring(0, n) + ".txt";
        String string3 = this.filename.substring(0, n) + ".xml";
        String string4 = this.filename.substring(0, n) + ".html";
        try {
            xMLReportIfc = this.generateReport((Customer)checkIfc, "text_template", string2);
        }
        catch (KMException kMException) {
            KMLogger.log((int)KMLogger.WARNING, (String)"ResultsPanel.java", (String)"AddResults()", (String)"Problem generating text report");
        }
        try {
            xMLReportIfc2 = this.generateReport((Customer)checkIfc, "html_template", string4);
        }
        catch (KMException kMException) {
            KMLogger.log((int)KMLogger.WARNING, (String)"ResultsPanel.java", (String)"AddResults()", (String)"Problem generating html report");
        }
    }

    protected XMLReportIfc generateReport(Customer customer, String string, String string2) throws KMException {
        XSLTReportImpl xSLTReportImpl = null;
        XMLCustomerReport xMLCustomerReport = new XMLCustomerReport(customer);
        String string3 = System.getProperty("ICAPP_HOME") + System.getProperty("file.separator") + this.prop.getProperty(string);
        String string4 = System.getProperty("ICAPP_VAR") + System.getProperty("file.separator") + this.prop.getProperty("reports") + System.getProperty("file.separator") + string2;
        xSLTReportImpl = new XSLTReportImpl(string3, string4);
        if (this.results instanceof XMLCheckResultsIfc) {
            try {
                xSLTReportImpl.addReportElement((XMLReportElementIfc)((Object)this.results));
                xSLTReportImpl.addReportElement(xMLCustomerReport);
            }
            catch (KMException kMException) {
                KMLogger.log((int)KMLogger.WARNING, (String)"ResultsPanel.java", (String)"AddResults()", (String)"Problem adding report element");
            }
        }
        try {
            xSLTReportImpl.generateReport();
        }
        catch (KMException kMException) {
            KMLogger.log((int)KMLogger.WARNING, (String)"ResultsPanel.java", (String)"AddResults()", (String)"Problem generating email report");
        }
        return xSLTReportImpl;
    }

    protected void layoutOldContent() {
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        CheckResultSummaryIfc checkResultSummaryIfc = this.results.getSummary();
        int n = checkResultSummaryIfc.getTotal() - checkResultSummaryIfc.getNotApplicable() - this.checkErrorNumber;
        int n2 = n - checkResultSummaryIfc.getPassed();
        this.summary = new JLabel(n2 + " " + ICPanel.messages.getString("ResultSummary1") + " " + n + " " + ICPanel.messages.getString("ResultSummary2"));
        this.summary.setFont(new Font(null, 0, 12));
        this.summary.setBackground(this.backgroundColor);
        this.summary.setForeground(Color.black);
        this.content.setLayout(this.gridbag);
        this.c.insets = new Insets(12, 12, 0, 6);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.titleBackground, this.c);
        this.content.add(this.titleBackground);
        this.c.insets = new Insets(12, 18, 2, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.summary, this.c);
        this.content.add(this.summary);
        this.c.insets = new Insets(5, 18, 0, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.filterInfo, this.c);
        this.content.add(this.filterInfo);
        this.c.insets = new Insets(0, 10, 2, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.filter, this.c);
        this.content.add(this.filter);
        this.c.insets = new Insets(8, 0, 2, 12);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 2;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.fill = 0;
        this.c.anchor = 12;
        this.gridbag.setConstraints(this.legend, this.c);
        this.content.add(this.legend);
        this.c.insets = new Insets(0, 18, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 3;
        this.c.gridheight = 1;
        this.c.fill = 1;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.splitPane, this.c);
        this.content.add(this.splitPane);
        this.c.insets = new Insets(2, 18, 11, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.topInfo, this.c);
        this.content.add(this.topInfo);
    }

    public void layoutContent() {
        CheckResultSummaryIfc checkResultSummaryIfc = this.results.getSummary();
        int n = checkResultSummaryIfc.getTotal() - checkResultSummaryIfc.getNotApplicable() - this.checkErrorNumber;
        int n2 = n - checkResultSummaryIfc.getPassed();
        this.summary = new JLabel(n2 + " " + ICPanel.messages.getString("ResultSummary1") + " " + n + " " + ICPanel.messages.getString("ResultSummary2"));
        this.summary.setFont(new Font(null, 0, 12));
        this.summary.setBackground(this.backgroundColor);
        this.summary.setForeground(Color.black);
        String string = System.getProperty("ICAPP_VAR") + System.getProperty("file.separator") + this.prop.getProperty("reports") + System.getProperty("file.separator");
        this.filePath = new JLabel(ICPanel.messages.getString("ResultPath") + string + this.filename.substring(0, this.filename.lastIndexOf(46)) + ".txt");
        this.filePath.setFont(new Font(null, 0, 12));
        this.filePath.setForeground(Color.black);
        this.content.setLayout(this.gridbag);
        this.c.insets = new Insets(12, 12, 0, 6);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.titleBackground, this.c);
        this.content.add(this.titleBackground);
        this.c.insets = new Insets(12, 18, 2, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 3;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.summary, this.c);
        this.content.add(this.summary);
        this.c.insets = new Insets(5, 18, 0, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.filterInfo, this.c);
        this.content.add(this.filterInfo);
        this.c.insets = new Insets(0, 10, 2, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.filter, this.c);
        this.content.add(this.filter);
        this.c.insets = new Insets(8, 0, 2, 12);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 2;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.fill = 0;
        this.c.anchor = 12;
        this.gridbag.setConstraints(this.legend, this.c);
        this.content.add(this.legend);
        this.c.insets = new Insets(0, 18, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 3;
        this.c.gridheight = 1;
        this.c.fill = 1;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.splitPane, this.c);
        this.content.add(this.splitPane);
        this.c.insets = new Insets(2, 18, 6, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.topInfo, this.c);
        this.content.add(this.topInfo);
        this.c.insets = new Insets(2, 18, 11, 0);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.c.gridwidth = 3;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.filePath, this.c);
        this.content.add(this.filePath);
        if (this.checkError != null) {
            String string2 = ICPanel.messages.getString("ResultsCheckError") + "\n" + this.checkError + ICPanel.messages.getString("ResultsCheckSupport") + " " + this.prop.getProperty("support_number") + ".";
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, string2, ICPanel.messages.getString("ErrorTitle"), 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) throws ArrayIndexOutOfBoundsException {
        block7: {
            try {
                if (actionEvent.getSource().equals(this.cancel)) {
                    this.clean.exitWith(0);
                    break block7;
                }
                if (actionEvent.getSource().equals(this.back)) {
                    ICGui.switchPanel(1);
                    break block7;
                }
                if (actionEvent.getSource().equals(this.next)) break block7;
                if (actionEvent.getSource().equals(this.help)) {
                    ICGui.helpVisible(true);
                } else if (actionEvent.getSource().equals(this.print)) {
                    this.printResults();
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                KMLogger.log((int)KMLogger.WARNING, (String)"ResultsPanel.java", (String)"actionPerformed()", (String)"ICGui.SwitchPanel() called with bad index");
            }
        }
    }

    private void printResults() {
        block4: {
            String string = System.getProperty("ICAPP_VAR") + System.getProperty("file.separator") + this.prop.getProperty("reports") + System.getProperty("file.separator");
            int n = this.filename.lastIndexOf(46);
            String string2 = this.filename.substring(0, n) + ".txt";
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            try {
                printerJob.setPrintable(new PrintPane(string + string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!printerJob.printDialog()) break block4;
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    private class ICTreeRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            GuiCheck guiCheck = (GuiCheck)defaultMutableTreeNode.getUserObject();
            if (guiCheck.title == null && guiCheck.type == 1) {
                if (guiCheck.check.getPassed()) {
                    this.setIcon(ResultsPanel.this.passPic);
                } else {
                    switch (guiCheck.check.getSeverity()) {
                        case 1: {
                            this.setIcon(ResultsPanel.this.lowPic);
                            break;
                        }
                        case 2: {
                            this.setIcon(ResultsPanel.this.mediumPic);
                            break;
                        }
                        case 3: {
                            this.setIcon(ResultsPanel.this.highPic);
                            break;
                        }
                        case 4: {
                            this.setIcon(ResultsPanel.this.criticalPic);
                        }
                    }
                }
            }
            return this;
        }
    }
}

