/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.util;

import com.sun.vsp.km.util.KMException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            new KMException(parserConfigurationException.getMessage(), 5208L);
        }
        return document;
    }

    public static void serialize(Document document, String string) {
        try {
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)new FileWriter(string), null);
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            new KMException(iOException.getMessage(), 5208L);
        }
    }

    public static void outputDOM(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(System.out));
        }
        catch (Exception exception) {
            new KMException(exception.getMessage(), 5208L);
        }
    }

    public static void appendChildNode(Node node, Node node2) {
        if (node2 != null) {
            node.appendChild(node2);
        }
    }

    public static Element createElementWithContent(Document document, String string, String string2) {
        return XMLUtil.createElementWithContent(document, string, string2, (short)3);
    }

    public static Element createElementWithContent(Document document, String string, String string2, short s) {
        Element element = null;
        if (string2 != null) {
            element = document.createElement(string);
            if (s == 4) {
                XMLUtil.appendChildNode(element, document.createCDATASection(string2));
            } else {
                XMLUtil.appendChildNode(element, document.createTextNode(string2));
            }
        }
        return element;
    }

    public static Element createElementWithContent(Document document, String string, int n) {
        return XMLUtil.createElementWithContent(document, string, String.valueOf(n));
    }

    public static Document getValidatedDocumentFromFile(String string) throws KMException {
        return XMLUtil.getDocumentFromFile(string, "http://xml.org/sax/features/validation", true);
    }

    public static Document getDocumentFromFile(String string, String string2, boolean bl) throws KMException {
        Document document = null;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature(string2, bl);
            dOMParser.parse(string);
            document = dOMParser.getDocument();
        }
        catch (IOException iOException) {
            throw new KMException(string, 5002L);
        }
        catch (SAXException sAXException) {
            throw new KMException(sAXException.getMessage(), 5209L);
        }
        XMLUtil.outputDOM(document);
        return document;
    }

    public static Document getDocumentFromFile(String string) throws KMException {
        Document document = null;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(string);
            document = dOMParser.getDocument();
        }
        catch (IOException iOException) {
            throw new KMException(string, 5002L);
        }
        catch (SAXException sAXException) {
            throw new KMException(sAXException.getMessage(), 5209L);
        }
        return document;
    }

    public static Node getRootNodeFromFile(String string, String string2, boolean bl) throws KMException {
        Document document = XMLUtil.getDocumentFromFile(string, string2, bl);
        return document.getDocumentElement();
    }

    public static Node getRootNodeFromFile(String string) throws KMException {
        return XMLUtil.getRootNodeFromFile(string, null, false);
    }

    public static Node getValidatedRootNodeFromFile(String string) throws KMException {
        Document document = XMLUtil.getDocumentFromFile(string, "http://xml.org/sax/features/validation", true);
        return document.getDocumentElement();
    }

    public static Node getChildNodeByName(Node node, String string) {
        Node node2 = null;
        if (node.hasChildNodes()) {
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                if (node3.getNodeName().equals(string)) {
                    node2 = node3;
                    break;
                }
                node3 = node3.getNextSibling();
            }
        }
        return node2;
    }

    public static boolean getBoolChildValue(Node node, String string) {
        boolean bl = false;
        String string2 = XMLUtil.getTextFromNodeWithName(node, string);
        if ((string2 = string2.trim()) != null) {
            bl = Boolean.valueOf(string2);
        }
        return bl;
    }

    public static String getTextByLocale(Node node, String string, Locale locale, String string2) {
        Object object;
        Object var4_4 = null;
        Vector<Node> vector = new Vector<Node>();
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeName().equals(string)) {
                    vector.add(node2);
                }
                node2 = node2.getNextSibling();
            }
        }
        if (vector.size() == 1) {
            return XMLUtil.getTextFromNode((Node)vector.elementAt(0));
        }
        int n = 0;
        while (n < vector.size()) {
            Node node3 = (Node)vector.elementAt(n);
            object = XMLUtil.getAttributeValue(node3, string2);
            if (locale.toString().equals(object)) {
                return XMLUtil.getTextFromNode(node3);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (Node)vector.elementAt(n2);
            String string3 = XMLUtil.getAttributeValue((Node)object, string2);
            if (string3.startsWith(locale.getLanguage())) {
                return XMLUtil.getTextFromNode((Node)object);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            return XMLUtil.getTextFromNode((Node)vector.elementAt(0));
        }
        return null;
    }

    public static int getIntChildValue(Node node, String string) {
        int n = -1;
        String string2 = XMLUtil.getTextFromNodeWithName(node, string);
        if ((string2 = string2.trim()) != null) {
            n = Integer.valueOf(string2);
        }
        return n;
    }

    public static String getTextFromNodeWithName(Node node, String string) {
        Node node2 = XMLUtil.getChildNodeByName(node, string);
        String string2 = null;
        string2 = XMLUtil.getTextFromNode(node2);
        return string2;
    }

    public static String getTextFromNode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node != null && node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if ((node2.getNodeType() == 4 || node2.getNodeType() == 3) && node2.getNodeValue() != null) {
                    stringBuffer.append(node2.getNodeValue());
                }
                node2 = node2.getNextSibling();
            }
        }
        return stringBuffer.toString();
    }

    public static String getTextFromElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (XMLUtil.isTextNode(node)) {
                stringBuffer = new StringBuffer(node.getNodeValue());
                Node node2 = node.getNextSibling();
                while (XMLUtil.isTextNode(node2)) {
                    stringBuffer.append(node2.getNodeValue());
                    node2 = node2.getNextSibling();
                }
                return stringBuffer.toString();
            }
            ++n;
        }
        return null;
    }

    protected static boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        short s = node.getNodeType();
        return s == 4 || s == 3;
    }

    public static List getChildrenElements(Element element) {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                vector.add(node);
            }
            ++n;
        }
        return vector;
    }

    public static List getChildrenElementsByName(String string, Element element) {
        Vector<Element> vector = new Vector<Element>();
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNodeName().equals(string)) {
                vector.add((Element)node);
            }
            ++n;
        }
        return vector;
    }

    public static Element getChildElementByName(String string, Element element) {
        Node node = null;
        if (element.hasChildNodes()) {
            Node node2 = element.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeName().equals(string) && node2.getNodeType() == 1) {
                    node = node2;
                    break;
                }
                node2 = node2.getNextSibling();
            }
        }
        return (Element)node;
    }

    public static String getAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        return XMLUtil.getTextFromNode(node2);
    }

    public static Node getChildNodeWithAttributeValue(Node node, String string, String string2) {
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (XMLUtil.getAttributeValue(nodeList.item(n), string).equals(string2)) {
                node2 = nodeList.item(n);
                break;
            }
            ++n;
        }
        return node2;
    }

    public static int countChildren(Element element, List list) {
        if (element == null) {
            return 0;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n += string == null ? n : XMLUtil.getChildrenElementsByName(string, element).size();
        }
        return n;
    }

    public static int countChildren(Element element, String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(string2);
        vector.add(string3);
        return XMLUtil.countChildren(element, vector);
    }

    public static int countChildren(Element element, String string, String string2) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(string2);
        return XMLUtil.countChildren(element, vector);
    }

    public static int countChildren(Element element, String string) {
        return element == null || string == null ? 0 : XMLUtil.getChildrenElementsByName(string, element).size();
    }

    public static void transformXML() {
        block2: {
            String string = System.getProperty("ICAPP_VAR") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "collector_out.xml";
            String string2 = System.getProperty("ICAPP_HOME") + System.getProperty("file.separator") + "lib/coltxtout.xsl";
            String string3 = System.getProperty("ICAPP_VAR") + System.getProperty("file.separator") + "reports" + System.getProperty("file.separator") + "collectorOutput.txt";
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) break block2;
            Transformer transformer = null;
            TransformerFactory transformerFactory = null;
            try {
                transformerFactory = TransformerFactory.newInstance();
                transformer = transformerFactory.newTransformer(new StreamSource(string2));
                transformer.transform(new StreamSource(string), new StreamResult(new FileOutputStream(string3)));
            }
            catch (Exception exception) {}
        }
    }
}

