/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.collector.iccol.worker;

import com.sun.vsp.km.ic.collector.ColMessageLookup;
import com.sun.vsp.km.ic.collector.CollectorProps;
import com.sun.vsp.km.ic.collector.iccol.DataCollectionException;
import com.sun.vsp.km.ic.collector.iccol.WorkerIfc;
import com.sun.vsp.km.ic.util.ICPropIfc;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.util.KMLogger;
import com.sun.vsp.km.util.XMLUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SysWorker
implements WorkerIfc {
    private Document sysDoc;
    private Document configDoc;
    private Vector docs;
    private String name;
    private String release;
    private String osrevision;
    private String totalMemory;
    private String solRev;
    private long pageSize;
    private long numPages;
    private static String[] envp = new String[]{"LC_ALL=C"};
    protected ICPropIfc props = null;
    protected boolean debug;

    public Vector getDoc() {
        return this.docs;
    }

    public Vector collect() throws DataCollectionException {
        this.props = ICProperties.getInstance();
        this.debug = this.props.getProperty("debug").equals("true");
        if (this.debug) {
            System.out.println("SysWorker:collect() called.");
        }
        this.runSysconf();
        this.runUname_i();
        this.runUname_r();
        this.runRelease();
        this.docs = new Vector();
        this.docs.add(this.createDoc());
        this.docs.add(this.createConfigDoc());
        return this.docs;
    }

    private void runSysconf() throws DataCollectionException {
        if (this.debug) {
            System.out.println("SysWorker:runSysconf() called.");
        }
        CollectorProps collectorProps = CollectorProps.getInstance();
        String string = "";
        string = System.getProperty("WORKER_PATH") == null ? collectorProps.getProperty("worker_path") + System.getProperty("file.separator") + "sysconfworker" : System.getProperty("WORKER_PATH") + System.getProperty("file.separator") + "sysconfworker";
        String string2 = string;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            throw new DataCollectionException("There was a problem running the sysconf collection module.  Exception: " + exception.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string3 = "";
        try {
            string3 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageSize = -1L;
        this.numPages = -1L;
        while (string3 != null) {
            try {
                if (string3.startsWith("_SC_PAGESIZE")) {
                    this.pageSize = Long.parseLong(string3.substring(string3.indexOf(58) + 2));
                } else if (string3.startsWith("_SC_PHYS_PAGES")) {
                    this.numPages = Long.parseLong(string3.substring(string3.indexOf(58) + 2));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string3 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void runUname_i() throws DataCollectionException {
        if (this.debug) {
            System.out.println("SysWorker:runUname_i() called.");
        }
        String string = "/usr/bin/uname -i";
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string, envp);
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)"com.sun.vsp.km.ic.collector.iccol.worker.SysWorker", (String)"runUname_i()", (String)(ColMessageLookup.getMessage((long)100L) + " " + "uname -i" + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(ColMessageLookup.getMessage((long)100L) + " " + "uname -i" + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.name = string2.trim();
        if (this.name.equals("i86pc")) {
            if (this.debug) {
                System.out.println("SysWorker:runUname_i() running dmidecode since x86 machine.");
            }
            CollectorProps collectorProps = CollectorProps.getInstance();
            String string3 = "";
            string3 = System.getProperty("WORKER_PATH") == null ? collectorProps.getProperty("worker_path") + System.getProperty("file.separator") + "dmidecode" : System.getProperty("WORKER_PATH") + System.getProperty("file.separator") + "dmidecode";
            String string4 = string3 + " /dev/xsvc";
            Process process2 = null;
            try {
                process2 = Runtime.getRuntime().exec(string4);
            }
            catch (Exception exception) {
                throw new DataCollectionException("There was a problem running the sysconf collection module.  Exception: " + exception.getMessage());
            }
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            string2 = null;
            try {
                string2 = bufferedReader2.readLine().trim();
            }
            catch (Exception exception) {}
            while (string2 != null) {
                if (string2.startsWith("Product Name:")) {
                    this.name = string2.substring(string2.indexOf(58) + 1, string2.length()).trim();
                    break;
                }
                try {
                    string2 = bufferedReader2.readLine().trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void runUname_r() throws DataCollectionException {
        if (this.debug) {
            System.out.println("SysWorker:runUname_r() called.");
        }
        String string = "/usr/bin/uname -r";
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string, envp);
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)"com.sun.vsp.km.ic.collector.iccol.worker.SysWorker", (String)"runUname_r()", (String)(ColMessageLookup.getMessage((long)100L) + " " + "uname -r" + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(ColMessageLookup.getMessage((long)100L) + " " + "uname -r" + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.osrevision = string2.trim();
        this.solRev = this.osrevision.substring(this.osrevision.lastIndexOf(".") + 1);
    }

    private void runRelease() throws DataCollectionException {
        if (this.debug) {
            System.out.println("SysWorker:runRelease() called.");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader("/etc/release"));
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)"com.sun.vsp.km.ic.collector.iccol.worker.SysWorker", (String)"runRelease()", (String)(ColMessageLookup.getMessage((long)100L) + " " + "/etc/release" + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(ColMessageLookup.getMessage((long)100L) + " " + "/etc/release" + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.release = string.trim();
    }

    private Document createConfigDoc() {
        if (this.debug) {
            System.out.println("SysWorker:createConfigDoc() called.");
        }
        this.configDoc = XMLUtil.createDocument();
        Element element = this.configDoc.createElement("table");
        element.setAttribute("name", "config");
        Element element2 = this.configDoc.createElement("instance");
        element2.setAttribute("id", "0");
        Element element3 = XMLUtil.createElementWithContent((Document)this.configDoc, (String)"property", (String)"general");
        element3.setAttribute("name", "type");
        XMLUtil.appendChildNode((Node)element2, (Node)element3);
        if (this.debug) {
            System.out.println("SysWorker:createConfigDoc() created type.");
        }
        Element element4 = XMLUtil.createElementWithContent((Document)this.configDoc, (String)"property", (String)System.getProperty("PLATFORM"));
        element4.setAttribute("name", "hardwareplatform");
        XMLUtil.appendChildNode((Node)element2, (Node)element4);
        if (this.debug) {
            System.out.println("SysWorker:createConfigDoc() created hardwarePlatform - " + System.getProperty("PLATFORM"));
        }
        String string = String.valueOf(this.pageSize * this.numPages);
        Element element5 = XMLUtil.createElementWithContent((Document)this.configDoc, (String)"property", (String)string);
        element5.setAttribute("name", "memorysize");
        XMLUtil.appendChildNode((Node)element2, (Node)element5);
        if (this.debug) {
            System.out.println("SysWorker:createConfigDoc() created memorySize - " + string);
        }
        XMLUtil.appendChildNode((Node)element, (Node)element2);
        this.configDoc.appendChild(element);
        return this.configDoc;
    }

    private Document createDoc() {
        Element element;
        if (this.debug) {
            System.out.println("SysWorker:createDoc called.");
        }
        this.sysDoc = XMLUtil.createDocument();
        Element element2 = this.sysDoc.createElement("table");
        element2.setAttribute("name", "system");
        Element element3 = this.sysDoc.createElement("instance");
        element3.setAttribute("id", System.getProperties().getProperty("HOST_ID"));
        Element element4 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.name);
        element4.setAttribute("name", "platform");
        XMLUtil.appendChildNode((Node)element3, (Node)element4);
        if (this.debug) {
            System.out.println("SysWorker:createDoc() created name - " + this.name);
        }
        if (!this.name.equals("SUNW,Ultra-Enterprise-10000")) {
            element = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)"false");
            element.setAttribute("name", "ise10k");
            XMLUtil.appendChildNode((Node)element3, (Node)element);
        }
        if (this.debug) {
            System.out.println("SysWorker:createDoc() created ise10k.");
        }
        element = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)"false");
        element.setAttribute("name", "issf15ksc");
        XMLUtil.appendChildNode((Node)element3, (Node)element);
        if (this.debug) {
            System.out.println("SysWorker:createDoc() created sf15k.");
        }
        Element element5 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.release);
        element5.setAttribute("name", "release");
        XMLUtil.appendChildNode((Node)element3, (Node)element5);
        if (this.debug) {
            System.out.println("SysWorker:createDoc() created release - " + this.release);
        }
        Element element6 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.solRev);
        element6.setAttribute("name", "solarisrevision");
        XMLUtil.appendChildNode((Node)element3, (Node)element6);
        if (this.debug) {
            System.out.println("SysWorker:createDoc() created solarisRevision - " + this.solRev);
        }
        Element element7 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.osrevision);
        element7.setAttribute("name", "osrevision");
        XMLUtil.appendChildNode((Node)element3, (Node)element7);
        if (this.debug) {
            System.out.println("SysWorker:createDoc() created osRevision - " + this.osrevision);
        }
        if (this.pageSize != -1L && this.numPages != -1L) {
            this.totalMemory = String.valueOf(this.pageSize * this.numPages / 0x100000L);
            Element element8 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.totalMemory);
            element8.setAttribute("name", "totalmemory");
            XMLUtil.appendChildNode((Node)element3, (Node)element8);
            if (this.debug) {
                System.out.println("SysWorker:createDoc() created totalMemory - " + this.totalMemory);
            }
        }
        XMLUtil.appendChildNode((Node)element2, (Node)element3);
        this.sysDoc.appendChild(element2);
        return this.sysDoc;
    }
}

