/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.collector;

import com.sun.vsp.km.framework.KMObjectIfc;
import com.sun.vsp.km.framework.KMObjectLogException;
import com.sun.vsp.km.ic.collector.CollectorIfc;
import com.sun.vsp.km.ic.icapp.ICAppObject;
import com.sun.vsp.km.ic.query.QueryException;
import com.sun.vsp.km.ic.query.QueryObjectIfc;
import com.sun.vsp.km.ic.query.ResultSetIfc;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.KMLogger;

public abstract class AbstractCollector
extends ICAppObject
implements CollectorIfc {
    public AbstractCollector(String string) {
        super("Collector", string);
    }

    public KMObjectIfc execute() {
        try {
            this.runCollector();
        }
        catch (KMObjectLogException kMObjectLogException) {
            System.out.println("Logging failed: " + kMObjectLogException.getMessage());
        }
        catch (KMException kMException) {
            try {
                this.log(KMLogger.SEVERE, "Error during data collection: " + kMException.getMessage());
            }
            catch (KMObjectLogException kMObjectLogException) {
                System.out.println("Error during data collection: " + kMException.getMessage());
                System.out.println("Could not log above message: " + kMObjectLogException.getMessage());
            }
        }
        return this;
    }

    public abstract ResultSetIfc executeQuery(QueryObjectIfc var1) throws QueryException;

    public abstract KMException getException();

    public String getOutputDir() {
        return "output dir";
    }

    public String getOutputFile() {
        return "output file";
    }

    public abstract int getPercentComplete();

    public abstract int getStatus();

    public abstract String getStatusText();

    public abstract Thread runCollector() throws KMException;

    public void stop() {
        try {
            this.stopCollector();
        }
        catch (KMObjectLogException kMObjectLogException) {
            System.out.println("Logging failed: " + kMObjectLogException.getMessage());
        }
        catch (KMException kMException) {
            try {
                this.log(KMLogger.SEVERE, "Error while Terminating the data collection: " + kMException.getMessage());
            }
            catch (KMObjectLogException kMObjectLogException) {
                System.out.println("Error while stoping the data collection: " + kMException.getMessage());
                System.out.println("Could not log above message: " + kMObjectLogException.getMessage());
            }
        }
    }

    public abstract void stopCollector() throws KMException;
}

