/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.collector.iccol.worker;

import com.sun.vsp.km.ic.collector.ColMessageLookup;
import com.sun.vsp.km.ic.collector.CollectorProps;
import com.sun.vsp.km.ic.collector.iccol.DataCollectionException;
import com.sun.vsp.km.ic.collector.iccol.WorkerIfc;
import com.sun.vsp.km.util.KMLogger;
import com.sun.vsp.km.util.XMLUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SysWorker
implements WorkerIfc {
    private Document sysDoc;
    private Document configDoc;
    private Vector docs;
    private String name;
    private String release;
    private String osrevision;
    private String totalMemory;
    private String solRev;
    private long pageSize;
    private long numPages;
    private static String[] envp = new String[]{"LC_ALL=C"};

    public Vector collect() throws DataCollectionException {
        this.runSysconf();
        this.runUname_i();
        this.runUname_r();
        this.runRelease();
        this.docs = new Vector();
        this.docs.add(this.createDoc());
        this.docs.add(this.createConfigDoc());
        return this.docs;
    }

    private Document createConfigDoc() {
        this.configDoc = XMLUtil.createDocument();
        Element element = this.configDoc.createElement("table");
        element.setAttribute("name", "config");
        Element element2 = this.configDoc.createElement("instance");
        element2.setAttribute("id", "0");
        Element element3 = XMLUtil.createElementWithContent((Document)this.configDoc, (String)"property", (String)"general");
        element3.setAttribute("name", "type");
        XMLUtil.appendChildNode((Node)element2, (Node)element3);
        Element element4 = XMLUtil.createElementWithContent((Document)this.configDoc, (String)"property", (String)System.getProperty("PLATFORM"));
        element4.setAttribute("name", "hardwareplatform");
        XMLUtil.appendChildNode((Node)element2, (Node)element4);
        String string = String.valueOf(this.pageSize * this.numPages);
        Element element5 = XMLUtil.createElementWithContent((Document)this.configDoc, (String)"property", (String)string);
        element5.setAttribute("name", "memorysize");
        XMLUtil.appendChildNode((Node)element2, (Node)element5);
        XMLUtil.appendChildNode((Node)element, (Node)element2);
        this.configDoc.appendChild(element);
        return this.configDoc;
    }

    private Document createDoc() {
        Element element;
        this.sysDoc = XMLUtil.createDocument();
        Element element2 = this.sysDoc.createElement("table");
        element2.setAttribute("name", "system");
        Element element3 = this.sysDoc.createElement("instance");
        element3.setAttribute("id", System.getProperties().getProperty("HOST_ID"));
        Element element4 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.name);
        element4.setAttribute("name", "platform");
        XMLUtil.appendChildNode((Node)element3, (Node)element4);
        if (!this.name.equals("SUNW,Ultra-Enterprise-10000")) {
            element = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)"false");
            element.setAttribute("name", "ise10k");
            XMLUtil.appendChildNode((Node)element3, (Node)element);
        }
        element = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)"false");
        element.setAttribute("name", "issf15ksc");
        XMLUtil.appendChildNode((Node)element3, (Node)element);
        Element element5 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.release);
        element5.setAttribute("name", "release");
        XMLUtil.appendChildNode((Node)element3, (Node)element5);
        Element element6 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.solRev);
        element6.setAttribute("name", "solarisrevision");
        XMLUtil.appendChildNode((Node)element3, (Node)element6);
        Element element7 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.osrevision);
        element7.setAttribute("name", "osrevision");
        XMLUtil.appendChildNode((Node)element3, (Node)element7);
        if (this.pageSize != -1L && this.numPages != -1L) {
            this.totalMemory = String.valueOf(this.pageSize * this.numPages / 0x100000L);
            Element element8 = XMLUtil.createElementWithContent((Document)this.sysDoc, (String)"property", (String)this.totalMemory);
            element8.setAttribute("name", "totalmemory");
            XMLUtil.appendChildNode((Node)element3, (Node)element8);
        }
        XMLUtil.appendChildNode((Node)element2, (Node)element3);
        this.sysDoc.appendChild(element2);
        return this.sysDoc;
    }

    public Vector getDoc() {
        return this.docs;
    }

    private void runRelease() throws DataCollectionException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader("/etc/release"));
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)"com.sun.vsp.km.ic.collector.iccol.worker.SysWorker", (String)"runRelease()", (String)(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + "/etc/release" + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + "/etc/release" + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {}
        this.release = string.trim();
    }

    private void runSysconf() throws DataCollectionException {
        CollectorProps collectorProps = CollectorProps.getInstance();
        String string = "";
        string = System.getProperty("WORKER_PATH") == null ? String.valueOf(collectorProps.getProperty("worker_path")) + System.getProperty("file.separator") + "sysconfworker" : String.valueOf(System.getProperty("WORKER_PATH")) + System.getProperty("file.separator") + "sysconfworker";
        String string2 = string;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            throw new DataCollectionException("There was a problem running the sysconf collection module.  Exception: " + exception.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string3 = "";
        try {
            string3 = bufferedReader.readLine();
        }
        catch (Exception exception) {}
        this.pageSize = -1L;
        this.numPages = -1L;
        while (string3 != null) {
            try {
                if (string3.startsWith("_SC_PAGESIZE")) {
                    this.pageSize = Long.parseLong(string3.substring(string3.indexOf(58) + 2));
                } else if (string3.startsWith("_SC_PHYS_PAGES")) {
                    this.numPages = Long.parseLong(string3.substring(string3.indexOf(58) + 2));
                }
            }
            catch (Exception exception) {}
            try {
                string3 = bufferedReader.readLine();
            }
            catch (Exception exception) {}
        }
    }

    private void runUname_i() throws DataCollectionException {
        String string = "/usr/bin/uname -i";
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string, envp);
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)"com.sun.vsp.km.ic.collector.iccol.worker.SysWorker", (String)"runUname_i()", (String)(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + "uname -i" + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + "uname -i" + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {}
        this.name = string2.trim();
    }

    private void runUname_r() throws DataCollectionException {
        String string = "/usr/bin/uname -r";
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string, envp);
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)"com.sun.vsp.km.ic.collector.iccol.worker.SysWorker", (String)"runUname_r()", (String)(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + "uname -r" + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + "uname -r" + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {}
        this.osrevision = string2.trim();
        this.solRev = this.osrevision.substring(this.osrevision.lastIndexOf(".") + 1);
    }
}

