/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator.kae;

import com.sun.eras.common.checkstorage.CheckStorageException;
import com.sun.eras.kae.engine.CheckListDesignator;
import com.sun.eras.kae.engine.DataCollectorDesignator;
import com.sun.eras.kae.engine.EngineControllerAPI;
import com.sun.eras.kae.engine.EngineException;
import com.sun.eras.kae.engine.EngineFactory;
import com.sun.eras.kae.engine.EngineListener;
import com.sun.eras.kae.engine.FactStoreDesignator;
import com.sun.eras.kae.engine.FilenameFactStoreDesignator;
import com.sun.eras.kae.engine.XmlFilenameCheckListDesignator;
import com.sun.vsp.km.ic.collector.CollectorIfc;
import com.sun.vsp.km.ic.collector.inputsource.ICDataCollectorDesignator;
import com.sun.vsp.km.ic.util.ICPropIfc;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.ic.validator.AbstractValidator;
import com.sun.vsp.km.ic.validator.CheckResultsIfc;
import com.sun.vsp.km.ic.validator.kae.ICKAEClientAdapter;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.KMLogger;
import java.rmi.RemoteException;

public class KAEValidator
extends AbstractValidator {
    ICKAEClientAdapter kaeClientAdapter;
    protected String checkListFileName;
    protected String factsFileName;
    protected String explorerDirectory;
    protected String _home;
    protected ICPropIfc _prop = null;
    protected static String CHARSET_NAME = "UTF-8";

    public KAEValidator() {
        super("$Revision: 1.6 $");
    }

    public KAEValidator(CollectorIfc collectorIfc) throws KMException {
        this();
        this.setCollector(collectorIfc);
    }

    public KAEValidator(String string) {
        this();
        this.setExplorerDirectory(string);
    }

    public KAEValidator(String string, String string2) {
        this();
        this.setCheckListFileName(string);
        this.setExplorerDirectory(string2);
    }

    public int checksTotal() {
        int n = 0;
        if (this.kaeClientAdapter != null) {
            n = this.kaeClientAdapter.getNumberOfChecks();
        }
        return n;
    }

    public int getCompletedChecks() {
        int n = 0;
        if (this.kaeClientAdapter != null) {
            n = this.kaeClientAdapter.getCompletedChecks();
        }
        return n;
    }

    public KMException getException() {
        if (this.kaeClientAdapter != null) {
            return this.kaeClientAdapter.kmException;
        }
        return null;
    }

    public CheckResultsIfc getResults() {
        if (this.kaeClientAdapter != null) {
            return this.kaeClientAdapter.getCheckResults();
        }
        return null;
    }

    public int getStatus() {
        int n = 3;
        if (this.kaeClientAdapter != null) {
            switch (this.kaeClientAdapter.getStatus()) {
                case 2: {
                    n = 2;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                default: {
                    n = 3;
                    break;
                }
            }
        }
        return n;
    }

    protected void init() throws KMException {
        this.log(KMLogger.INFO, "Begin Initializing the validator");
        this.kaeClientAdapter = new ICKAEClientAdapter();
        this._prop = ICProperties.getInstance();
        this._home = String.valueOf(System.getProperty("ICAPP_HOME")) + System.getProperty("file.separator");
        try {
            if (this.checkListFileName != null) {
                this.factsFileName = String.valueOf(this._prop.getProperty("worker_path")) + System.getProperty("file.separator") + this._prop.getProperty("facts_path");
                this.log(KMLogger.INFO, "Checklist file name [" + this.checkListFileName + "]");
                this.log(KMLogger.INFO, "Facts file name [" + this.factsFileName + "]");
            } else {
                this.checkListFileName = String.valueOf(this._prop.getProperty("worker_path")) + System.getProperty("file.separator") + this._prop.getProperty("checklist");
                this.factsFileName = String.valueOf(this._prop.getProperty("worker_path")) + System.getProperty("file.separator") + this._prop.getProperty("facts_path");
                this.log(KMLogger.INFO, "Checklist file name [" + this.checkListFileName + "]");
                this.log(KMLogger.INFO, "Facts file name [" + this.factsFileName + "]");
            }
        }
        catch (Exception exception) {
            throw new KMException(exception.getMessage(), 5208L);
        }
        this.log(KMLogger.INFO, "Validator initialization complete");
    }

    public Thread runChecks() throws KMException {
        this.init();
        Thread thread = null;
        try {
            this.log(KMLogger.INFO, "Start the kae engine");
        }
        catch (KMException kMException) {}
        if (this.kaeClientAdapter != null) {
            try {
                XmlFilenameCheckListDesignator xmlFilenameCheckListDesignator = new XmlFilenameCheckListDesignator(this.checkListFileName);
                xmlFilenameCheckListDesignator.setValidating(false);
                FilenameFactStoreDesignator filenameFactStoreDesignator = new FilenameFactStoreDesignator(this.factsFileName, null);
                ICDataCollectorDesignator iCDataCollectorDesignator = new ICDataCollectorDesignator();
                iCDataCollectorDesignator.addInputSource("com.sun.vsp.km.ic.collector.inputsource.ICInputSource", new Class[0], new Object[0]);
                boolean bl = false;
                EngineFactory engineFactory = EngineFactory.getInstance();
                EngineControllerAPI engineControllerAPI = engineFactory.getEngine((CheckListDesignator)xmlFilenameCheckListDesignator, (FactStoreDesignator)filenameFactStoreDesignator, (DataCollectorDesignator)iCDataCollectorDesignator, bl);
                engineControllerAPI.addListener((EngineListener)this.kaeClientAdapter);
                thread = engineControllerAPI.executeAsynchronously("KAE2");
            }
            catch (CheckStorageException checkStorageException) {
                throw new KMException(checkStorageException.getMessage(), 5301L);
            }
            catch (EngineException engineException) {
                throw new KMException(engineException.getMessage(), 5210L);
            }
            catch (RemoteException remoteException) {
                throw new KMException(remoteException.getMessage(), 5210L);
            }
        } else {
            throw new KMException(5208L);
        }
        try {
            this.log(KMLogger.INFO, "Engine started");
        }
        catch (KMException kMException) {}
        return thread;
    }

    public void setCheckListFileName(String string) {
        this.checkListFileName = string;
    }

    public void setCollector(CollectorIfc collectorIfc) {
        super.setCollector(collectorIfc);
    }

    protected void setExplorerDirectory(String string) {
        this.explorerDirectory = string;
    }

    public void setFactFileName(String string) {
        this.factsFileName = string;
    }
}

