/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator.kae;

import com.sun.eras.kae.engine.CheckFinishedEvent;
import com.sun.eras.kae.engine.CheckListFinishedEvent;
import com.sun.eras.kae.engine.CheckListStartedEvent;
import com.sun.eras.kae.engine.CheckStartedEvent;
import com.sun.eras.kae.engine.EngineErrorEvent;
import com.sun.eras.kae.engine.EngineException;
import com.sun.eras.kae.engine.EngineListener;
import com.sun.eras.kae.engine.EngineViewAPI;
import com.sun.vsp.km.ic.validator.CheckAttributeIfc;
import com.sun.vsp.km.ic.validator.CheckResultsIfc;
import com.sun.vsp.km.ic.validator.XMLCheckAttributeImpl;
import com.sun.vsp.km.ic.validator.XMLCheckResults;
import com.sun.vsp.km.ic.validator.kae.ERASCheckResultsMap;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.KMLogger;
import java.util.Date;

public class ICKAEClientAdapter
implements EngineListener {
    protected XMLCheckResults checkResults;
    protected XMLCheckResults tempCheckResults;
    protected int checksCompleted = 0;
    protected int numberOfChecks = 0;
    protected int status = 0;
    protected Date beginTime;
    protected Date endTime;
    protected KMException kmException;

    public void checkFinished(CheckFinishedEvent checkFinishedEvent) {
        this.status = 2;
        ERASCheckResultsMap eRASCheckResultsMap = new ERASCheckResultsMap(checkFinishedEvent);
        this.tempCheckResults.addCheck(eRASCheckResultsMap.getICCheck());
        this.incrementChecksCompleted();
    }

    public void checkListFinished(CheckListFinishedEvent checkListFinishedEvent) {
        this.checkResults = this.tempCheckResults;
        Long l = new Long(new Date().getTime() - this.beginTime.getTime());
        String string = "RunBeginTime=" + this.beginTime;
        this.tempCheckResults.addAttribute(new XMLCheckAttributeImpl("running_time", l.toString()));
        this.tempCheckResults = null;
        this.status = 1;
    }

    public void checkListStarted(CheckListStartedEvent checkListStartedEvent) {
        this.status = 2;
        try {
            Object object;
            this.checkResults = null;
            this.tempCheckResults = new XMLCheckResults();
            EngineViewAPI engineViewAPI = checkListStartedEvent.getSourceEngine();
            String string = null;
            this.setNumberOfChecks(checkListStartedEvent.getCheckCount());
            string = engineViewAPI.getKAEVersion();
            if (string != null) {
                object = new XMLCheckAttributeImpl("kae_version", string);
                this.tempCheckResults.addAttribute((CheckAttributeIfc)object);
            }
            object = engineViewAPI.newInstanceOfKAEResult().getGeneralInfo().getReportDate().getStringDate();
            this.tempCheckResults.addAttribute(new XMLCheckAttributeImpl("rundate", (String)object));
            this.tempCheckResults.addAttribute(new XMLCheckAttributeImpl("explorerFile", engineViewAPI.getDataCollectorDesignator().getDescription()));
            this.tempCheckResults.addAttribute(new XMLCheckAttributeImpl("generatedBy", engineViewAPI.newInstanceOfKAEResult().getGeneratedByInfo().toString()));
            this.beginTime = new Date();
            String string2 = "RunBeginTime=" + this.beginTime.getTime();
            this.tempCheckResults.addAttribute(new XMLCheckAttributeImpl("meta_data", string2, 4));
        }
        catch (EngineException engineException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"checkListStarted", (String)engineException.getMessage());
        }
    }

    public void checkStarted(CheckStartedEvent checkStartedEvent) {
        this.status = 2;
    }

    public void engineError(EngineErrorEvent engineErrorEvent) {
        this.kmException = engineErrorEvent.getException() != null ? new KMException(engineErrorEvent.getException().getMessage(), 5210L) : new KMException(5210L);
        this.status = 4;
    }

    public CheckResultsIfc getCheckResults() {
        return this.checkResults;
    }

    public int getCompletedChecks() {
        return this.checksCompleted;
    }

    public int getNumberOfChecks() {
        return this.numberOfChecks;
    }

    public int getStatus() {
        return this.status;
    }

    protected void incrementChecksCompleted() {
        ++this.checksCompleted;
    }

    public void setNumberOfChecks(int n) {
        this.numberOfChecks = n;
    }
}

