/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator.kae;

import com.sun.eras.common.checks.CheckExternalProperties;
import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.kaeresult.CheckResults;
import com.sun.eras.common.kaeresult.RawCml;
import com.sun.eras.common.translator.TranslationException;
import com.sun.eras.common.translator.cml.CmlTranslator;
import com.sun.eras.common.translator.cml.CmlTranslatorFactory;
import com.sun.eras.common.translator.cml.TranslatorFactoryInitializationException;
import com.sun.eras.kae.engine.CheckFinishedEvent;
import com.sun.eras.kae.engine.DataCollectorDesignator;
import com.sun.eras.kae.engine.EngineException;
import com.sun.eras.kae.engine.EngineViewAPI;
import com.sun.vsp.km.ic.validator.CheckIfc;
import com.sun.vsp.km.ic.validator.CheckImpl;
import com.sun.vsp.km.ic.validator.XMLCheckAttributeImpl;
import com.sun.vsp.km.util.KMLogger;

public class ERASCheckResultsMap {
    CheckIfc check;

    protected ERASCheckResultsMap(CheckFinishedEvent checkFinishedEvent) {
        this.init(checkFinishedEvent);
    }

    protected void fillAttributes(CheckImpl checkImpl, CheckExternalProperties checkExternalProperties, DataCollectorDesignator dataCollectorDesignator) {
        XMLCheckAttributeImpl xMLCheckAttributeImpl;
        if (checkExternalProperties.getMinRequiredKaeVersion() != null) {
            xMLCheckAttributeImpl = new XMLCheckAttributeImpl("min_required_kae_version", checkExternalProperties.getMinRequiredKaeVersion(), 3);
            checkImpl.addAttribute(xMLCheckAttributeImpl);
        }
        if (dataCollectorDesignator.getDescription() != null) {
            xMLCheckAttributeImpl = new XMLCheckAttributeImpl("explorer_path", dataCollectorDesignator.getDescription(), 4);
            checkImpl.addAttribute(xMLCheckAttributeImpl);
        }
        if (checkExternalProperties.getHumanRule() != null) {
            xMLCheckAttributeImpl = new XMLCheckAttributeImpl("human_rule", checkExternalProperties.getHumanRule(), 4);
            checkImpl.addAttribute(xMLCheckAttributeImpl);
        }
        if (checkExternalProperties.getRevisionNumberString() != null) {
            xMLCheckAttributeImpl = new XMLCheckAttributeImpl("revision_number", checkExternalProperties.getRevisionNumberString(), 3);
            checkImpl.addAttribute(xMLCheckAttributeImpl);
        }
    }

    protected void fillCheckData(CheckImpl checkImpl, CheckExternalProperties checkExternalProperties, DataCollectorDesignator dataCollectorDesignator) {
        this.fillAttributes(checkImpl, checkExternalProperties, dataCollectorDesignator);
        checkImpl.setSeverity(checkExternalProperties.getSeverity().intValue());
        checkImpl.setCheckNumber(new Integer(checkExternalProperties.getId()));
        checkImpl.setProblemDescription(checkExternalProperties.getProblem());
    }

    protected void fillCheckResults(CheckImpl checkImpl, CheckResults checkResults) {
        checkImpl.setApplicability(checkResults.isApplicable());
        if (checkResults.isApplicable()) {
            checkImpl.setPassed(checkResults.isConditionPasses());
        }
        checkImpl.setExecutionError(checkResults.isErrored());
        if (checkResults.isErrored()) {
            checkImpl.setExecutionErrorDescription(checkResults.getErrorMessage());
        }
    }

    protected String getAnalysis(CheckFinishedEvent checkFinishedEvent) {
        String string = null;
        try {
            String string2 = checkFinishedEvent.getCheckId();
            EngineViewAPI engineViewAPI = checkFinishedEvent.getSourceEngine();
            CheckExternalProperties checkExternalProperties = engineViewAPI.getCheck(string2);
            CheckResults checkResults = engineViewAPI.getCheckResults(string2);
            RawCml rawCml = checkResults.getAnalysisCml();
            if (rawCml == null) {
                string = checkExternalProperties.getAnalysis();
            } else {
                CmlTranslatorFactory cmlTranslatorFactory = CmlTranslatorFactory.getInstance();
                CmlTranslator cmlTranslator = cmlTranslatorFactory.createCmlTranslator("TEXT");
                string = cmlTranslator.translate(rawCml.getAsString());
            }
        }
        catch (TranslatorFactoryInitializationException translatorFactoryInitializationException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getAnalysis", (String)translatorFactoryInitializationException.getMessage());
        }
        catch (TranslationException translationException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getAnalysis", (String)translationException.getMessage());
        }
        catch (EngineException engineException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getAnalysis", (String)engineException.getMessage());
        }
        return string;
    }

    public CheckIfc getICCheck() {
        return this.check;
    }

    protected String getRecommendation(CheckFinishedEvent checkFinishedEvent) {
        String string = null;
        try {
            String string2 = checkFinishedEvent.getCheckId();
            EngineViewAPI engineViewAPI = checkFinishedEvent.getSourceEngine();
            CheckExternalProperties checkExternalProperties = engineViewAPI.getCheck(string2);
            CheckResults checkResults = engineViewAPI.getCheckResults(string2);
            RawCml rawCml = checkResults.getRecommendationsCml();
            if (rawCml == null) {
                string = checkExternalProperties.getRecommendations();
            } else {
                CmlTranslatorFactory cmlTranslatorFactory = CmlTranslatorFactory.getInstance();
                CmlTranslator cmlTranslator = cmlTranslatorFactory.createCmlTranslator("TEXT");
                string = cmlTranslator.translate(rawCml.getAsString());
            }
        }
        catch (TranslatorFactoryInitializationException translatorFactoryInitializationException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getRecommendation", (String)translatorFactoryInitializationException.getMessage());
        }
        catch (TranslationException translationException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getRecommendation", (String)translationException.getMessage());
        }
        catch (EngineException engineException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getRecommendation", (String)engineException.getMessage());
        }
        return string;
    }

    protected int getSeverity(CheckFinishedEvent checkFinishedEvent) {
        int n = 0;
        try {
            String string = checkFinishedEvent.getCheckId();
            EngineViewAPI engineViewAPI = checkFinishedEvent.getSourceEngine();
            CheckExternalProperties checkExternalProperties = engineViewAPI.getCheck(string);
            CheckResults checkResults = engineViewAPI.getCheckResults(string);
            int n2 = 0;
            if (checkResults.getSeverity() != null) {
                n2 = checkResults.getSeverity().intValue();
            }
            if (n2 == CheckSeverity.CRITICAL.intValue()) {
                n = 4;
            } else if (n2 == CheckSeverity.LOW.intValue()) {
                n = 1;
            } else if (n2 == CheckSeverity.HIGH.intValue()) {
                n = 3;
            } else if (n2 == CheckSeverity.MODERATE.intValue()) {
                n = 2;
            }
        }
        catch (EngineException engineException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"getSeverity", (String)engineException.getMessage());
        }
        return n;
    }

    protected void init(CheckFinishedEvent checkFinishedEvent) {
        try {
            CheckImpl checkImpl = new CheckImpl();
            String string = checkFinishedEvent.getCheckId();
            EngineViewAPI engineViewAPI = checkFinishedEvent.getSourceEngine();
            this.fillCheckData(checkImpl, engineViewAPI.getCheck(string), engineViewAPI.getDataCollectorDesignator());
            this.fillCheckResults(checkImpl, engineViewAPI.getCheckResults(string));
            checkImpl.setSeverity(this.getSeverity(checkFinishedEvent));
            checkImpl.setAnalysis(this.getAnalysis(checkFinishedEvent));
            checkImpl.setRecommendation(this.getRecommendation(checkFinishedEvent));
            this.check = checkImpl;
        }
        catch (EngineException engineException) {
            KMLogger.log((int)KMLogger.SEVERE, (String)this.getClass().getName(), (String)"init", (String)engineException.getMessage());
        }
    }
}

