/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.reports;

import com.sun.vsp.km.ic.reports.XMLReportElementIfc;
import com.sun.vsp.km.ic.reports.XMLReportIfc;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.XMLUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTReportImpl
implements XMLReportIfc {
    protected String xsltFileName;
    protected String reportFileName;
    protected Document doc = this.createDocument();

    public XSLTReportImpl() throws KMException {
    }

    public XSLTReportImpl(String string, String string2) throws KMException {
        this();
        this.xsltFileName = string;
        this.reportFileName = string2;
    }

    public void addReportElement(XMLReportElementIfc xMLReportElementIfc) throws KMException {
        Element element = this.doc.getDocumentElement();
        Node node = this.doc.importNode(xMLReportElementIfc.getElement(), true);
        element.appendChild(node);
    }

    protected Document createDocument() throws KMException {
        Document document = XMLUtil.createDocument();
        Element element = document.createElement("icreport");
        document.appendChild(element);
        return document;
    }

    public void generateReport() throws KMException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(this.xsltFileName));
            transformer.transform(new DOMSource(this.doc), new StreamResult(new FileOutputStream(this.reportFileName)));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            new KMException(transformerConfigurationException.getMessage(), 5208L);
        }
        catch (TransformerException transformerException) {
            new KMException(transformerException.getMessage(), 5208L);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new KMException(fileNotFoundException.getMessage(), 5005L);
        }
    }

    public String getStorageLocation() {
        return this.reportFileName;
    }

    public void setReportFileName(String string) {
        this.reportFileName = string;
    }

    public void setStorageLocation(String string) {
        this.reportFileName = string;
    }

    public void setXSLTFileName(String string) {
        this.xsltFileName = string;
    }
}

