/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.icapp;

import com.sun.vsp.km.framework.KMObjectIfc;
import com.sun.vsp.km.ic.cli.CLI;
import com.sun.vsp.km.ic.gui.ICGui;
import com.sun.vsp.km.ic.help.HelpManager;
import com.sun.vsp.km.ic.help.HelpManagerIfc;
import com.sun.vsp.km.ic.icapp.TaskManager;
import com.sun.vsp.km.ic.icapp.UserInterface;
import com.sun.vsp.km.ic.icapp.beans.CustomerBean;
import com.sun.vsp.km.ic.util.ICPropIfc;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.ic.util.SystemMessageLookup;
import com.sun.vsp.km.ic.validator.ValidatorIfc;
import com.sun.vsp.km.ic.validator.kae.KAEUtil;
import com.sun.vsp.km.ic.validator.kae.KAEValidator;
import com.sun.vsp.km.util.CleanUpUtil;
import com.sun.vsp.km.util.FileUtil;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.valueobj.Customer;
import java.io.File;
import java.util.Locale;

public class ICMain {
    private ICPropIfc _prop = null;
    private UserInterface _ui = null;
    private TaskManager _tm = null;
    private String _home = null;
    private Customer _cust = null;
    private ValidatorIfc _val = null;
    private HelpManagerIfc _help = null;
    private static CleanUpUtil _cu = null;
    private Display _display = null;
    private String varloc;
    private String lckfile;
    private String _helpfile;
    private Locale _locale;

    public ICMain(UserInterface userInterface) {
        if (System.getProperty("ICAPP_HOME") == null) {
            System.err.println(SystemMessageLookup.getMessage((long)101L));
            System.exit(2);
        }
        this._prop = ICProperties.getInstance();
        this._locale = Locale.getDefault();
        this._prop.setProperty("locale", this._locale.toString());
        this._helpfile = this._prop.getProperty("helpfile_" + this._locale);
        this._prop.setProperty("icapp_home", System.getProperty("ICAPP_HOME"));
        File file = new File(String.valueOf(System.getProperty("ICAPP_VAR")) + System.getProperty("file.separator") + this._prop.getProperty("data_location"));
        String[] stringArray = file.list();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("translator.xml")) {
                bl = true;
            }
            if (stringArray[n].equals("facts.zip")) {
                bl2 = true;
            }
            if (stringArray[n].equals("checklist.xml")) {
                bl3 = true;
            }
            ++n;
        }
        if (!(bl && bl2 && bl3)) {
            this._prop.setProperty("worker_path", String.valueOf(System.getProperty("ICIS_VAR")) + System.getProperty("file.separator") + this._prop.getProperty("data_location"));
        } else {
            this._prop.setProperty("worker_path", String.valueOf(System.getProperty("ICAPP_VAR")) + System.getProperty("file.separator") + this._prop.getProperty("data_location"));
        }
        System.setProperty("WORKER_PATH", this._prop.getProperty("worker_path"));
        if (System.getProperty("COLLECTOR_OUTPUT_DIR") != null) {
            this._prop.setProperty("collector_output_dir", System.getProperty("COLLECTOR_OUTPUT_DIR"));
        }
        try {
            this._prop.store();
        }
        catch (KMException kMException) {
            kMException.printStackTrace();
        }
        this._home = this._prop.getProperty("icapp_home");
        String string = String.valueOf(this._prop.getProperty("worker_path")) + System.getProperty("file.separator") + this._prop.getProperty("checklist");
        this.varloc = System.getProperty("ICAPP_VAR");
        this.lckfile = this._prop.getProperty("lockfile");
        _cu = new CleanUpUtil(this.varloc, this.lckfile);
        try {
            if (KAEUtil.checkListExpired(string)) {
                System.err.println(SystemMessageLookup.getMessage((long)102L));
                _cu.exitWith(3);
            }
        }
        catch (KMException kMException) {
            kMException.printStackTrace();
        }
        this._ui = userInterface;
        this._tm = TaskManager.getInstance();
        this.setUp();
    }

    private String getPath(String string) {
        return String.valueOf(this._home) + this._prop.getProperty(string);
    }

    public static void main(String[] stringArray) {
        UserInterface userInterface = null;
        if (!System.getProperty("user.name").equals("root")) {
            System.err.println(SystemMessageLookup.getMessage((long)100L));
            System.exit(2);
        }
        try {
            System.setProperty("COL_PATH", stringArray[1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (stringArray[0].equals("gui")) {
            userInterface = new ICGui();
        } else if (stringArray[0].equals("cli")) {
            userInterface = new CLI();
        }
        if (userInterface != null) {
            ICMain iCMain = new ICMain(userInterface);
            iCMain.showUI();
        }
    }

    private void setUp() {
        this._tm.setPersist(false);
        this._display = new Display();
        try {
            _cu.createLock();
        }
        catch (KMException kMException) {
            System.out.println(SystemMessageLookup.getMessage((long)103L));
            System.out.println(String.valueOf(SystemMessageLookup.getMessage((long)104L)) + this.varloc + System.getProperty("file.separator") + this.lckfile);
            System.exit(3);
        }
        this._val = new KAEValidator();
        try {
            String string = String.valueOf(this._home) + System.getProperty("file.separator") + this._helpfile;
            this._help = new HelpManager(string);
        }
        catch (KMException kMException) {
            kMException.printStackTrace();
        }
        this._cust = (Customer)FileUtil.getSerializedObject((String)"Customer");
        if (this._cust == null) {
            this._cust = new CustomerBean();
            this._cust.setData(false);
        } else {
            this._cust.update();
        }
        this._tm.update((KMObjectIfc)_cu);
        this._tm.update(this._val);
        this._tm.update((KMObjectIfc)this._cust);
        this._tm.update(this._help);
        this._tm.setPersist(true);
        this._ui.setNotifier(this._tm);
    }

    public void showUI() {
        this._display.start();
    }

    private class Display
    extends Thread {
        Display() {
        }

        public void run() {
            ICMain.this._ui.interact();
        }
    }
}

