/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.gui;

import com.sun.vsp.km.ic.gui.ICGui;
import com.sun.vsp.km.ic.gui.ICPanel;
import com.sun.vsp.km.ic.gui.JARFilter;
import com.sun.vsp.km.ic.gui.ResultsPanel;
import com.sun.vsp.km.ic.gui.XMLFilter;
import com.sun.vsp.km.ic.icapp.TaskNotifierIfc;
import com.sun.vsp.km.ic.validator.ValidatorIfc;
import com.sun.vsp.km.ic.validator.XMLCheckResultsFromFile;
import com.sun.vsp.km.util.CleanUpUtil;
import com.sun.vsp.km.util.KMLogger;
import com.sun.vsp.km.util.UpdateUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

public class ChoicePanel
extends ICPanel {
    JLabel text;
    JRadioButton cont;
    JRadioButton open;
    JRadioButton update;
    ButtonGroup group;
    JFileChooser fc;
    JFileChooser upfc;
    TaskNotifierIfc task;
    CleanUpUtil clean;

    public ChoicePanel(int n, TaskNotifierIfc taskNotifierIfc) {
        super(n, taskNotifierIfc);
        this.clean = (CleanUpUtil)taskNotifierIfc.getObject("CleanUpUtil");
        this.task = taskNotifierIfc;
        this.addContent();
    }

    public void actionPerformed(ActionEvent actionEvent) throws ArrayIndexOutOfBoundsException {
        try {
            if (actionEvent.getSource().equals(this.cancel)) {
                this.clean.exitWith(0);
            } else if (actionEvent.getSource().equals(this.back)) {
                ICGui.switchPanel(2);
            } else if (actionEvent.getSource().equals(this.next)) {
                if (this.cont.isSelected()) {
                    ICGui.switchPanel(3);
                } else if (this.open.isSelected()) {
                    this.openFile();
                } else if (this.update.isSelected()) {
                    this.openUpdate();
                }
            } else if (actionEvent.getSource().equals(this.help)) {
                ICGui.helpVisible(true);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            KMLogger.log((int)KMLogger.WARNING, (String)"ChoicePanel.java", (String)"actionPerformed()", (String)"ICGui.SwitchPanel() called with bad index");
        }
    }

    protected void addContent() {
        this.subtitle.setText(ICPanel.messages.getString("ChoiceTitle"));
        this.text = new JLabel(ICPanel.messages.getString("ChoiceText"));
        this.text.setBackground(this.backgroundColor);
        this.text.setFont(new Font(null, 0, 12));
        this.text.setForeground(Color.black);
        this.cont = new JRadioButton(ICPanel.messages.getString("ChoiceContinue"));
        this.cont.setBackground(this.backgroundColor);
        this.cont.setSelected(true);
        this.cont.setFont(new Font(null, 0, 12));
        this.open = new JRadioButton(ICPanel.messages.getString("ChoiceOpen"));
        this.open.setBackground(this.backgroundColor);
        this.open.setFont(new Font(null, 0, 12));
        this.update = new JRadioButton(ICPanel.messages.getString("ChoiceUpdate"));
        this.update.setBackground(this.backgroundColor);
        this.update.setFont(new Font(null, 0, 12));
        this.group = new ButtonGroup();
        this.group.add(this.cont);
        this.group.add(this.open);
        this.group.add(this.update);
        this.content.setLayout(this.gridbag);
        this.c.insets = new Insets(12, 12, 0, 6);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.titleBackground, this.c);
        this.content.add(this.titleBackground);
        this.c.insets = new Insets(12, 18, 0, 23);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.text, this.c);
        this.content.add(this.text);
        this.c.insets = new Insets(0, 34, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 0.5;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 16;
        this.gridbag.setConstraints(this.cont, this.c);
        this.content.add(this.cont);
        this.c.insets = new Insets(6, 34, 6, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.fill = 10;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.open, this.c);
        this.content.add(this.open);
        this.c.insets = new Insets(0, 34, 12, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.update, this.c);
        this.content.add(this.update);
    }

    protected void openFile() {
        String string = String.valueOf(System.getProperty("ICAPP_VAR")) + System.getProperty("file.separator") + this.prop.getProperty("reports") + System.getProperty("file.separator");
        this.fc = new JFileChooser(string);
        this.fc.setDialogTitle(ICPanel.messages.getString("OpenTitle"));
        this.fc.addChoosableFileFilter(new XMLFilter());
        int n = this.fc.showOpenDialog(this);
        File file = this.fc.getSelectedFile();
        if (n == 0) {
            try {
                XMLCheckResultsFromFile xMLCheckResultsFromFile = new XMLCheckResultsFromFile(String.valueOf(string) + this.fc.getName(file));
                ICGui.panel[5] = new ResultsPanel(5, this.task, xMLCheckResultsFromFile, this.fc.getName(file));
                ((ResultsPanel)ICGui.panel[5]).next.setEnabled(false);
                ((ResultsPanel)ICGui.panel[5]).filename = this.fc.getName(file);
                ICGui.switchPanel(5);
            }
            catch (Exception exception) {
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, ICPanel.messages.getString("OpenError"), ICPanel.messages.getString("OpenErrorTitle"), 2);
                KMLogger.log((int)KMLogger.WARNING, (String)"ChoicePanel", (String)"openFile()", (String)ICPanel.messages.getString("OpenError"));
            }
        } else {
            return;
        }
    }

    protected void openUpdate() {
        String string = this.prop.getProperty("update_location");
        this.upfc = new JFileChooser(string);
        this.upfc.setDialogTitle(ICPanel.messages.getString("UpdateTitle"));
        this.upfc.addChoosableFileFilter(new JARFilter());
        int n = this.upfc.showOpenDialog(this);
        File file = this.upfc.getSelectedFile();
        String string2 = String.valueOf(System.getProperty("ICAPP_VAR")) + System.getProperty("file.separator") + "data" + System.getProperty("file.separator");
        if (n == 0) {
            this.prop.setProperty("update_location", file.getPath().substring(0, file.getPath().lastIndexOf(47) + 1));
            UpdateUtil updateUtil = new UpdateUtil(file.getPath());
            int n2 = updateUtil.update(string2);
            if (n2 == 0) {
                this.prop.setProperty("worker_path", String.valueOf(System.getProperty("ICAPP_VAR")) + System.getProperty("file.separator") + this.prop.getProperty("data_location"));
                System.setProperty("WORKER_PATH", this.prop.getProperty("worker_path"));
                try {
                    this.prop.store();
                }
                catch (Exception exception) {}
                try {
                    ValidatorIfc validatorIfc = (ValidatorIfc)this.tn.getObject("Validator");
                    validatorIfc.setCheckListFileName(String.valueOf(this.prop.getProperty("worker_path")) + System.getProperty("file.separator") + this.prop.getProperty("checklist"));
                    validatorIfc.setFactFileName(String.valueOf(this.prop.getProperty("worker_path")) + System.getProperty("file.separator") + this.prop.getProperty("facts_path"));
                }
                catch (Exception exception) {}
                JOptionPane.showMessageDialog(null, ICPanel.messages.getString("UpdateSuccess"), ICPanel.messages.getString("UpdateSuccessTitle"), 1);
            } else if (n2 == 1) {
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, ICPanel.messages.getString("UpdateError"), ICPanel.messages.getString("UpdateErrorTitle"), 2);
                KMLogger.log((int)KMLogger.WARNING, (String)"ChoicePanel", (String)"openUpdate()", (String)ICPanel.messages.getString("UpdateError"));
            }
        } else {
            return;
        }
    }
}

