/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.cli;

import com.sun.vsp.km.ic.cli.MainMenu;
import com.sun.vsp.km.ic.cli.Menu;
import com.sun.vsp.km.ic.cli.MenuUtil;
import com.sun.vsp.km.ic.help.HelpManagerIfc;
import com.sun.vsp.km.ic.help.HelpTopic;
import com.sun.vsp.km.ic.help.HelpTopicIfc;
import com.sun.vsp.km.ic.util.CLIMessageLookup;
import java.util.Hashtable;

public class HelpMenu
extends Menu {
    private static HelpMenu thisMenu = null;
    private String statusMsg = "";
    private Menu nextMenu = null;
    protected static HelpManagerIfc helpManager = HelpMenu.getHelpManager();
    protected HelpTopicIfc currentTopic;
    protected int selectStart;
    protected Hashtable selectionTable = new Hashtable();

    public HelpMenu() {
        this.currentTopic = HelpMenu.getHelpManager();
    }

    protected static HelpManagerIfc getHelpManager() {
        return (HelpManagerIfc)Menu.tn.getObject("Help");
    }

    public static Menu getMenu() {
        if (thisMenu == null) {
            thisMenu = new HelpMenu();
        }
        return thisMenu;
    }

    public Menu getNextMenu() {
        return this.nextMenu;
    }

    public String getPrompt() {
        return CLIMessageLookup.getMessage((long)1117L);
    }

    public String processSelection(String string) {
        int n = -1;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n == 1) {
            this.currentTopic = HelpMenu.getHelpManager();
            this.nextMenu = MainMenu.getMenu();
        } else if (n == 2 && this.currentTopic != helpManager) {
            this.currentTopic = this.currentTopic.getParentTopic();
        } else if (n != -1 && n - this.selectStart - 1 < this.currentTopic.subTopicCount()) {
            HelpTopicIfc helpTopicIfc = (HelpTopicIfc)this.selectionTable.get(string);
            if (helpTopicIfc != null) {
                this.currentTopic = helpTopicIfc;
            } else {
                this.statusMsg = CLIMessageLookup.getMessage((long)1118L);
            }
        } else {
            this.statusMsg = CLIMessageLookup.getMessage((long)1118L);
        }
        return null;
    }

    public String show() {
        String string = "";
        this.nextMenu = this;
        string = String.valueOf(string) + MenuUtil.showln(CLIMessageLookup.getMessage((long)3111L));
        string = String.valueOf(string) + MenuUtil.getNewline();
        string = String.valueOf(string) + MenuUtil.showln(this.currentTopic.getTopicDescription());
        string = String.valueOf(string) + MenuUtil.getNewline();
        if (this.currentTopic.hasContent()) {
            string = String.valueOf(string) + this.showHelpContent(this.currentTopic);
        }
        string = String.valueOf(string) + MenuUtil.getNewline();
        string = String.valueOf(string) + MenuUtil.getNewline();
        string = String.valueOf(string) + MenuUtil.showln(CLIMessageLookup.getMessage((long)1112L));
        string = String.valueOf(string) + MenuUtil.getNewline();
        string = String.valueOf(string) + MenuUtil.showln("1.  " + CLIMessageLookup.getMessage((long)2112L));
        this.selectStart = 2;
        if (this.currentTopic.hasContent()) {
            string = String.valueOf(string) + this.showHelpSelection(this.currentTopic);
        } else if (this.currentTopic.subTopicCount() > 0) {
            string = String.valueOf(string) + this.showHelpOptions(this.currentTopic, this.selectStart);
        }
        string = String.valueOf(string) + MenuUtil.getNewline();
        if (this.statusMsg.length() > 0) {
            string = String.valueOf(string) + MenuUtil.showln(this.statusMsg);
            this.statusMsg = "";
        } else {
            string = String.valueOf(string) + MenuUtil.getNewline();
        }
        string = String.valueOf(string) + MenuUtil.getNewline();
        return string;
    }

    protected String showHelpContent(HelpTopicIfc helpTopicIfc) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MenuUtil.wrap(helpTopicIfc.getTopicContent(), 50));
        return stringBuffer.toString();
    }

    protected String showHelpOptions(HelpTopicIfc helpTopicIfc, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (helpTopicIfc.getParentTopic() != null) {
            stringBuffer.append(this.showSelectionNumber(n++, 4));
            stringBuffer.append(MenuUtil.showln(String.valueOf(CLIMessageLookup.getMessage((long)3112L)) + " [" + helpTopicIfc.getParentTopic().getTopicDescription() + "]"));
        }
        if ((n2 = helpTopicIfc.subTopicCount()) > 0) {
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(this.showSelectionNumber(n, 4));
                HelpTopic helpTopic = helpTopicIfc.getSubTopicByIndex(n3);
                stringBuffer.append(helpTopic.getTopicDescription());
                stringBuffer.append(MenuUtil.getNewline());
                this.selectionTable.put(String.valueOf(n), helpTopic);
                ++n;
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    protected String showHelpSelection(HelpTopicIfc helpTopicIfc) {
        StringBuffer stringBuffer = new StringBuffer(this.showSelectionNumber(2, 4));
        stringBuffer.append(MenuUtil.showln(String.valueOf(CLIMessageLookup.getMessage((long)3112L)) + " [" + helpTopicIfc.getParentTopic().getTopicDescription() + "]"));
        return stringBuffer.toString();
    }

    protected String showSelectionNumber(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(n) + ". ");
        while (stringBuffer.length() < n2) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

