/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.services.cdm;

import com.aligo.profile.manager.HeaderMap;
import com.aligo.profile.manager.SearchRule;
import com.aligo.profile.manager.config.ProfileManagerConfig;
import com.aligo.util.HeaderHash;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientDetectionException;
import com.iplanet.services.cdm.ClientDetectionInterface;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.wireless.util.ContentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class MAPClientDetector
implements ClientDetectionInterface {
    protected static Debug debug = Debug.getInstance((String)"MAPClientDetector");
    private static SearchRule[] searchRuleSet_ = null;
    private static HeaderMap[] headerMapSet_ = null;
    private static String dimensionDelim_ = ",";
    private static String stringListDelim_ = ",";
    public static final String DIMENSION_DELIMITER = "x";
    public static final String DIM_DELIM_INCOMING = "/ProfileManager/UAHeaderMapSet/DimensionDelimiter";
    public static final String HTTP_USER_AGENT = "user-agent";
    public static final String CLIENT_TYPE = "clientType";
    public static final String PARENT_ID = "parentId";
    public static final String USER_AGENT = "userAgent";
    private static SSOToken adminToken = null;
    private static final String GENERIC_HTML = "genericHTML";
    protected static DefaultClientTypesManager mngr = (DefaultClientTypesManager)AMClientDetector.getClientTypesManagerInstance();

    protected Client getClient(HttpServletRequest request) {
        String httpUA = request.getHeader(HTTP_USER_AGENT);
        if (debug.messageEnabled()) {
            debug.message("======: Http user-agent Header = " + httpUA);
        }
        if (httpUA == null || httpUA.equals("")) {
            return null;
        }
        HeaderHash headerHash = new HeaderHash(request);
        HashMap header = headerHash.getHashMapHandle();
        Client client = null;
        boolean foundKeyWordMatch = false;
        boolean allowed = mngr.canCreateClients();
        int i = 0;
        while (i < searchRuleSet_.length) {
            SearchRule rule = searchRuleSet_[i];
            String headerAttr = rule.getHeaderAttribute();
            String headerVal = (String)header.get(headerAttr);
            if (rule.getSearchType() == SearchRule.SEARCH_HEADER_ATTRIBUTE_VALUE) {
                String partialMatchRule = rule.getPartialMatchRule();
                client = this.searchLibraries(headerAttr, headerVal, partialMatchRule);
            } else if (headerVal != null && headerVal.indexOf(rule.getSearchString()) != -1) {
                String keyWordMap = rule.getKeywordMap();
                try {
                    client = ClientsManager.getInstance((String)keyWordMap);
                    if (!keyWordMap.equals(GENERIC_HTML) && allowed) {
                        foundKeyWordMatch = true;
                    }
                }
                catch (ClientException ce) {
                    debug.warning("Unknown clientType in KeywordMap: " + keyWordMap);
                }
            }
            if (client != null) {
                if (!foundKeyWordMatch) break;
                if (debug.messageEnabled()) {
                    debug.message("foundKeyWordMatch: Creating new client:");
                }
                try {
                    Map newCD = this.createClientData(client, header);
                    String newCT = this.getFirstAndOnlyString((Set)newCD.get(CLIENT_TYPE));
                    client = this.addClientInternal(newCT, newCD);
                }
                catch (Exception ex) {
                    debug.warning("Error creating client: Returning defaultClientType: ", (Throwable)ex);
                    client = null;
                }
                break;
            }
            ++i;
        }
        return client;
    }

    private Client searchLibraries(String attr, String value, String rule) {
        Client client = null;
        if (value == null || value.equals("")) {
            return client;
        }
        if (attr != null && !attr.equals(HTTP_USER_AGENT)) {
            debug.error("Search with Http-header not supported: " + attr);
            return client;
        }
        if (rule == null || rule.equals("")) {
            client = mngr.getFromUserAgentMap(value);
            return client;
        }
        String cType = mngr.getPartiallyMatchedClient(value);
        if (cType != null) {
            try {
                client = ClientsManager.getInstance((String)cType);
            }
            catch (ClientException ce) {
                client = null;
                debug.error("ClientInstance = null" + cType + " :", (Throwable)ce);
            }
            return client;
        }
        Iterator libKeys = mngr.userAgentSet().iterator();
        String matchedKey = null;
        int matchLen = 0;
        boolean matchFound = false;
        while (libKeys.hasNext()) {
            String libKey = (String)libKeys.next();
            if (rule.equals(SearchRule.STARTS_WITH)) {
                if (value.startsWith(libKey)) {
                    matchFound = true;
                }
            } else if (rule.equals(SearchRule.CONTAINS)) {
                if (value.indexOf(libKey) > -1) {
                    matchFound = true;
                }
            } else if (rule.equals(SearchRule.ENDS_WITH) && value.endsWith(libKey)) {
                matchFound = true;
            }
            if (!matchFound) continue;
            int len = libKey.length();
            if (len > matchLen) {
                matchLen = len;
                matchedKey = libKey;
            }
            matchFound = false;
        }
        if (matchedKey != null) {
            client = mngr.getFromUserAgentMap(matchedKey);
            String ct = client.getClientType();
            mngr.addToPartialMatchMap(value, ct);
        }
        return client;
    }

    /*
     * Unable to fully structure code
     */
    private Map createClientData(Client client, HashMap header) {
        if (header == null) {
            if (MAPClientDetector.debug.messageEnabled()) {
                MAPClientDetector.debug.message("header sent in was null");
            }
            return null;
        }
        newClientData = new HashMap<String, Set>();
        if (client == null) {
            if (MAPClientDetector.debug.messageEnabled()) {
                MAPClientDetector.debug.message("createClientData(): No Parent to inherit from");
            }
        } else {
            parentCT = client.getProperty("clientType");
            if (MAPClientDetector.debug.messageEnabled()) {
                MAPClientDetector.debug.message("createClientData(): Parent: " + parentCT);
            }
            parentData = MAPClientDetector.mngr.getClientTypeData(parentCT);
            parents = new HashSet<String>(1);
            parents.add(parentCT);
            newClientData.put("parentId", parents);
        }
        map = null;
        i = 0;
        while (i < MAPClientDetector.headerMapSet_.length) {
            block11: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    map = MAPClientDetector.headerMapSet_[i];
                                    if (map == null || (hdrAttrVal = (String)header.get(hdrAttrName = map.getHeaderAttribute())) == null || hdrAttrVal.equals("")) break block11;
                                    datatype = map.getUADatatype();
                                    clientProperty = map.getClientProperty();
                                    searchString = map.getSearchString();
                                    value = hdrAttrVal;
                                    if (searchString == null || searchString.equals("")) break block12;
                                    if (hdrAttrVal.indexOf(searchString) != -1) {
                                        value = map.getUADataValue();
                                    }
                                    if (value == null || value.equals("")) break block11;
                                }
                                args = new Object[1];
                                if (!datatype.equals(HeaderMap.UA_DATATYPE_STRING)) break block13;
                                args[0] = value.trim();
                                ** GOTO lbl54
                            }
                            if (!datatype.equals(HeaderMap.UA_DATATYPE_DIMENSION)) break block14;
                            args[0] = value.replace(MAPClientDetector.dimensionDelim_.charAt(0), "x".charAt(0));
                            ** GOTO lbl54
                        }
                        if (!datatype.equals(HeaderMap.UA_DATATYPE_NUMBER)) break block15;
                        args[0] = this.convertToInt(value);
                        ** GOTO lbl54
                    }
                    if (!datatype.equals(HeaderMap.UA_DATATYPE_STRINGLIST)) break block16;
                    args = this.getAttributeTokens(value, MAPClientDetector.stringListDelim_);
                    ** GOTO lbl54
                }
                if (!datatype.equals(HeaderMap.UA_DATATYPE_BOOLEAN)) {
                    MAPClientDetector.debug.warning("Unknown UADataType (prop) = " + clientProperty);
                } else {
                    args[0] = this.convertToBoolean(value);
lbl54:
                    // 5 sources

                    props = this.createSet(args);
                    newClientData.put(clientProperty, props);
                }
            }
            ++i;
        }
        uaSet = (Set)newClientData.get("userAgent");
        userAgent = this.getFirstAndOnlyString(uaSet);
        ctSet = this.makeClientType(userAgent);
        newClientData.put("clientType", ctSet);
        if (MAPClientDetector.debug.messageEnabled()) {
            MAPClientDetector.debug.message("Created ClientMap = " + newClientData);
        }
        return newClientData;
    }

    private Boolean convertToBoolean(String value) {
        Boolean bool = null;
        bool = value != null && (value.toLowerCase().equals("1") || value.toLowerCase().equals("true") || value.toLowerCase().equals("on") || value.toLowerCase().equals("yes")) ? new Boolean(true) : new Boolean(false);
        return bool;
    }

    private Integer convertToInt(String value) {
        Integer num = null;
        try {
            num = new Integer(value);
        }
        catch (Exception ex1) {
            try {
                num = Integer.decode(value);
            }
            catch (Exception ex2) {
                try {
                    num = Integer.decode("0x" + value);
                }
                catch (Exception ex3) {
                    debug.warning(".createProfile - Error converting String to number " + value, (Throwable)ex3);
                }
            }
        }
        return num;
    }

    private String[] getAttributeTokens(String attribute, String delimiter) {
        StringTokenizer st = new StringTokenizer(attribute, delimiter);
        int numTokens = st.countTokens();
        String[] tokens = new String[numTokens];
        int i = 0;
        while (i < numTokens && st.hasMoreTokens()) {
            tokens[i] = st.nextToken().trim();
            ++i;
        }
        return tokens;
    }

    private Set createSet(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        HashSet<String> retVal = new HashSet<String>(args.length);
        int i = 0;
        while (i < args.length) {
            retVal.add(args[i].toString());
            ++i;
        }
        return retVal;
    }

    protected Set createSet(String val) {
        HashSet<String> retVal = new HashSet<String>(1);
        retVal.add(val);
        return retVal;
    }

    protected String getFirstAndOnlyString(Set set) {
        String retVal = null;
        if (set != null && set.size() == 1) {
            retVal = (String)set.iterator().next();
        }
        return retVal;
    }

    protected Set makeClientType(String userAgent) {
        String escapedUA = ContentUtils.escapeClientType((String)userAgent);
        Set ctSet = this.createSet(escapedUA);
        return ctSet;
    }

    public String getClientType(HttpServletRequest request) throws ClientDetectionException {
        String clientType = null;
        Client ct = null;
        try {
            ct = this.getClient(request);
        }
        catch (Throwable t) {
            debug.warning("getClientType() failed: ", t);
            ct = null;
        }
        if (ct == null) {
            if (debug.messageEnabled()) {
                debug.message("getClientType() Return DefaultInstance: ");
            }
            ct = ClientsManager.getDefaultInstance();
        }
        clientType = ct.getClientType();
        if (debug.messageEnabled()) {
            debug.message("======: getClientType() Returning: " + clientType);
        }
        return clientType;
    }

    private Client addClientInternal(String ct, Map cMap) throws AMClientCapException {
        boolean addToInternal = true;
        return this.addClient(ct, cMap, addToInternal);
    }

    protected Client addClient(String ct, Map cMap, boolean internal) throws AMClientCapException {
        Client c = mngr.addClient(adminToken, ct, cMap, internal);
        return c;
    }

    static {
        try {
            adminToken = SSOTokenManager.getInstance().createSSOToken(new Principal(){

                public String getName() {
                    return AdminUtils.getAdminDN();
                }
            }, new String(AdminUtils.getAdminPassword()));
        }
        catch (Exception soe) {
            debug.error("Could not get SSOToken: ", (Throwable)soe);
        }
        try {
            String profileManagerXml = AMClientCapData.getInternalInstance().getProfileManagerXML();
            InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(profileManagerXml.getBytes()));
            ProfileManagerConfig.init((Reader)inputStreamReader);
            headerMapSet_ = ProfileManagerConfig.getHeaderMaps();
            searchRuleSet_ = ProfileManagerConfig.getSearchRules();
            String tempChar = ProfileManagerConfig.resolve((String)DIM_DELIM_INCOMING);
            if (tempChar != null && !tempChar.equals("")) {
                dimensionDelim_ = tempChar;
            }
            if ((tempChar = ProfileManagerConfig.resolve((String)"/ProfileManager/UAHeaderMapSet/StringListDelimiter")) != null && !tempChar.equals("")) {
                stringListDelim_ = tempChar;
            }
        }
        catch (Exception ex) {
            String msg = "Error loading XML configuration file: ";
            debug.error(msg + ex.getMessage(), (Throwable)ex);
        }
    }
}

