/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.xhtml;

import com.aligo.xhtml.exceptions.XHtmlAttributeCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementCloneFailedException;
import com.aligo.xhtml.exceptions.XHtmlElementIndexOutOfBoundsException;
import com.aligo.xhtml.exceptions.XHtmlElementNotFoundException;
import com.aligo.xhtml.exceptions.XHtmlTextCannotBeResetException;
import com.aligo.xhtml.exceptions.XHtmlTextCannotBeSetException;
import com.aligo.xhtml.exceptions.XHtmlTextNotSetException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlElementCollection
implements XHtmlElement {
    Vector elements = new Vector();

    public String getName() {
        return "XHtmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addXHtmlElementAt(XHtmlElement element, int index) throws XHtmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addXHtmlElement(XHtmlElement element) throws XHtmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public XHtmlElement xhtmlElementAt(int loc) throws XHtmlElementIndexOutOfBoundsException {
        try {
            return (XHtmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new XHtmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int xhtmlElementIndex(XHtmlElement xhtmlElement) throws XHtmlElementNotFoundException {
        int index = this.elements.indexOf(xhtmlElement);
        if (index == -1) {
            throw new XHtmlElementNotFoundException();
        }
        return this.elements.indexOf(xhtmlElement);
    }

    public void removeXHtmlElement(int index) throws XHtmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new XHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeXHtmlElement(XHtmlElement xhtmlElement) throws XHtmlElementNotFoundException {
        boolean present = this.elements.remove(xhtmlElement);
        if (!present) {
            throw new XHtmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areXHtmlChildrenSane() {
        return true;
    }

    public void addXHtmlAttribute(String name, String value) throws XHtmlAttributeCannotBeAddedException {
        throw new XHtmlAttributeCannotBeAddedException();
    }

    public String getXHtmlAttributeValue(String name) {
        return null;
    }

    public String changeXHtmlAttribute(String name, String value) {
        return null;
    }

    public void removeXHtmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areXHtmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        XHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.xhtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public String getTail() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getContents() {
        String contents = "";
        XHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.xhtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contents = contents + element.getContents();
            ++i;
        }
        return contents;
    }

    public void setContents(String contents) {
    }

    public void setContentsWithTag(String contents) {
    }

    public void setText(String text) throws XHtmlTextCannotBeSetException {
        throw new XHtmlTextCannotBeSetException();
    }

    public String getText() throws XHtmlTextNotSetException {
        throw new XHtmlTextNotSetException();
    }

    public void resetText() throws XHtmlTextCannotBeResetException {
        throw new XHtmlTextCannotBeResetException();
    }

    public void setXHtmlParentElement(XHtmlElement xhtmlParentElement) {
    }

    public XHtmlElement getXHtmlParentElement() {
        return null;
    }

    public XHtmlElement cloneXHtmlElement() throws XHtmlElementCloneFailedException {
        XHtmlElement cXHtmlElement = null;
        try {
            cXHtmlElement = (XHtmlElement)this.getClass().newInstance();
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                XHtmlElement childXHtmlElement = this.xhtmlElementAt(i);
                XHtmlElement cChildXHtmlElement = childXHtmlElement.cloneXHtmlElement();
                cXHtmlElement.addXHtmlElement(cChildXHtmlElement);
                ++i;
            }
        }
        catch (XHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new XHtmlElementCloneFailedException(ex.getMessage());
        }
        return cXHtmlElement;
    }
}

