/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.wml;

import com.aligo.wml.WmlBaseElement;
import com.aligo.wml.exceptions.WmlAttributeCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementIndexOutOfBoundsException;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.exceptions.WmlTextCannotBeSetException;
import com.aligo.wml.exceptions.WmlTextNotSetException;
import com.aligo.wml.interfaces.WmlContainerInterface;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Hashtable;

public class WmlContainer
extends WmlBaseElement
implements WmlContainerInterface {
    public static final String WML_TAG = "";
    public static final String HREF = "href";
    public static final String TITLE = "title";
    public static final String XML_LANG = "xml:lang";
    public static final String ID = "id";
    public static final String CLASS = "class";
    public static final String TEXT = "text";
    private static String SName = "WmlContainer";
    private static Hashtable OChildrenRules = new Hashtable();
    private static Hashtable OAttributeRules = new Hashtable();
    private static String[] ORequiredAttributes = new String[0];

    public String getName() {
        return SName;
    }

    public Hashtable getChildrenRules() {
        return OChildrenRules;
    }

    public Hashtable getAttributeRules() {
        return OAttributeRules;
    }

    public String[] getRequiredAttributes() {
        return ORequiredAttributes;
    }

    public String getStartTag() {
        return WML_TAG;
    }

    public boolean isAddValid() {
        boolean canAdd;
        block14: {
            canAdd = true;
            WmlElement wmlParentElement = this.getWmlParentElement();
            if (wmlParentElement != null) {
                try {
                    WmlElement cWmlElement;
                    int addIndex = wmlParentElement.wmlElementIndex(this);
                    if (wmlParentElement instanceof WmlContainerInterface) {
                        canAdd = ((WmlContainerInterface)((Object)wmlParentElement)).isAddValid();
                        break block14;
                    }
                    int cindex = 0;
                    try {
                        int numberElements = this.elements.getNumberElements();
                        cindex = 0;
                        while (cindex < numberElements) {
                            cWmlElement = this.elements.wmlElementAt(cindex);
                            if (addIndex != -1) {
                                wmlParentElement.addWmlElementAt(cWmlElement, addIndex + cindex);
                            } else {
                                wmlParentElement.addWmlElement(cWmlElement);
                            }
                            ++cindex;
                        }
                    }
                    catch (WmlElementIndexOutOfBoundsException we) {
                    }
                    catch (WmlElementCannotBeAddedException we) {
                        canAdd = false;
                    }
                    int i = 0;
                    while (i < cindex) {
                        try {
                            cWmlElement = this.elements.wmlElementAt(i);
                            wmlParentElement.removeWmlElement(cWmlElement);
                            cWmlElement.setWmlParentElement(this);
                        }
                        catch (WmlElementIndexOutOfBoundsException we) {
                        }
                        catch (WmlElementNotFoundException je) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (WmlElementNotFoundException je) {
                    je.printStackTrace();
                }
            }
        }
        return canAdd;
    }

    public void addWmlAttribute(String name, String value) throws WmlAttributeCannotBeAddedException {
        if (!name.equals(TEXT)) {
            throw new WmlAttributeCannotBeAddedException();
        }
        this.sText = value;
        this.iTextLen = -1;
    }

    public String getText() throws WmlTextNotSetException {
        if (this.sText != null) {
            return this.sText;
        }
        return super.getText();
    }

    public int getTextLength() throws WmlTextNotSetException {
        String text;
        if (this.iTextLen == -1 && (text = this.getText()) != null) {
            this.iTextLen = text.getBytes().length;
        }
        return this.iTextLen;
    }

    public int getWmlAttributeLength(String name) {
        int length = -1;
        if (name.equals(TEXT)) {
            try {
                length = this.getTextLength();
            }
            catch (WmlTextNotSetException wmlTextNotSetException) {
                // empty catch block
            }
        }
        return length;
    }

    public void setText(String text) throws WmlTextCannotBeSetException {
        try {
            this.addWmlAttribute(TEXT, text);
        }
        catch (WmlAttributeCannotBeAddedException ex) {
            throw new WmlTextCannotBeSetException();
        }
    }
}

