/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util.vxml;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextUtils {
    public static final String ESCAPESTRING = "\\";
    private static Hashtable textConversionTable = new Hashtable();
    private static Hashtable attrConversionTable = new Hashtable();

    public static int prepareOutput(String sText, int columns, Vector strContainer) throws NullPointerException {
        int tokenLength = 0;
        int numberLines = 0;
        String lastString = null;
        int lastIndex = 0;
        if (sText != null) {
            StringTokenizer st = new StringTokenizer(sText, "\n");
            while (st.hasMoreTokens()) {
                int tokenLines;
                String sToken = st.nextToken();
                if (sToken.equals("")) {
                    tokenLength = 0;
                    tokenLines = 0;
                } else {
                    tokenLength = sToken.length();
                    tokenLines = tokenLength % columns == 0 ? tokenLength / columns : tokenLength / columns + 1;
                }
                int endIndex = 0;
                tokenLines = 0;
                char cSpace = " ".charAt(0);
                if (!sToken.equals("")) {
                    boolean done = false;
                    while (!done) {
                        int beginIndex = endIndex;
                        if ((endIndex = beginIndex + columns) > tokenLength) {
                            endIndex = tokenLength;
                            done = true;
                        }
                        String strElement = sToken.substring(beginIndex, endIndex);
                        if (endIndex > 0 && endIndex < tokenLength && (sToken.charAt(endIndex - 1) != cSpace || sToken.charAt(endIndex) != cSpace)) {
                            int strElementSize = strElement.length();
                            boolean spaceFound = false;
                            int j = --strElementSize;
                            while (j >= 0 && !spaceFound) {
                                if (strElement.charAt(j) == cSpace) {
                                    strElement = strElement.substring(0, j + 1);
                                    endIndex = beginIndex + j + 1;
                                    spaceFound = true;
                                }
                                --j;
                            }
                        }
                        ++tokenLines;
                        strContainer.addElement(TextUtils.transformText(strElement));
                    }
                }
                numberLines += tokenLines;
                if (!st.hasMoreTokens() || (lastIndex = strContainer.size() - 1) < 0) continue;
                lastString = (String)strContainer.elementAt(lastIndex);
                strContainer.set(lastIndex, lastString);
            }
        }
        return numberLines;
    }

    public static String transformText(String inputStr) {
        StringBuffer outputStr = new StringBuffer();
        String prevCharString = "";
        int length = inputStr.length();
        int i = 0;
        while (i < length) {
            String sReplacement;
            String charString = inputStr.substring(i, i + 1);
            if (charString.equals(ESCAPESTRING)) {
                sReplacement = "";
            } else if (!prevCharString.equals(ESCAPESTRING)) {
                sReplacement = (String)textConversionTable.get(charString);
                if (sReplacement == null) {
                    sReplacement = charString;
                }
            } else {
                sReplacement = charString;
            }
            outputStr.append(sReplacement);
            prevCharString = charString;
            ++i;
        }
        return outputStr.toString();
    }

    public static String transformAttr(String wmlName, String inputStr) {
        StringBuffer outputStr = new StringBuffer();
        String prevCharString = "";
        int length = inputStr.length();
        Hashtable wmlNameTable = (Hashtable)attrConversionTable.get(wmlName);
        if (wmlNameTable != null) {
            int i = 0;
            while (i < length) {
                String sReplacement;
                String charString = inputStr.substring(i, i + 1);
                if (charString.equals(ESCAPESTRING)) {
                    sReplacement = "";
                } else if (!prevCharString.equals(ESCAPESTRING)) {
                    sReplacement = (String)wmlNameTable.get(charString);
                    if (sReplacement == null) {
                        sReplacement = charString;
                    }
                } else {
                    sReplacement = charString;
                }
                outputStr.append(sReplacement);
                prevCharString = charString;
                ++i;
            }
            return outputStr.toString();
        }
        return inputStr;
    }

    public static String getText(int start, int end, Vector strContainer) {
        String outputText = "";
        int i = start;
        while (i < end) {
            outputText = outputText + (String)strContainer.elementAt(i);
            ++i;
        }
        return outputText;
    }

    static {
        textConversionTable.put("<", "&lt;");
        textConversionTable.put(">", "&gt;");
        textConversionTable.put("&", "&amp;");
        textConversionTable.put("$", "$$");
        textConversionTable.put("\"", "&quot;");
        Hashtable<String, String> urlConversionTable = new Hashtable<String, String>();
        urlConversionTable.put(" ", "+");
        urlConversionTable.put("<", "&lt;");
        urlConversionTable.put(">", "&gt;");
        urlConversionTable.put("\"", "&quot;");
        urlConversionTable.put("&", "&amp;");
        attrConversionTable.put("url", urlConversionTable);
        attrConversionTable.put("href", urlConversionTable);
        attrConversionTable.put("next", urlConversionTable);
        attrConversionTable.put("onpick", urlConversionTable);
        attrConversionTable.put("value", textConversionTable);
    }
}

