/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

public class URLUtils {
    public static final String QUERY_DELIMITER = "?";
    public static final String QUERY_PARAM_DELIMITER = "&";
    public static final String QUERY_EMPTY = "";

    public static String composeURL(String baseUrl, String query) {
        StringBuffer url = new StringBuffer(baseUrl);
        if (query != null && !query.equals(QUERY_EMPTY)) {
            if (baseUrl.indexOf(QUERY_DELIMITER) != -1) {
                url.append(QUERY_PARAM_DELIMITER);
            } else {
                url.append(QUERY_DELIMITER);
            }
            url.append(query);
        }
        return url.toString();
    }

    public static StringBuffer composeAnchorURL(String url, String anchor) {
        return URLUtils.composeAnchorURL(url, anchor, true);
    }

    public static StringBuffer composeAnchorURL(String url, String anchor, boolean append) {
        int poss;
        int aindex = url.indexOf("#");
        int sindex = -1;
        int qindex = -1;
        if (!append || aindex != -1) {
            sindex = url.indexOf(";");
            if (sindex <= aindex) {
                sindex = -1;
            }
            if ((qindex = url.indexOf(QUERY_DELIMITER)) <= aindex) {
                qindex = -1;
            }
        }
        int pose = poss = url.length();
        int stindex = -1;
        int enindex = -1;
        if (aindex != -1) {
            stindex = aindex;
        }
        if (sindex != -1) {
            if (qindex != -1) {
                if (sindex < qindex) {
                    enindex = sindex;
                }
            } else {
                enindex = sindex;
            }
        }
        if (enindex == -1 && qindex != -1) {
            enindex = qindex;
        }
        if (enindex != -1) {
            poss = pose = enindex;
        }
        if (stindex != -1) {
            poss = stindex;
        }
        StringBuffer rurl = new StringBuffer(url.substring(0, poss));
        rurl.append("#");
        rurl.append(anchor);
        rurl.append(url.substring(pose));
        return rurl;
    }
}

