/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.exceptions.AligoAccessException;
import com.aligo.util.Cache;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.FormRedirector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CacheReader {
    private static final String PARAM_VALUE_SEPARATOR = "=";
    private static final String UNKNOWN_FORMNUM = "UNKNOWN";

    public static String getCacheContent(Cache cache, String index) throws AligoAccessException {
        return cache.getPageCache().getIndexedPage(index);
    }

    public static String getRedirectURL(Cache cache, String index, HttpServletRequest request) {
        String redirectURL = null;
        FormRedirectionInfo frdi = cache.getFormRedirectionInfo();
        FormRedirector frd = null;
        boolean done = false;
        Enumeration frds = frdi.formRedirectors();
        while (frds.hasMoreElements() && !done) {
            String dIndex;
            frd = (FormRedirector)frds.nextElement();
            String dynamicUrl = frd.getDynamicURL();
            if (dynamicUrl == null || !index.equals(dIndex = CacheReader.getIndex(cache, dynamicUrl))) continue;
            redirectURL = CacheReader.getFormRedirectURL(frd, cache, request);
            done = true;
        }
        return redirectURL;
    }

    private static boolean isPresent(String value, String[] reqValues) {
        boolean present = false;
        int length = reqValues.length;
        int i = 0;
        while (i < length && !present) {
            if (value.equals(reqValues[i])) {
                present = true;
            }
            ++i;
        }
        return present;
    }

    private static String[] getParameterValues(HttpServletRequest request, String name) {
        String value;
        String[] values = request.getParameterValues(name);
        if (values != null && values.length == 1 && (value = values[0]).indexOf(";") != -1) {
            StringTokenizer st = new StringTokenizer(value, ";");
            int length = st.countTokens();
            values = new String[length];
            int i = 0;
            while (st.hasMoreTokens() && i < length) {
                values[i] = st.nextToken();
                ++i;
            }
        }
        return values;
    }

    private static String getFormRedirectURL(FormRedirector formRedirector, Cache cache, HttpServletRequest request) {
        String nextURL = null;
        Enumeration modifiers = formRedirector.modifiers();
        boolean canService = false;
        while (modifiers.hasMoreElements() && !canService) {
            String[] reqValues;
            String value;
            String name;
            String modifier = (String)modifiers.nextElement();
            StringTokenizer st = new StringTokenizer(modifier, PARAM_VALUE_SEPARATOR);
            if (!st.hasMoreTokens() || (name = st.nextToken()) == null || !st.hasMoreTokens() || (value = st.nextToken()) == null || (reqValues = CacheReader.getParameterValues(request, name)) == null) continue;
            CacheReader.setMultiValParam(name, cache, request);
            if (!CacheReader.isPresent(value, reqValues)) continue;
            nextURL = formRedirector.getModifiedURL(modifier);
            CacheReader.removeCachedParameter(name, value, cache, request);
            canService = true;
        }
        if (!canService) {
            nextURL = formRedirector.getOriginalURL();
        }
        return nextURL;
    }

    public static String getIndex(Cache cache, HttpServletRequest request) {
        return request.getParameter(cache.getIndexIdentifier());
    }

    public static String getIndex(Cache cache, String url) {
        String indexIdentifier = cache.getIndexIdentifier();
        String value = CacheReader.getValue(url, indexIdentifier);
        return value;
    }

    private static String getValue(String url, String param) {
        String value = null;
        if (param != null) {
            value = "";
            int index = url.indexOf(param);
            if (index != -1) {
                int length = url.length();
                int paramLength = param.length();
                int valueIndex = index + paramLength + 1;
                if (valueIndex < length) {
                    int endIndex = length;
                    int ampIndex = url.indexOf(38, valueIndex);
                    if (ampIndex != -1) {
                        endIndex = ampIndex;
                    }
                    value = url.substring(valueIndex, endIndex);
                }
            }
        }
        return value;
    }

    public static String getFormNumber(HttpServletRequest request) {
        String formNumber = request.getParameter("agf");
        if (formNumber == null) {
            formNumber = UNKNOWN_FORMNUM;
        }
        return formNumber;
    }

    public static Hashtable getParams(Cache cache, HttpServletRequest request) {
        String formNumber = CacheReader.getFormNumber(request);
        return cache.getParams(formNumber).getHash();
    }

    public static void storeCachedParameters(Cache cache, HttpServletRequest request) {
        String formNumber = CacheReader.getFormNumber(request);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String param = e.nextElement().toString();
            String[] values = CacheReader.getParameterValues(request, param);
            cache.storeParam(formNumber, param, values);
        }
    }

    private static void setMultiValParam(String param, Cache cache, HttpServletRequest request) {
        String formNumber = CacheReader.getFormNumber(request);
        cache.setMultiValParam(param);
    }

    public static void removeCachedParameter(String param, String value, Cache cache, HttpServletRequest request) {
        String formNumber = CacheReader.getFormNumber(request);
        cache.removeParam(formNumber, param, value);
    }

    public static void removeCachedParameters(Cache cache, HttpServletRequest request) {
        String formNumber = CacheReader.getFormNumber(request);
        cache.removeParams(formNumber);
    }
}

