/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.engine.ContentHeaders;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.PageCache;
import com.aligo.util.Params;
import java.util.HashMap;

public class Cache {
    private static final String CACHE_IDENTIFIER = "agt";
    private static final String CACHE_IDENTIFIER_VALUE = "uc";
    private static final String DYNAMIC_IDENTIFIER_VALUE = "dh";
    private static final String INDEX_IDENTIFIER = "agid";
    public static final String FORMNUM_IDENTIFIER = "agf";
    private static final String QUERY_SEPARATOR = "?";
    private static final String PARAM_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private String sCacheIdentifier = "agt";
    private String sIndexIdentifier = "agid";
    private String sBaseUrl = "";
    private PageCache oPageCache = new PageCache();
    private FormRedirectionInfo oFormRedirectionInfo = new FormRedirectionInfo();
    private String sCacheUrl = null;
    private String sDynamicUrl = null;
    private HashMap oFormParams = new HashMap();
    private ContentHeaders headers;
    private HashMap multiValParams = new HashMap();
    private HashMap oIdentifierNames = new HashMap();
    private String contentUrl;

    public void setRequestUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getRequestUrl() {
        return this.contentUrl;
    }

    public Cache() {
        this.oIdentifierNames.put(CACHE_IDENTIFIER, CACHE_IDENTIFIER);
        this.oIdentifierNames.put(this.sIndexIdentifier, this.sIndexIdentifier);
        this.oIdentifierNames.put(FORMNUM_IDENTIFIER, FORMNUM_IDENTIFIER);
    }

    public Cache(String requestUrl) {
        this();
        this.contentUrl = requestUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.sBaseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.sBaseUrl;
    }

    public String addQuery(String url, String query) {
        int length = url.length();
        if (length > 0) {
            int nlength;
            int lastIndex = length - 1;
            boolean cont = true;
            if (url.charAt(lastIndex) == '/' && (nlength = (url = url.substring(0, lastIndex)).length()) == 0) {
                cont = false;
            }
            if (cont) {
                url = url.indexOf(QUERY_SEPARATOR) == -1 ? url + QUERY_SEPARATOR + query : url + PARAM_SEPARATOR + query;
            }
        }
        return url;
    }

    private String getUrl(String type) {
        String strUrl = this.sBaseUrl;
        strUrl = this.addType(strUrl, type);
        strUrl = this.addIdentifier(strUrl);
        return strUrl;
    }

    private String addType(String url, String type) {
        return this.addQuery(url, type);
    }

    private String addIdentifier(String url) {
        return this.addQuery(url, this.sIndexIdentifier + NAME_VALUE_SEPARATOR);
    }

    public void setBaseCacheUrl(String baseCacheUrl) {
        this.sCacheUrl = this.addIdentifier(baseCacheUrl);
    }

    public void setBaseDynamicUrl(String baseDynamicUrl) {
        this.sDynamicUrl = this.addIdentifier(baseDynamicUrl);
    }

    public void setCacheUrl(String cacheUrl) {
        this.sCacheUrl = cacheUrl;
    }

    public String getCacheUrl() {
        String url = this.sCacheUrl;
        if (url == null) {
            url = this.getUrl(this.getCacheQuery());
        }
        return url;
    }

    public void setDynamicUrl(String dynamicUrl) {
        this.sDynamicUrl = dynamicUrl;
    }

    public String getDynamicUrl() {
        String url = this.sDynamicUrl;
        if (url == null) {
            url = this.getUrl(this.getDynamicQuery());
        }
        return url;
    }

    public void setPageCache(PageCache pageCache) {
        this.oPageCache = pageCache;
    }

    public PageCache getPageCache() {
        return this.oPageCache;
    }

    public void setFormRedirectionInfo(FormRedirectionInfo formRedirectionInfo) {
        this.oFormRedirectionInfo = formRedirectionInfo;
    }

    public FormRedirectionInfo getFormRedirectionInfo() {
        return this.oFormRedirectionInfo;
    }

    public String getCacheIdentifier() {
        return this.sCacheIdentifier;
    }

    public String getCacheIdentifierValue() {
        return CACHE_IDENTIFIER_VALUE;
    }

    public String getDynamicIdentifierValue() {
        return DYNAMIC_IDENTIFIER_VALUE;
    }

    public String getCacheQuery() {
        return this.sCacheIdentifier + NAME_VALUE_SEPARATOR + CACHE_IDENTIFIER_VALUE;
    }

    public String getDynamicQuery() {
        return this.sCacheIdentifier + NAME_VALUE_SEPARATOR + DYNAMIC_IDENTIFIER_VALUE;
    }

    public String getIndexIdentifier() {
        return this.sIndexIdentifier;
    }

    public void setCacheIdentifier(String cacheIdentifier) {
        this.sCacheIdentifier = cacheIdentifier;
    }

    public void setIndexIdentifier(String indexIdentifier) {
        this.sIndexIdentifier = indexIdentifier;
    }

    public void storeParam(String formNum, String param, String[] values) {
        boolean append = false;
        if (this.multiValParams.get(param) != null) {
            append = true;
        }
        this.storeParam(formNum, param, values, append);
    }

    private boolean isIdentifier(String param) {
        boolean identifier = false;
        if (this.oIdentifierNames.get(param) != null) {
            identifier = true;
        }
        return identifier;
    }

    public void storeParam(String formNum, String param, String[] values, boolean append) {
        if (!this.isIdentifier(param)) {
            Params params = this.getParams(formNum);
            params.add(param, values, append);
        }
    }

    public Params getParams(String formNum) {
        Params params = (Params)this.oFormParams.get(formNum);
        if (params == null) {
            params = new Params();
            this.oFormParams.put(formNum, params);
        }
        return params;
    }

    public void removeParam(String formNum, String param, String value) {
        Params params = this.getParams(formNum);
        params.remove(param, value);
    }

    public void removeParams(String formNum) {
        Params params = (Params)this.oFormParams.get(formNum);
        if (params != null) {
            this.oFormParams.remove(formNum);
        }
    }

    public void setHeaders(ContentHeaders headers) {
        this.headers = headers;
    }

    public ContentHeaders getHeaders() {
        return this.headers;
    }

    public void setMultiValParam(String param) {
        this.multiValParams.put(param, param);
    }

    public void resetMultiValParam(String param) {
        this.multiValParams.remove(param);
    }

    public void addParamIdentifier(String param) {
        this.oIdentifierNames.put(param, param);
    }
}

