/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ByteTokenizer
implements Enumeration {
    private int currentPosition;
    private int newPosition;
    private int maxPosition;
    private byte[] bytes;
    private byte delimiter;
    private boolean returnDelimiter;
    private boolean delimsChanged;

    public ByteTokenizer(byte[] bytes, byte delimiter, boolean returnDelimiter) {
        this.bytes = bytes;
        this.delimiter = delimiter;
        this.currentPosition = 0;
        this.newPosition = -1;
        this.delimsChanged = false;
        this.maxPosition = bytes.length;
        this.returnDelimiter = returnDelimiter;
    }

    public ByteTokenizer(byte[] bytes, byte delimiter) {
        this(bytes, delimiter, false);
    }

    private int skipDelimiters(int startPos) {
        int position = startPos;
        while (!this.returnDelimiter && position < this.maxPosition) {
            if (this.bytes[position] != this.delimiter) break;
            ++position;
        }
        return position;
    }

    private int scanToken(int startPos) {
        int position = startPos;
        while (position < this.maxPosition) {
            if (this.bytes[position] == this.delimiter) break;
            ++position;
        }
        if (this.returnDelimiter && startPos == position && this.bytes[position] == this.delimiter) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public byte[] nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        int retLen = this.currentPosition - start;
        byte[] retVal = new byte[retLen];
        System.arraycopy(this.bytes, start, retVal, 0, retLen);
        return retVal;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            if ((currpos = this.skipDelimiters(currpos)) >= this.maxPosition) break;
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

