/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.xml;

import com.aligo.tools.interfaces.DefaultDOMElementInterface;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultDOMElement
extends DefaultDOMXMLable
implements DefaultDOMElementInterface {
    private String tagName;
    private String pcData;
    private Collection childList;
    private TreeMap attributeMap;

    public DefaultDOMElement(Element element) {
        super(element);
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setPCData(String pcData) {
        this.pcData = pcData;
    }

    public String getPCData() {
        return this.pcData;
    }

    public void setChildren(Collection childList) {
        this.childList = childList;
    }

    public Collection getChildren() {
        return this.childList;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public void setAttributeMap(TreeMap map) {
        this.attributeMap = map;
    }

    public TreeMap getAttributeMap() {
        return this.attributeMap;
    }

    public void addChild(DefaultDOMElementInterface child) {
        this.getChildren().add(child);
    }

    public void fromXMLElement(Element element) {
        this.tagName = null;
        this.pcData = null;
        this.attributeMap = new TreeMap();
        this.childList = new ArrayList();
        if (element != null) {
            NamedNodeMap map;
            this.tagName = element.getTagName();
            this.pcData = XMLUtilities.getPCData(element);
            NodeList list = element.getChildNodes();
            if (list != null && list.getLength() > 0) {
                int i = 0;
                while (i < list.getLength()) {
                    Node next = list.item(i);
                    if (!(next instanceof Text) && next instanceof Element) {
                        this.addChild(new DefaultDOMElement((Element)next));
                    }
                    ++i;
                }
            }
            if ((map = element.getAttributes()) != null && map.getLength() > 0) {
                int j = 0;
                while (j < map.getLength()) {
                    Node next = map.item(j);
                    if (next instanceof Attr) {
                        this.attributeMap.put(((Attr)next).getName(), ((Attr)next).getValue());
                    }
                    ++j;
                }
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(this.getTagName());
        element.appendChild(document.createTextNode(this.getPCData()));
        Iterator keys = this.attributeMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            element.setAttribute(key, (String)this.attributeMap.get(key));
        }
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            DefaultDOMElementInterface child = (DefaultDOMElementInterface)children.next();
            Element childElement = child.toXMLElement(document);
            if (childElement == null) continue;
            element.appendChild(childElement);
        }
        return element;
    }
}

