/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class ReflectionUtils {
    public static Collection getReferencedClasses(Class className, boolean declaredOnly) {
        TreeSet<String> retVal = new TreeSet<String>();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            Class<?> retType = theMethods[i].getReturnType();
            if (retType.isArray()) {
                retVal.add(retType.getComponentType().getName());
            } else {
                retVal.add(theMethods[i].getReturnType().getName());
            }
            Class<?>[] params = theMethods[i].getParameterTypes();
            int j = 0;
            while (j < params.length) {
                if (params[j].isArray()) {
                    retVal.add(params[j].getComponentType().getName());
                } else {
                    retVal.add(params[j].getName());
                }
                ++j;
            }
            ++i;
        }
        return retVal;
    }

    public static Collection getReferencedClassesAsClasses(Class className, boolean declaredOnly) {
        TreeSet<String> classNames = new TreeSet<String>();
        ArrayList retVal = new ArrayList();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            if (!classNames.contains(theMethods[i].getReturnType().getName())) {
                classNames.add(theMethods[i].getReturnType().getName());
                retVal.add(theMethods[i].getReturnType());
            }
            Class<?>[] params = theMethods[i].getParameterTypes();
            int j = 0;
            while (j < params.length) {
                if (!classNames.contains(params[j].getName())) {
                    classNames.add(params[j].getName());
                    retVal.add(params[j]);
                }
                ++j;
            }
            ++i;
        }
        return retVal;
    }
}

