/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.interfaces.DOMXMLable;
import com.aligo.tools.util.XMLProperty;
import com.aligo.tools.util.XMLPropertyType;
import com.aligo.tools.xml.XMLUtilities;
import java.lang.reflect.Constructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstanceXMLProperty
extends XMLProperty {
    public static final String INSTANCE_PROPERTY_TAG = "InstanceXMLProperty";
    public static final String CLASS_NAME_ATTR = "value";
    public static final String CLASS_NAME_TAG = "Class";
    public static final String VALUE_TAG = "Value";
    private DOMXMLable value;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public InstanceXMLProperty(Element element) {
        super(element);
    }

    public InstanceXMLProperty(String name, DOMXMLable value) {
        super(name);
        this.value = value;
    }

    public Object getPropertyValue() {
        return this.value;
    }

    public XMLPropertyType getPropertyType() {
        return XMLPropertyType.XML_INSTANCE;
    }

    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        if (element != null) {
            if (!INSTANCE_PROPERTY_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, INSTANCE_PROPERTY_TAG);
            }
            if (element != null && INSTANCE_PROPERTY_TAG.equals(element.getTagName())) {
                String className = element.getAttribute(CLASS_NAME_ATTR);
                if (!ToolsUtilities.isNullOrEmpty(className)) {
                    NodeList list = element.getChildNodes();
                    if (list != null && list.getLength() > 0) {
                        int i = 0;
                        while (i < list.getLength()) {
                            Node next = list.item(i);
                            if (next instanceof Element) {
                                Element valueElement = (Element)next;
                                if (valueElement != null) {
                                    this.value = this.createPropertyValue(valueElement, className);
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                } else {
                    className = XMLUtilities.getPCData(element, CLASS_NAME_TAG);
                    Element valueElement = XMLUtilities.getFirstMatch(element, VALUE_TAG);
                    if (className != null && valueElement != null && (valueElement = XMLUtilities.getFirstElement(valueElement)) != null) {
                        this.value = this.createPropertyValue(valueElement, className);
                    }
                }
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = super.toXMLElement(document);
        if (this.value != null) {
            XMLUtilities.createPCData(document, element, CLASS_NAME_TAG, this.value.getClass().getName());
            Element valueElement = document.createElement(VALUE_TAG);
            element.appendChild(valueElement);
            valueElement.appendChild(this.value.toXMLElement(document));
        }
        return element;
    }

    private DOMXMLable createPropertyValue(Element element, String className) {
        DOMXMLable value = null;
        try {
            Class<?> classObject = Class.forName(className);
            Constructor<?> constructor = classObject.getConstructor(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = InstanceXMLProperty.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            Object temp = constructor.newInstance(element);
            if (temp instanceof DOMXMLable) {
                value = (DOMXMLable)temp;
            }
        }
        catch (Exception e) {
            System.err.println("Error tring to create class of name : " + className);
            e.printStackTrace();
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

