/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.interfaces.ResourceLoader;
import com.aligo.tools.xml.DocumentFactory;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

public class DefaultResourceLoader
implements ResourceLoader {
    private static ResourceLoader instance;

    public static final ResourceLoader getInstance() {
        if (instance == null) {
            instance = new DefaultResourceLoader();
        }
        return instance;
    }

    private DefaultResourceLoader() {
    }

    public ResourceBundle getBundle(String location) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bundle;
    }

    public Properties getProperties(String location) {
        Properties properties = new Properties();
        try {
            InputStream is = ClassLoader.getSystemResourceAsStream(location);
            properties.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public Document getDocument(String location) {
        Document document = null;
        try {
            document = DocumentFactory.openDocumentFromStreamAsDOM(this.getStream(location));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public InputStream getStream(String location) {
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is;
    }
}

