/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

public class AligoLicense {
    static final String REC_SEP = "~";
    static final String MAX_REQ_SEP = "^";
    static final int DAYS = 60;
    static final int EXP_INDEX = 0;
    static long LICENSE_SPAN = 889032704L;
    private static long TIMESTAMP_TO_COMPARE_WITH = 260496000000L;
    private static long MAX_TIME_OF_LICENSE = 1049414400000L;
    private static final String DBC_PATH = "/Aligo/Messages/util/AligoLicense/";

    public static int daysLeft(String licenseFile) {
        int timeLeft = -1;
        String tStamp = "";
        String encryptedText = "";
        String license = "";
        try {
            FileInputStream fin = new FileInputStream(licenseFile);
            byte[] b = new byte[fin.available()];
            fin.read(b);
            tStamp = tStamp + new String(b);
            int i = tStamp.indexOf(REC_SEP);
            int j = tStamp.indexOf(MAX_REQ_SEP);
            if (i != -1 && j == -1) {
                encryptedText = tStamp.substring(0, i);
                license = tStamp.substring(i + 1);
            } else if (i == -1 && j == -1) {
                encryptedText = tStamp;
            } else if (i != -1 && j != -1) {
                encryptedText = tStamp.substring(0, i);
                license = tStamp.substring(i + 1, j);
            } else {
                encryptedText = tStamp;
            }
            encryptedText = encryptedText.trim();
            license = license.trim();
            String d = AligoLicense.rsadecrypt(encryptedText);
            long timeStamp = new Long(d) / 1000L / 60L / 60L / 24L;
            long now = new Date().getTime() / 1000L / 60L / 60L / 24L;
            if (license.length() == 0) {
                throw new IllegalStateException("Invalid license key. Please contact Aligo");
            }
            if (now - timeStamp > 0L || timeStamp >= MAX_TIME_OF_LICENSE / 1000L / 60L / 60L / 24L) {
                Long ts = new Long(d);
                Date dt = new Date(ts);
            } else {
                Long ts = new Long(d);
                Date dt = new Date(ts);
            }
            timeLeft = (int)(timeStamp - now);
        }
        catch (FileNotFoundException fNot) {
            throw new IllegalStateException("Problems trying to find license file " + fNot.getMessage());
        }
        catch (IOException ioBlues) {
            throw new IllegalStateException("Problems trying to find license file " + ioBlues.getMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException("Problems trying to decript license file " + e.getMessage());
        }
        return timeLeft;
    }

    public static boolean hasLicenseBeenGranted(String licenseFile) {
        String tStamp = "";
        String encryptedText = "";
        String license = "";
        String maxRequestKey = "";
        boolean LicGranted = false;
        try {
            FileInputStream fin = new FileInputStream(licenseFile);
            byte[] b = new byte[fin.available()];
            fin.read(b);
            tStamp = tStamp + new String(b);
            int i = tStamp.indexOf(REC_SEP);
            int j = tStamp.indexOf(MAX_REQ_SEP);
            if (j == -1) {
                return false;
            }
            if (i == -1) {
                encryptedText = tStamp.substring(0, j);
                maxRequestKey = tStamp.substring(j + 1);
            } else {
                encryptedText = tStamp.substring(0, i);
                maxRequestKey = tStamp.substring(j + 1);
            }
            encryptedText = encryptedText.trim();
            maxRequestKey = maxRequestKey.trim();
            String d = AligoLicense.rsadecrypt(maxRequestKey);
            long maxReqTimeStamp = new Long(d) / 1000L / 60L / 60L / 24L;
            String e = AligoLicense.rsadecrypt(encryptedText);
            long expiryTimeStamp = new Long(e) / 1000L / 60L / 60L / 24L;
            long diff = maxReqTimeStamp - expiryTimeStamp - TIMESTAMP_TO_COMPARE_WITH / 1000L / 60L / 60L / 24L;
            int iDiff = (int)diff;
            LicGranted = AligoLicense.isUpgraded(iDiff);
            return LicGranted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String rsadecrypt(String encryptedtext) {
        BigInteger n = new BigInteger("758658614247350282363941");
        BigInteger d = new BigInteger("492948682050637868139109");
        BigInteger encryptedint = new BigInteger(encryptedtext);
        BigInteger decryptedTime = encryptedint.modPow(d, n);
        return decryptedTime + "";
    }

    private static boolean isUpgraded(int bCode) {
        return bCode % 2 == 1;
    }
}

