/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile;

import com.aligo.parsing.XMLException;
import com.aligo.parsing.XMLHDOM;
import com.aligo.parsing.XMLParser;
import com.aligo.profile.UAProfileBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class UAProfileCollection {
    private Map uaprofiles_;
    private boolean subProfilesExist_ = false;
    public static final String XML_TAG = "profilecollection";
    public static final String BASE_PROFILES_FLAG_TAG = "baseprofilesflag";
    private static final String PROFILE_COLLECTION_PATH = "/profilecollection/";
    public static final String BASE_PROFILES_FLAG_PATH = "/profilecollection/baseprofilesflag";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String END_LT = "</";
    private static final String LEFT_BRACE = "[";
    private static final String RIGHT_BRACE = "]";

    public boolean containsSubProfiles() {
        return this.subProfilesExist_;
    }

    public void setSubProfilesExist(boolean flag) {
        this.subProfilesExist_ = flag;
    }

    public void setUAProfiles(Map uaprofiles) {
        this.uaprofiles_ = uaprofiles;
    }

    public UAProfileBase getUAProfile(String profileKey) {
        UAProfileBase profile = (UAProfileBase)this.uaprofiles_.get(profileKey);
        return profile;
    }

    public Iterator getUAProfiles() {
        if (this.uaprofiles_ != null) {
            return this.uaprofiles_.values().iterator();
        }
        return null;
    }

    public static boolean isProtocolProfile(UAProfileBase profile) {
        return !(profile.getRecipientAppAgent() != null && !profile.getRecipientAppAgent().equals("") || !profile.getAmlID().equals(profile.getXmlID()) || profile.getBaseProfileID() != null && !profile.getBaseProfileID().equals(""));
    }

    public static boolean isStyleProfile(UAProfileBase profile) {
        return (profile.getRecipientAppAgent() == null || profile.getRecipientAppAgent().equals("")) && !profile.getAmlID().equals(profile.getXmlID());
    }

    public static boolean isDeviceProfile(UAProfileBase profile) {
        return profile.getRecipientAppAgent() != null && !profile.getRecipientAppAgent().equals("");
    }

    public Iterator getProtocolProfiles() {
        HashMap<UAProfileBase, UAProfileBase> results = new HashMap<UAProfileBase, UAProfileBase>();
        if (this.uaprofiles_ != null) {
            Iterator profiles = this.uaprofiles_.values().iterator();
            while (profiles.hasNext()) {
                UAProfileBase profile = (UAProfileBase)profiles.next();
                if (profile == null || !UAProfileCollection.isProtocolProfile(profile)) continue;
                results.put(profile, profile);
            }
        }
        return results.keySet().iterator();
    }

    public Iterator getStyleProfiles() {
        HashMap<UAProfileBase, UAProfileBase> results = new HashMap<UAProfileBase, UAProfileBase>();
        if (this.uaprofiles_ != null) {
            Iterator profiles = this.uaprofiles_.values().iterator();
            while (profiles.hasNext()) {
                UAProfileBase profile = (UAProfileBase)profiles.next();
                if (profile == null || !UAProfileCollection.isStyleProfile(profile)) continue;
                results.put(profile, profile);
            }
        }
        return results.keySet().iterator();
    }

    public Iterator getDeviceProfiles() {
        HashMap<UAProfileBase, UAProfileBase> results = new HashMap<UAProfileBase, UAProfileBase>();
        if (this.uaprofiles_ != null) {
            Iterator profiles = this.uaprofiles_.values().iterator();
            while (profiles.hasNext()) {
                UAProfileBase profile = (UAProfileBase)profiles.next();
                if (profile == null || !UAProfileCollection.isDeviceProfile(profile)) continue;
                results.put(profile, profile);
            }
        }
        return results.keySet().iterator();
    }

    public void fromXml(String xml) throws XMLException {
        XMLParser parser = new XMLParser();
        XMLHDOM dom = parser.parse(xml);
        this.fromXml(dom);
    }

    public String toXml() {
        StringBuffer results = new StringBuffer(LT);
        results.append(XML_TAG);
        results.append(GT);
        if (this.uaprofiles_ != null) {
            Iterator profiles = this.uaprofiles_.values().iterator();
            while (profiles.hasNext()) {
                UAProfileBase profile = (UAProfileBase)profiles.next();
                if (UAProfileCollection.isDeviceProfile(profile) && this.containsSubProfiles()) {
                    results.append(profile.toSubXml());
                    continue;
                }
                results.append(profile.toXml());
            }
        }
        results.append(END_LT);
        results.append(XML_TAG);
        results.append(GT);
        return results.toString();
    }

    private void fromXml(XMLHDOM dom) throws XMLException {
        Map<String, UAProfileBase> tempProfiles = Collections.synchronizedMap(new HashMap());
        StringBuffer key = new StringBuffer(PROFILE_COLLECTION_PATH);
        key.append("uaprofile");
        int count = dom.count(key.toString());
        StringBuffer path = new StringBuffer(key.toString());
        int i = 0;
        while (i < count) {
            path.replace(key.length(), path.length(), LEFT_BRACE);
            path.append(i);
            path.append(RIGHT_BRACE);
            String profileXml = this.getDomXml(dom, path.toString(), "uaprofile");
            if (profileXml != null && !profileXml.equals("")) {
                UAProfileBase uaProfile = new UAProfileBase();
                uaProfile.fromXml(profileXml);
                tempProfiles.put(UAProfileCollection.getProfileKey(uaProfile), uaProfile);
            }
            ++i;
        }
        if (tempProfiles.size() > 0) {
            this.setUAProfiles(tempProfiles);
        }
    }

    public static String getProfileKey(UAProfileBase profile) {
        if (UAProfileCollection.isDeviceProfile(profile)) {
            return profile.getRecipientAppAgent();
        }
        if (UAProfileCollection.isStyleProfile(profile)) {
            return profile.getAmlID();
        }
        if (UAProfileCollection.isProtocolProfile(profile)) {
            return profile.getXmlID();
        }
        return null;
    }

    private String[] getElements(XMLHDOM dom, String key) {
        int count = dom.count(key);
        Vector<String> results = new Vector<String>();
        StringBuffer path = new StringBuffer(key);
        int i = 0;
        while (i < count) {
            path.replace(key.length(), path.length(), LEFT_BRACE);
            path.append(i);
            path.append(RIGHT_BRACE);
            String pathValue = dom.resolve(path.toString());
            if (pathValue != null && !pathValue.equals("")) {
                results.addElement(pathValue);
            }
            ++i;
        }
        int size = results.size();
        if (size > 0) {
            String[] strArray = new String[results.size()];
            int j = 0;
            while (j < size) {
                strArray[j] = (String)results.elementAt(j);
                ++j;
            }
            return strArray;
        }
        return null;
    }

    private String elementsToXml(String tag, String[] elements) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            result.append(LT);
            result.append(tag);
            result.append(GT);
            result.append(elements[i]);
            result.append(END_LT);
            result.append(tag);
            result.append(GT);
            ++i;
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return "";
    }

    private String elementToXml(String tag, String element) {
        StringBuffer result = new StringBuffer();
        result.append(LT);
        result.append(tag);
        result.append(GT);
        result.append(element);
        result.append(END_LT);
        result.append(tag);
        result.append(GT);
        return result.toString();
    }

    private String getDomXml(XMLHDOM dom, String key, String tag) {
        dom.setdefault(key);
        String subtree = dom.getXMLSubTree();
        if (subtree != null && !subtree.equals("")) {
            StringBuffer result = new StringBuffer();
            result.append(LT);
            result.append(tag);
            result.append(GT);
            result.append(subtree);
            result.append(END_LT);
            result.append(tag);
            result.append(GT);
            return result.toString();
        }
        return null;
    }

    public void initBaseProfiles() {
        Iterator profiles = this.getUAProfiles();
        while (profiles.hasNext()) {
            UAProfileBase baseProfile;
            UAProfileBase profile = (UAProfileBase)profiles.next();
            String baseProfileId = profile.getBaseProfileID();
            if (baseProfileId == null || baseProfileId.equals("") || (baseProfile = this.getUAProfile(baseProfileId)) == null) continue;
            profile.setBaseProfile(baseProfile);
        }
    }
}

