/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile;

import com.aligo.parsing.XMLException;
import com.aligo.parsing.XMLHDOM;
import com.aligo.parsing.XMLParser;
import com.aligo.profile.interfaces.UAProfile;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class UAProfileBase
implements UAProfile,
Cloneable {
    public static final String DIMENSION_DELIMITER = "x";
    public static final String STRING_ARRAY_DELIMITER = ",";
    public static final String EXTERNAL = "External";
    public static final String EXTERNAL_OVERRIDE = "Override";
    public static final String INTERNAL = "Internal";
    public static final String SCREEN_SIZE_UNITS_CHAR = "char";
    public static final String SCREEN_SIZE_UNITS_PIXEL = "pixel";
    public static final String POINTING_RESOLUTION_PIXEL = "pixel";
    public static final String POINTING_RESOLUTION_CHAR = "char";
    public static final String POINTING_RESOLUTION_LINE = "line";
    private String amlID_;
    private String xmlID_;
    private Date dateCreated_;
    private Date dateLastModified_;
    private String location_;
    private Boolean allowOverride_;
    private String baseProfileID_;
    private UAProfileBase baseProfile_;
    private String[] wmlScriptVersion_;
    private String[] videoInputEncoder_;
    private Boolean framesCapable_;
    private String javaScriptVersion_;
    private String[] wmlScriptLibraries_;
    private String keyboard_;
    private String browserName_;
    private Boolean imageCapable_;
    private Boolean acceptDownloadableSoftware_;
    private Boolean voiceInputCapable_;
    private String[] audioInputEncoder_;
    private String mexeClassmark_;
    private int wapPushMsgSize_ = -1;
    private String vendor_;
    private String model_;
    private String browserVersion_;
    private String recipientAppAgent_;
    private String[] ccppAcceptLanguage_;
    private String[] downloadableBrowserApps_;
    private String[] supportedBearers_;
    private Boolean standardFontProportional_;
    private String cpu_;
    private int pduSize_ = -1;
    private String wapPushMsgPriority_;
    private Boolean preferenceForFrames_;
    private int bitsPerPixel_ = -1;
    private String currentBearerService_;
    private String[] outputCharSet_;
    private String[] ccppAcceptCharset_;
    private String securitySupport_;
    private String[] wtaiLibraries_;
    private Boolean tablesCapable_;
    private String[] wmlVersion_;
    private Boolean textInputCapable_;
    private String wapDeviceClass_;
    private String wapVersion_;
    private String osVendor_;
    private String[] ccppAcceptEncoding_;
    private String osName_;
    private String xhtmlVersion_;
    private String htmlVersion_;
    private int numberOfSoftKeys_ = -1;
    private String mexeSpec_;
    private Boolean soundOutputCapable_;
    private Boolean colorCapable_;
    private String[] xhtmlModules_;
    private String[] downloadableSoftwareSupport_;
    private String osVersion_;
    private String[] jvmVersion_;
    private String[] ccppAccept_;
    private String[] inputCharSet_;
    private String pointingResolution_;
    private String softwareNumber_;
    private String screenSize_;
    private int screenHeight_ = -1;
    private int screenWidth_ = -1;
    private String screenSizeChar_;
    private int screenHeightChar_ = -1;
    private int screenWidthChar_ = -1;
    private String pixelAspectRatio_;
    private int pixelAspectRatioWidth_ = -1;
    private int pixelAspectRatioHeight_ = -1;
    private HashMap additionalAttrs_;
    public static final String PROFILE_TAG = "uaprofile";
    private static final String PROFILE_PATH = "/uaprofile/";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String END_LT = "</";
    private static final String LEFT_BRACE = "[";
    private static final String FORWARD_SLASH = "/";
    private static final String RIGHT_BRACE = "]";
    private static final String PROFILE_ID = "profileid";
    private static final String AML_ID = "amlid";
    private static final String XML_ID = "xmlid";
    private static final String DATE_CREATED = "datecreated";
    private static final String DATE_LAST_MODIFIED = "datelastmodified";
    private static final String LOCATION = "location";
    private static final String ALLOW_OVERRIDE = "allowoverride";
    private static final String PRESENTATION_STYLE = "presentationstyle";
    private static final String BASE_PROFILE_ID = "baseprofileid";
    private static final String WML_SCRIPT_VERSION = "wmlscriptversion";
    private static final String VIDEO_INPUT_ENCODER = "videoinputencoder";
    private static final String FRAMES_CAPABLE = "framescapable";
    private static final String JAVA_SCRIPT_VERSION = "javascriptversion";
    private static final String WML_SCRIPT_LIBRARIES = "wmlscriptlibraries";
    private static final String KEYBOARD = "keyboard";
    private static final String BROWSER_NAME = "browsername";
    private static final String IMAGE_CAPABLE = "imagecapable";
    private static final String ACCEPT_DOWNLOADABLE_SOFTWARE = "acceptdownloadablesoftware";
    private static final String VOICE_INPUT_CAPABLE = "voiceinputcapable";
    private static final String AUDIO_INPUT_ENCODER = "audioinputencoder";
    private static final String MEXE_CLASSMARK = "mexeclassmark";
    private static final String WAP_PUSH_MSG_SIZE = "wappushmsgsize";
    private static final String VENDOR = "vendor";
    private static final String MODEL = "model";
    private static final String BROWSER_VERSION = "browserversion";
    private static final String RECIPIENT_APP_AGENT = "recipientappagent";
    private static final String CCPP_ACCEPT_LANGUAGE = "ccppacceptlanguage";
    private static final String DOWNLOADABLE_BROWSER_APPS = "downloadablebrowserapps";
    private static final String SUPPORTED_BEARERS = "supportedbearers";
    private static final String STANDARD_FONT_PROPORTIONAL = "standardfontproportional";
    private static final String CPU = "cpu";
    private static final String PDU_SIZE = "pdusize";
    private static final String WAP_PUSH_MSG_PRIORITY = "wappushmsgpriority";
    private static final String PREFERENCE_FOR_FRAMES = "preferenceforframes";
    private static final String BITS_PER_PIXEL = "bitsperpixel";
    private static final String CURRENT_BEARER_SERVICE = "currentbearerservice";
    private static final String OUTPUT_CHARSET = "outputcharset";
    private static final String CCPP_ACCEPT_CHARSET = "ccppacceptcharset";
    private static final String SECURITY_SUPPORT = "securitysupport";
    private static final String WTAI_LIBRARIES = "wtailibraries";
    private static final String TABLES_CAPABLE = "tablescapable";
    private static final String WML_VERSION = "wmlversion";
    private static final String TEXT_INPUT_CAPABLE = "textinputcapable";
    private static final String WAP_DEVICE_CLASS = "wapdeviceclass";
    private static final String WAP_VERSION = "wapversion";
    private static final String OS_VENDOR = "osvendor";
    private static final String CCPP_ACCEPT_ENCODING = "ccppacceptencoding";
    private static final String OS_NAME = "osname";
    private static final String XHTML_VERSION = "xhtmlversion";
    private static final String HTML_VERSION = "htmlversion";
    private static final String NUMBER_OF_SOFTKEYS = "numberofsoftkeys";
    private static final String MEXE_SPEC = "mexespec";
    private static final String SOUND_OUTPUT_CAPABLE = "soundoutputcapable";
    private static final String COLOR_CAPABLE = "colorcapable";
    private static final String XHTML_MODULES = "xhtmlmodules";
    private static final String DOWNLOADABLE_SOFTWARE_SUPPORT = "downloadablesoftwaresupport";
    private static final String OS_VERSION = "osversion";
    private static final String JVM_VERSION = "jvmversion";
    private static final String CCPP_ACCEPT = "ccppaccept";
    private static final String INPUT_CHARSET = "inputcharset";
    private static final String POINTING_RESOLUTION = "pointingresolution";
    private static final String SOFTWARE_NUMBER = "softwarenumber";
    private static final String SCREEN_SIZE = "screensize";
    private static final String SCREEN_HEIGHT = "screenheight";
    private static final String SCREEN_WIDTH = "screenwidth";
    private static final String SCREEN_SIZE_CHAR = "screensizechar";
    private static final String SCREEN_HEIGHT_CHAR = "screenheightchar";
    private static final String SCREEN_WIDTH_CHAR = "screenwidthchar";
    private static final String PIXEL_ASPECT_RATIO = "pixelaspectratio";
    private static final String PIXEL_ASPECT_RATIO_WIDTH = "pixelaspectratiowidth";
    private static final String PIXEL_ASPECT_RATIO_HEIGHT = "pixelaspectratioheight";
    private static final String ADDITIONAL_ATTRIBUTES = "additionalattributes";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String NEW_LINE = "\n";
    private static final String EQUAL = "=";

    public UAProfileBase() {
    }

    public UAProfileBase(UAProfileBase uaprofile) {
        this.setBaseProfile(uaprofile);
    }

    public String getAmlID() {
        if (this.amlID_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getAmlID();
        }
        return this.amlID_;
    }

    public void setAmlID(String amlID) {
        this.amlID_ = amlID;
    }

    public String getXmlID() {
        if (this.xmlID_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getXmlID();
        }
        return this.xmlID_;
    }

    public void setXmlID(String xmlID) {
        this.xmlID_ = xmlID;
    }

    public Date getCreated() {
        return this.dateCreated_;
    }

    public void setCreated(Date date) {
        this.dateCreated_ = date;
    }

    public Date getLastModified() {
        return this.dateLastModified_;
    }

    public void setLastModified(Date date) {
        this.dateLastModified_ = date;
    }

    public String getLocation() {
        return this.location_;
    }

    public void setLocation(String location) {
        this.location_ = location;
    }

    public Boolean getAllowOverride() {
        return this.allowOverride_;
    }

    public boolean allowOverride() {
        if (this.allowOverride_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.allowOverride();
        }
        if (this.allowOverride_ != null) {
            return this.allowOverride_;
        }
        return false;
    }

    public void setAllowOverride(boolean value) {
        this.allowOverride_ = new Boolean(value);
    }

    public String getBaseProfileID() {
        return this.baseProfileID_;
    }

    public void setBaseProfileID(String id) {
        this.baseProfileID_ = id;
    }

    public void setBaseProfile(UAProfileBase uaprofile) {
        this.baseProfile_ = uaprofile;
    }

    public UAProfileBase getBaseProfile() {
        return this.baseProfile_;
    }

    public HashMap getAdditionalAttributes() {
        return this.additionalAttrs_;
    }

    public void setAdditionalAttributes(HashMap additionalAttrs) {
        this.additionalAttrs_ = additionalAttrs;
    }

    public String getKeyboard() {
        if (this.keyboard_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getKeyboard();
        }
        return this.keyboard_;
    }

    public void setKeyboard(String keyboard) {
        this.keyboard_ = keyboard;
    }

    public Boolean getImageCapable() {
        return this.imageCapable_;
    }

    public boolean isImageCapable() {
        if (this.imageCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isImageCapable();
        }
        if (this.imageCapable_ != null) {
            return this.imageCapable_;
        }
        return false;
    }

    public void setImageCapable(boolean value) {
        this.imageCapable_ = new Boolean(value);
    }

    public Boolean getVoiceInputCapable() {
        return this.voiceInputCapable_;
    }

    public boolean isVoiceInputCapable() {
        if (this.voiceInputCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isVoiceInputCapable();
        }
        if (this.voiceInputCapable_ != null) {
            return this.voiceInputCapable_;
        }
        return false;
    }

    public void setVoiceInputCapable(boolean value) {
        this.voiceInputCapable_ = new Boolean(value);
    }

    public String getVendor() {
        if (this.vendor_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getVendor();
        }
        return this.vendor_;
    }

    public void setVendor(String vendor) {
        this.vendor_ = vendor;
    }

    public String getModel() {
        if (this.model_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getModel();
        }
        return this.model_;
    }

    public void setModel(String model) {
        this.model_ = model;
    }

    public String getScreenSize() {
        if (this.screenSize_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getScreenSize();
        }
        return this.screenSize_;
    }

    public void setScreenSize(String size) {
        this.screenSize_ = size;
        if (this.screenSize_ != null && !this.screenSize_.equals("")) {
            String[] dimensions = UAProfileBase.getAttributeTokens(this.screenSize_, DIMENSION_DELIMITER);
            if (dimensions.length > 0) {
                this.screenWidth_ = Integer.valueOf(dimensions[0]);
                if (dimensions.length > 1) {
                    this.screenHeight_ = Integer.valueOf(dimensions[1]);
                }
            }
            this.determineScreenSizeInChar();
        }
    }

    public String getScreenSizeChar() {
        if (this.screenSizeChar_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getScreenSizeChar();
        }
        return this.screenSizeChar_;
    }

    public void setScreenSizeChar(String size) {
        String[] dimensions;
        this.screenSizeChar_ = size;
        if (this.screenSizeChar_ != null && !this.screenSizeChar_.equals("") && (dimensions = UAProfileBase.getAttributeTokens(this.screenSizeChar_, DIMENSION_DELIMITER)).length > 0) {
            this.screenWidthChar_ = Integer.valueOf(dimensions[0]);
            if (dimensions.length > 1) {
                this.screenHeightChar_ = Integer.valueOf(dimensions[1]);
            }
        }
    }

    public int getScreenHeight() {
        if (this.screenHeight_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getScreenHeight();
        }
        return this.screenHeight_;
    }

    public int getScreenHeightChar() {
        if (this.screenHeightChar_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getScreenHeightChar();
        }
        return this.screenHeightChar_;
    }

    public int getScreenWidth() {
        if (this.screenWidth_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getScreenWidth();
        }
        return this.screenWidth_;
    }

    public int getScreenWidthChar() {
        if (this.screenWidthChar_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getScreenWidthChar();
        }
        return this.screenWidthChar_;
    }

    public String getPixelAspectRatio() {
        if (this.pixelAspectRatio_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getPixelAspectRatio();
        }
        return this.pixelAspectRatio_;
    }

    public void setPixelAspectRatio(String ratio) {
        int width = 0;
        int height = 0;
        this.pixelAspectRatio_ = ratio;
        if (this.pixelAspectRatio_ != null && !this.pixelAspectRatio_.equals("")) {
            String[] dimensions = UAProfileBase.getAttributeTokens(this.pixelAspectRatio_, DIMENSION_DELIMITER);
            if (dimensions.length > 0) {
                this.pixelAspectRatioWidth_ = width = Integer.valueOf(dimensions[0]).intValue();
                if (dimensions.length > 1) {
                    this.pixelAspectRatioHeight_ = height = Integer.valueOf(dimensions[1]).intValue();
                }
                if (width != 0 && height != 0 && width != height) {
                    this.setStandardFontProportional(false);
                }
            }
            this.determineScreenSizeInChar();
        }
    }

    public int getPixelAspectRatioWidth() {
        if (this.pixelAspectRatioWidth_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getPixelAspectRatioWidth();
        }
        return this.pixelAspectRatioWidth_;
    }

    public int getPixelAspectRatioHeight() {
        if (this.pixelAspectRatioHeight_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getPixelAspectRatioHeight();
        }
        return this.pixelAspectRatioHeight_;
    }

    public Boolean getStandardFontProportional() {
        return this.standardFontProportional_;
    }

    public boolean isStandardFontProportional() {
        if (this.standardFontProportional_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isStandardFontProportional();
        }
        if (this.standardFontProportional_ != null) {
            return this.standardFontProportional_;
        }
        return false;
    }

    public void setStandardFontProportional(boolean value) {
        this.standardFontProportional_ = new Boolean(value);
    }

    public String getCPU() {
        if (this.cpu_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getCPU();
        }
        return this.cpu_;
    }

    public void setCPU(String cpu) {
        this.cpu_ = cpu;
    }

    public int getBitsPerPixel() {
        if (this.bitsPerPixel_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getBitsPerPixel();
        }
        return this.bitsPerPixel_;
    }

    public void setBitsPerPixel(int bits) {
        this.bitsPerPixel_ = bits;
    }

    public String[] getOutputCharSet() {
        if (this.outputCharSet_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getOutputCharSet();
        }
        return this.outputCharSet_;
    }

    public void setOutputCharSet(String[] outputCharSets) {
        if (outputCharSets != null) {
            Arrays.sort(outputCharSets);
        }
        this.outputCharSet_ = outputCharSets;
    }

    public Boolean getTextInputCapable() {
        return this.textInputCapable_;
    }

    public boolean isTextInputCapable() {
        if (this.textInputCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isTextInputCapable();
        }
        if (this.textInputCapable_ != null) {
            return this.textInputCapable_;
        }
        return false;
    }

    public void setTextInputCapable(boolean value) {
        this.textInputCapable_ = new Boolean(value);
    }

    public int getNumberOfSoftKeys() {
        if (this.numberOfSoftKeys_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getNumberOfSoftKeys();
        }
        return this.numberOfSoftKeys_;
    }

    public void setNumberOfSoftKeys(int numKeys) {
        this.numberOfSoftKeys_ = numKeys;
    }

    public Boolean getSoundOutputCapable() {
        return this.soundOutputCapable_;
    }

    public boolean isSoundOutputCapable() {
        if (this.soundOutputCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isSoundOutputCapable();
        }
        if (this.soundOutputCapable_ != null) {
            return this.soundOutputCapable_;
        }
        return false;
    }

    public void setSoundOutputCapable(boolean value) {
        this.soundOutputCapable_ = new Boolean(value);
    }

    public Boolean getColorCapable() {
        return this.colorCapable_;
    }

    public boolean isColorCapable() {
        if (this.colorCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isColorCapable();
        }
        if (this.colorCapable_ != null) {
            return this.colorCapable_;
        }
        return false;
    }

    public void setColorCapable(boolean value) {
        this.colorCapable_ = new Boolean(value);
    }

    public String[] getInputCharSet() {
        if (this.inputCharSet_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getInputCharSet();
        }
        return this.inputCharSet_;
    }

    public void setInputCharSet(String[] charSet) {
        if (charSet != null) {
            Arrays.sort(charSet);
        }
        this.inputCharSet_ = charSet;
    }

    public String getPointingResolution() {
        if (this.pointingResolution_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getPointingResolution();
        }
        return this.pointingResolution_;
    }

    public void setPointingResolution(String resolution) {
        this.pointingResolution_ = resolution;
    }

    public String[] getVideoInputEncoder() {
        if (this.videoInputEncoder_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getVideoInputEncoder();
        }
        return this.videoInputEncoder_;
    }

    public void setVideoInputEncoder(String[] list) {
        if (list != null) {
            Arrays.sort(list);
        }
        this.videoInputEncoder_ = list;
    }

    public Boolean getAcceptDownloadableSoftware() {
        return this.acceptDownloadableSoftware_;
    }

    public boolean acceptDownloadableSoftware() {
        if (this.acceptDownloadableSoftware_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.acceptDownloadableSoftware();
        }
        if (this.acceptDownloadableSoftware_ != null) {
            return this.acceptDownloadableSoftware_;
        }
        return false;
    }

    public void setAcceptDownloadableSoftware(boolean value) {
        this.acceptDownloadableSoftware_ = new Boolean(value);
    }

    public String[] getAudioInputEncoder() {
        if (this.audioInputEncoder_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getAudioInputEncoder();
        }
        return this.audioInputEncoder_;
    }

    public void setAudioInputEncoder(String[] list) {
        if (list != null) {
            Arrays.sort(list);
        }
        this.audioInputEncoder_ = list;
    }

    public String getMexeClassmark() {
        if (this.mexeClassmark_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getMexeClassmark();
        }
        return this.mexeClassmark_;
    }

    public void setMexeClassmark(String classmark) {
        this.mexeClassmark_ = classmark;
    }

    public String getRecipientAppAgent() {
        return this.recipientAppAgent_;
    }

    public void setRecipientAppAgent(String agent) {
        this.recipientAppAgent_ = agent;
    }

    public String getOSName() {
        if (this.osName_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getOSName();
        }
        return this.osName_;
    }

    public void setOSName(String name) {
        this.osName_ = name;
    }

    public String getOSVendor() {
        if (this.osVendor_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getOSVendor();
        }
        return this.osVendor_;
    }

    public void setOSVendor(String vendor) {
        this.osVendor_ = vendor;
    }

    public String getOSVersion() {
        if (this.osVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getOSVersion();
        }
        return this.osVersion_;
    }

    public void setOSVersion(String version) {
        this.osVersion_ = version;
    }

    public String getSoftwareNumber() {
        if (this.softwareNumber_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getSoftwareNumber();
        }
        return this.softwareNumber_;
    }

    public void setSoftwareNumber(String number) {
        this.softwareNumber_ = number;
    }

    public String getMexeSpec() {
        if (this.mexeSpec_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getMexeSpec();
        }
        return this.mexeSpec_;
    }

    public void setMexeSpec(String spec) {
        this.mexeSpec_ = spec;
    }

    public String[] getDownloadableSoftwareSupport() {
        if (this.downloadableSoftwareSupport_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getDownloadableSoftwareSupport();
        }
        return this.downloadableSoftwareSupport_;
    }

    public void setDownloadableSoftwareSupport(String[] types) {
        if (types != null) {
            Arrays.sort(types);
        }
        this.downloadableSoftwareSupport_ = types;
    }

    public String[] getJVMVersion() {
        if (this.jvmVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getJVMVersion();
        }
        return this.jvmVersion_;
    }

    public void setJVMVersion(String[] versions) {
        if (versions != null) {
            Arrays.sort(versions);
        }
        this.jvmVersion_ = versions;
    }

    public String[] getSupportedBearers() {
        if (this.supportedBearers_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getSupportedBearers();
        }
        return this.supportedBearers_;
    }

    public void setSupportedBearers(String[] bearers) {
        if (bearers != null) {
            Arrays.sort(bearers);
        }
        this.supportedBearers_ = bearers;
    }

    public String getCurrentBearerService() {
        if (this.currentBearerService_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getCurrentBearerService();
        }
        return this.currentBearerService_;
    }

    public void setCurrentBearerService(String bearer) {
        this.currentBearerService_ = bearer;
    }

    public String getSecuritySupport() {
        if (this.securitySupport_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getSecuritySupport();
        }
        return this.securitySupport_;
    }

    public void setSecuritySupport(String securitySupport) {
        this.securitySupport_ = securitySupport;
    }

    public Boolean getFramesCapable() {
        return this.framesCapable_;
    }

    public boolean isFramesCapable() {
        if (this.framesCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isFramesCapable();
        }
        if (this.framesCapable_ != null) {
            return this.framesCapable_;
        }
        return false;
    }

    public void setFramesCapable(boolean value) {
        this.framesCapable_ = new Boolean(value);
    }

    public String getJavaScriptVersion() {
        if (this.javaScriptVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getJavaScriptVersion();
        }
        return this.javaScriptVersion_;
    }

    public void setJavaScriptVersion(String version) {
        this.javaScriptVersion_ = version;
    }

    public String getBrowserName() {
        if (this.browserName_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getBrowserName();
        }
        return this.browserName_;
    }

    public void setBrowserName(String name) {
        this.browserName_ = name;
    }

    public String getBrowserVersion() {
        if (this.browserVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getBrowserVersion();
        }
        return this.browserVersion_;
    }

    public void setBrowserVersion(String version) {
        this.browserVersion_ = version;
    }

    public String[] getCcppAcceptLanguage() {
        if (this.ccppAcceptLanguage_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getCcppAcceptLanguage();
        }
        return this.ccppAcceptLanguage_;
    }

    public void setCcppAcceptLanguage(String[] languages) {
        if (languages != null) {
            Arrays.sort(languages);
        }
        this.ccppAcceptLanguage_ = languages;
    }

    public String[] getDownloadableBrowserApps() {
        if (this.downloadableBrowserApps_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getDownloadableBrowserApps();
        }
        return this.downloadableBrowserApps_;
    }

    public void setDownloadableBrowserApps(String[] apps) {
        if (apps != null) {
            Arrays.sort(apps);
        }
        this.downloadableBrowserApps_ = apps;
    }

    public Boolean getPreferenceForFrames() {
        return this.preferenceForFrames_;
    }

    public boolean hasPreferenceForFrames() {
        if (this.preferenceForFrames_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.hasPreferenceForFrames();
        }
        if (this.preferenceForFrames_ != null) {
            return this.preferenceForFrames_;
        }
        return false;
    }

    public void setPreferenceForFrames(boolean value) {
        this.preferenceForFrames_ = new Boolean(value);
    }

    public String[] getCcppAcceptCharSet() {
        if (this.ccppAcceptCharset_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getCcppAcceptCharSet();
        }
        return this.ccppAcceptCharset_;
    }

    public void setCcppAcceptCharSet(String[] acceptCharset) {
        if (acceptCharset != null) {
            Arrays.sort(acceptCharset);
        }
        this.ccppAcceptCharset_ = acceptCharset;
    }

    public Boolean getTablesCapable() {
        return this.tablesCapable_;
    }

    public boolean isTablesCapable() {
        if (this.tablesCapable_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.isTablesCapable();
        }
        if (this.tablesCapable_ != null) {
            return this.tablesCapable_;
        }
        return false;
    }

    public void setTablesCapable(boolean value) {
        this.tablesCapable_ = new Boolean(value);
    }

    public String[] getCcppAcceptEncoding() {
        if (this.ccppAcceptEncoding_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getCcppAcceptEncoding();
        }
        return this.ccppAcceptEncoding_;
    }

    public void setCcppAcceptEncoding(String[] encodings) {
        if (encodings != null) {
            Arrays.sort(encodings);
        }
        this.ccppAcceptEncoding_ = encodings;
    }

    public String getXhtmlVersion() {
        if (this.xhtmlVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getXhtmlVersion();
        }
        return this.xhtmlVersion_;
    }

    public void setXhtmlVersion(String version) {
        this.xhtmlVersion_ = version;
    }

    public String getHtmlVersion() {
        if (this.htmlVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getHtmlVersion();
        }
        return this.htmlVersion_;
    }

    public void setHtmlVersion(String version) {
        this.htmlVersion_ = version;
    }

    public String[] getXhtmlModules() {
        if (this.xhtmlModules_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getXhtmlModules();
        }
        return this.xhtmlModules_;
    }

    public void setXhtmlModules(String[] modules) {
        if (modules != null) {
            Arrays.sort(modules);
        }
        this.xhtmlModules_ = modules;
    }

    public String[] getCcppAccept() {
        if (this.ccppAccept_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getCcppAccept();
        }
        return this.ccppAccept_;
    }

    public void setCcppAccept(String[] accepts) {
        if (accepts != null) {
            Arrays.sort(accepts);
        }
        this.ccppAccept_ = accepts;
    }

    public String[] getWmlScriptVersion() {
        if (this.wmlScriptVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWmlScriptVersion();
        }
        return this.wmlScriptVersion_;
    }

    public void setWmlScriptVersion(String[] list) {
        if (list != null) {
            Arrays.sort(list);
        }
        this.wmlScriptVersion_ = list;
    }

    public String[] getWmlScriptLibraries() {
        if (this.wmlScriptLibraries_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWmlScriptLibraries();
        }
        return this.wmlScriptLibraries_;
    }

    public void setWmlScriptLibraries(String[] libraries) {
        if (libraries != null) {
            Arrays.sort(libraries);
        }
        this.wmlScriptLibraries_ = libraries;
    }

    public int getWapPushMsgSize() {
        if (this.wapPushMsgSize_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getWapPushMsgSize();
        }
        return this.wapPushMsgSize_;
    }

    public void setWapPushMsgSize(int size) {
        this.wapPushMsgSize_ = size;
    }

    public int getPDUSize() {
        if (this.pduSize_ == -1 && this.baseProfile_ != null) {
            return this.baseProfile_.getPDUSize();
        }
        return this.pduSize_;
    }

    public void setPDUSize(int size) {
        this.pduSize_ = size;
    }

    public String getWapPushMsgPriority() {
        if (this.wapPushMsgPriority_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWapPushMsgPriority();
        }
        return this.wapPushMsgPriority_;
    }

    public void setWapPushMsgPriority(String wapPushMsgPriority) {
        this.wapPushMsgPriority_ = wapPushMsgPriority;
    }

    public String[] getWtaiLibraries() {
        if (this.wtaiLibraries_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWtaiLibraries();
        }
        return this.wtaiLibraries_;
    }

    public void setWtaiLibraries(String[] wtaiLibraries) {
        if (wtaiLibraries != null) {
            Arrays.sort(wtaiLibraries);
        }
        this.wtaiLibraries_ = wtaiLibraries;
    }

    public String[] getWmlVersion() {
        if (this.wmlVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWmlVersion();
        }
        return this.wmlVersion_;
    }

    public void setWmlVersion(String[] wmlVersion) {
        if (wmlVersion != null) {
            Arrays.sort(wmlVersion);
        }
        this.wmlVersion_ = wmlVersion;
    }

    public String getWapVersion() {
        if (this.wapVersion_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWapVersion();
        }
        return this.wapVersion_;
    }

    public void setWapVersion(String version) {
        this.wapVersion_ = version;
    }

    public String getWapDeviceClass() {
        if (this.wapDeviceClass_ == null && this.baseProfile_ != null) {
            return this.baseProfile_.getWapDeviceClass();
        }
        return this.wapDeviceClass_;
    }

    public void setWapDeviceClass(String deviceClass) {
        this.wapDeviceClass_ = deviceClass;
    }

    public static String[] getAttributeTokens(String attribute, String delimiter) {
        StringTokenizer st = new StringTokenizer(attribute, delimiter);
        int numTokens = st.countTokens();
        String[] tokens = new String[numTokens];
        int i = 0;
        while (i < numTokens && st.hasMoreTokens()) {
            tokens[i] = st.nextToken().trim();
            ++i;
        }
        return tokens;
    }

    public static String attributeTokensToString(String[] attributes, String delimiter) {
        StringBuffer result = new StringBuffer();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                result.append(attributes[i]);
                if (i != attributes.length - 1) {
                    result.append(delimiter);
                }
                ++i;
            }
        }
        return result.toString();
    }

    private void determineScreenSizeInChar() {
        if (this.screenHeight_ > 0 && this.screenWidth_ > 0 && this.pixelAspectRatioHeight_ > 0 && this.pixelAspectRatioWidth_ > 0) {
            this.screenSizeChar_ = null;
            this.screenHeightChar_ = this.screenHeight_ / this.pixelAspectRatioHeight_;
            this.screenWidthChar_ = this.screenWidth_ / this.pixelAspectRatioWidth_;
            StringBuffer sizeStr = new StringBuffer(String.valueOf(this.screenWidthChar_));
            sizeStr.append(DIMENSION_DELIMITER);
            sizeStr.append(String.valueOf(this.screenHeightChar_));
            this.screenSizeChar_ = sizeStr.toString();
        }
    }

    public boolean changedAfter(Date date) {
        return this.dateLastModified_.after(date);
    }

    public Object clone() {
        UAProfileBase copyProfile = new UAProfileBase();
        copyProfile.setAmlID(this.amlID_);
        copyProfile.setXmlID(this.xmlID_);
        copyProfile.setBaseProfileID(this.baseProfileID_);
        copyProfile.setCreated(this.dateCreated_);
        copyProfile.setLastModified(this.dateLastModified_);
        Boolean value = this.getAllowOverride();
        if (value != null) {
            copyProfile.setAllowOverride(this.allowOverride());
        }
        copyProfile.setWmlScriptVersion(this.wmlScriptVersion_);
        copyProfile.setVideoInputEncoder(this.videoInputEncoder_);
        value = this.getFramesCapable();
        if (value != null) {
            copyProfile.setFramesCapable(this.isFramesCapable());
        }
        copyProfile.setJavaScriptVersion(this.javaScriptVersion_);
        copyProfile.setWmlScriptLibraries(this.wmlScriptLibraries_);
        copyProfile.setKeyboard(this.keyboard_);
        copyProfile.setBrowserName(this.browserName_);
        value = this.getImageCapable();
        if (value != null) {
            copyProfile.setImageCapable(this.isImageCapable());
        }
        if ((value = this.getAcceptDownloadableSoftware()) != null) {
            copyProfile.setAcceptDownloadableSoftware(this.acceptDownloadableSoftware());
        }
        if ((value = this.getVoiceInputCapable()) != null) {
            copyProfile.setVoiceInputCapable(this.isVoiceInputCapable());
        }
        copyProfile.setAudioInputEncoder(this.audioInputEncoder_);
        copyProfile.setMexeClassmark(this.mexeClassmark_);
        copyProfile.setWapPushMsgSize(this.wapPushMsgSize_);
        copyProfile.setVendor(this.vendor_);
        copyProfile.setModel(this.model_);
        copyProfile.setBrowserVersion(this.browserVersion_);
        copyProfile.setRecipientAppAgent(this.recipientAppAgent_);
        copyProfile.setCcppAcceptLanguage(this.ccppAcceptLanguage_);
        copyProfile.setDownloadableBrowserApps(this.downloadableBrowserApps_);
        copyProfile.setSupportedBearers(this.supportedBearers_);
        value = this.getStandardFontProportional();
        if (value != null) {
            copyProfile.setStandardFontProportional(this.isStandardFontProportional());
        }
        copyProfile.setCPU(this.cpu_);
        copyProfile.setPDUSize(this.pduSize_);
        copyProfile.setWapPushMsgPriority(this.wapPushMsgPriority_);
        value = this.getPreferenceForFrames();
        if (value != null) {
            copyProfile.setPreferenceForFrames(this.hasPreferenceForFrames());
        }
        copyProfile.setBitsPerPixel(this.bitsPerPixel_);
        copyProfile.setCurrentBearerService(this.currentBearerService_);
        copyProfile.setOutputCharSet(this.outputCharSet_);
        copyProfile.setCcppAcceptCharSet(this.ccppAcceptCharset_);
        copyProfile.setSecuritySupport(this.securitySupport_);
        copyProfile.setScreenSizeChar(this.screenSizeChar_);
        copyProfile.setScreenSize(this.screenSize_);
        copyProfile.setWtaiLibraries(this.wtaiLibraries_);
        value = this.getTablesCapable();
        if (value != null) {
            copyProfile.setTablesCapable(this.isTablesCapable());
        }
        copyProfile.setWmlVersion(this.wmlVersion_);
        value = this.getTextInputCapable();
        if (value != null) {
            copyProfile.setTextInputCapable(this.isTextInputCapable());
        }
        copyProfile.setWapDeviceClass(this.wapDeviceClass_);
        copyProfile.setWapVersion(this.wapVersion_);
        copyProfile.setOSVendor(this.osVendor_);
        copyProfile.setCcppAcceptEncoding(this.ccppAcceptEncoding_);
        copyProfile.setPixelAspectRatio(this.pixelAspectRatio_);
        copyProfile.setOSName(this.osName_);
        copyProfile.setXhtmlVersion(this.xhtmlVersion_);
        copyProfile.setHtmlVersion(this.htmlVersion_);
        copyProfile.setNumberOfSoftKeys(this.numberOfSoftKeys_);
        copyProfile.setMexeSpec(this.mexeSpec_);
        value = this.getSoundOutputCapable();
        if (value != null) {
            copyProfile.setSoundOutputCapable(this.isSoundOutputCapable());
        }
        if ((value = this.getColorCapable()) != null) {
            copyProfile.setColorCapable(this.isColorCapable());
        }
        copyProfile.setXhtmlModules(this.xhtmlModules_);
        copyProfile.setDownloadableSoftwareSupport(this.downloadableSoftwareSupport_);
        copyProfile.setOSVersion(this.osVersion_);
        copyProfile.setJVMVersion(this.jvmVersion_);
        copyProfile.setCcppAccept(this.ccppAccept_);
        copyProfile.setInputCharSet(this.inputCharSet_);
        copyProfile.setPointingResolution(this.pointingResolution_);
        copyProfile.setSoftwareNumber(this.softwareNumber_);
        copyProfile.setBaseProfile(this.baseProfile_);
        return copyProfile;
    }

    public boolean equals(UAProfile profile) {
        return this.stringsEqual(this.getAmlID(), profile.getAmlID()) && this.stringsEqual(this.getXmlID(), profile.getXmlID()) && this.stringsEqual(this.getBaseProfileID(), profile.getBaseProfileID()) && this.arraysEqual(this.getWmlScriptVersion(), profile.getWmlScriptVersion()) && this.arraysEqual(this.getVideoInputEncoder(), profile.getVideoInputEncoder()) && this.isFramesCapable() == profile.isFramesCapable() && this.stringsEqual(this.getJavaScriptVersion(), profile.getJavaScriptVersion()) && this.arraysEqual(this.getWmlScriptLibraries(), profile.getWmlScriptLibraries()) && this.stringsEqual(this.getKeyboard(), profile.getKeyboard()) && this.stringsEqual(this.getBrowserName(), profile.getBrowserName()) && this.isImageCapable() == profile.isImageCapable() && this.acceptDownloadableSoftware() == profile.acceptDownloadableSoftware() && this.isVoiceInputCapable() == profile.isVoiceInputCapable() && this.arraysEqual(this.getAudioInputEncoder(), profile.getAudioInputEncoder()) && this.stringsEqual(this.getMexeClassmark(), profile.getMexeClassmark()) && this.getWapPushMsgSize() == profile.getWapPushMsgSize() && this.stringsEqual(this.getVendor(), profile.getVendor()) && this.stringsEqual(this.getModel(), profile.getModel()) && this.stringsEqual(this.getBrowserVersion(), profile.getBrowserVersion()) && this.stringsEqual(this.getRecipientAppAgent(), profile.getRecipientAppAgent()) && this.arraysEqual(this.getCcppAcceptLanguage(), profile.getCcppAcceptLanguage()) && this.arraysEqual(this.getDownloadableBrowserApps(), profile.getDownloadableBrowserApps()) && this.arraysEqual(this.getSupportedBearers(), profile.getSupportedBearers()) && this.isStandardFontProportional() == profile.isStandardFontProportional() && this.stringsEqual(this.getCPU(), profile.getCPU()) && this.getPDUSize() == profile.getPDUSize() && this.stringsEqual(this.getWapPushMsgPriority(), profile.getWapPushMsgPriority()) && this.hasPreferenceForFrames() == profile.hasPreferenceForFrames() && this.getBitsPerPixel() == profile.getBitsPerPixel() && this.stringsEqual(this.getCurrentBearerService(), profile.getCurrentBearerService()) && this.arraysEqual(this.getOutputCharSet(), profile.getOutputCharSet()) && this.arraysEqual(this.getCcppAcceptCharSet(), profile.getCcppAcceptCharSet()) && this.stringsEqual(this.getSecuritySupport(), profile.getSecuritySupport()) && this.stringsEqual(this.getScreenSizeChar(), profile.getScreenSizeChar()) && this.stringsEqual(this.getScreenSize(), profile.getScreenSize()) && this.arraysEqual(this.getWtaiLibraries(), profile.getWtaiLibraries()) && this.isTablesCapable() == profile.isTablesCapable() && this.arraysEqual(this.getWmlVersion(), profile.getWmlVersion()) && this.isTextInputCapable() == profile.isTextInputCapable() && this.stringsEqual(this.getWapDeviceClass(), profile.getWapDeviceClass()) && this.stringsEqual(this.getWapVersion(), profile.getWapVersion()) && this.stringsEqual(this.getOSVendor(), profile.getOSVendor()) && this.arraysEqual(this.getCcppAcceptEncoding(), profile.getCcppAcceptEncoding()) && this.stringsEqual(this.getPixelAspectRatio(), profile.getPixelAspectRatio()) && this.stringsEqual(this.getOSName(), profile.getOSName()) && this.stringsEqual(this.getXhtmlVersion(), profile.getXhtmlVersion()) && this.stringsEqual(this.getHtmlVersion(), profile.getHtmlVersion()) && this.getNumberOfSoftKeys() == profile.getNumberOfSoftKeys() && this.stringsEqual(this.getMexeSpec(), profile.getMexeSpec()) && this.isSoundOutputCapable() == profile.isSoundOutputCapable() && this.isColorCapable() == profile.isColorCapable() && this.arraysEqual(this.getXhtmlModules(), profile.getXhtmlModules()) && this.arraysEqual(this.getDownloadableSoftwareSupport(), profile.getDownloadableSoftwareSupport()) && this.stringsEqual(this.getOSVersion(), profile.getOSVersion()) && this.arraysEqual(this.getJVMVersion(), profile.getJVMVersion()) && this.arraysEqual(this.getCcppAccept(), profile.getCcppAccept()) && this.arraysEqual(this.getInputCharSet(), profile.getInputCharSet()) && this.stringsEqual(this.getPointingResolution(), profile.getPointingResolution()) && this.stringsEqual(this.getSoftwareNumber(), profile.getSoftwareNumber());
    }

    private boolean arraysEqual(String[] array1, String[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 != null && array2 != null) {
            Arrays.sort(array1);
            Arrays.sort(array2);
            return Arrays.equals(array1, array2);
        }
        return false;
    }

    private boolean stringsEqual(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 != null && string2 != null) {
            return string1.equals(string2);
        }
        return false;
    }

    public void fromXml(File file) throws XMLException {
        try {
            FileReader fr = new FileReader(file);
            this.fromXml(fr);
        }
        catch (IOException e) {
            throw new XMLException("Cannot read input file");
        }
    }

    public void fromXml(InputStreamReader isr) throws XMLException {
        try {
            char[] buffer = new char[4096];
            int i = 0;
            StringBuffer xmlData = new StringBuffer();
            while ((i = isr.read(buffer)) > 0) {
                xmlData.append(buffer, 0, i);
            }
            XMLParser parser = new XMLParser();
            XMLHDOM dom = parser.parse(xmlData.toString());
            this.fromXml(dom);
        }
        catch (IOException e) {
            throw new XMLException("Cannot read input file");
        }
    }

    public void fromXml(String xml) throws XMLException {
        XMLParser parser = new XMLParser();
        XMLHDOM dom = parser.parse(xml);
        this.fromXml(dom);
    }

    public String toSubXml() {
        StringBuffer results = new StringBuffer(LT);
        results.append(PROFILE_TAG);
        results.append(GT);
        this.appendElementXml(results, AML_ID, this.getAmlID());
        this.appendElementXml(results, XML_ID, this.getXmlID());
        Date dateValue = this.getCreated();
        if (dateValue != null) {
            this.appendElementXml(results, DATE_CREATED, formatter.format(dateValue));
        }
        if ((dateValue = this.getLastModified()) != null) {
            this.appendElementXml(results, DATE_LAST_MODIFIED, formatter.format(dateValue));
        }
        this.appendElementXml(results, LOCATION, this.getLocation());
        Boolean bValue = this.getAllowOverride();
        if (bValue != null) {
            this.appendElementXml(results, ALLOW_OVERRIDE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getAllowOverride() != null) {
            this.appendElementXml(results, ALLOW_OVERRIDE, this.baseProfile_.getAllowOverride().toString());
        }
        this.appendElementXml(results, BASE_PROFILE_ID, this.getBaseProfileID());
        this.appendElementXml(results, RECIPIENT_APP_AGENT, this.getRecipientAppAgent());
        results.append(END_LT);
        results.append(PROFILE_TAG);
        results.append(GT);
        return results.toString();
    }

    public String toXml() {
        StringBuffer results = new StringBuffer(LT);
        results.append(PROFILE_TAG);
        results.append(GT);
        this.appendElementXml(results, AML_ID, this.getAmlID());
        this.appendElementXml(results, XML_ID, this.getXmlID());
        Date dateValue = this.getCreated();
        if (dateValue != null) {
            this.appendElementXml(results, DATE_CREATED, formatter.format(dateValue));
        }
        if ((dateValue = this.getLastModified()) != null) {
            this.appendElementXml(results, DATE_LAST_MODIFIED, formatter.format(dateValue));
        }
        this.appendElementXml(results, LOCATION, this.getLocation());
        Boolean bValue = this.getAllowOverride();
        if (bValue != null) {
            this.appendElementXml(results, ALLOW_OVERRIDE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getAllowOverride() != null) {
            this.appendElementXml(results, ALLOW_OVERRIDE, this.baseProfile_.getAllowOverride().toString());
        }
        this.appendElementXml(results, BASE_PROFILE_ID, this.getBaseProfileID());
        this.appendElementsXml(results, WML_SCRIPT_VERSION, this.getWmlScriptVersion());
        this.appendElementsXml(results, VIDEO_INPUT_ENCODER, this.getVideoInputEncoder());
        bValue = this.getFramesCapable();
        if (bValue != null) {
            this.appendElementXml(results, FRAMES_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getFramesCapable() != null) {
            this.appendElementXml(results, FRAMES_CAPABLE, this.baseProfile_.getFramesCapable().toString());
        }
        this.appendElementXml(results, JAVA_SCRIPT_VERSION, this.getJavaScriptVersion());
        this.appendElementsXml(results, WML_SCRIPT_LIBRARIES, this.getWmlScriptLibraries());
        this.appendElementXml(results, KEYBOARD, this.getKeyboard());
        this.appendElementXml(results, BROWSER_NAME, this.getBrowserName());
        bValue = this.getImageCapable();
        if (bValue != null) {
            this.appendElementXml(results, IMAGE_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getImageCapable() != null) {
            this.appendElementXml(results, IMAGE_CAPABLE, this.baseProfile_.getImageCapable().toString());
        }
        bValue = this.getAcceptDownloadableSoftware();
        if (bValue != null) {
            this.appendElementXml(results, ACCEPT_DOWNLOADABLE_SOFTWARE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getAcceptDownloadableSoftware() != null) {
            this.appendElementXml(results, ACCEPT_DOWNLOADABLE_SOFTWARE, this.baseProfile_.getAcceptDownloadableSoftware().toString());
        }
        bValue = this.getVoiceInputCapable();
        if (bValue != null) {
            this.appendElementXml(results, VOICE_INPUT_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getVoiceInputCapable() != null) {
            this.appendElementXml(results, VOICE_INPUT_CAPABLE, this.baseProfile_.getVoiceInputCapable().toString());
        }
        this.appendElementsXml(results, AUDIO_INPUT_ENCODER, this.getAudioInputEncoder());
        this.appendElementXml(results, MEXE_CLASSMARK, this.getMexeClassmark());
        int intValue = this.getWapPushMsgSize();
        if (intValue >= 0) {
            this.appendElementXml(results, WAP_PUSH_MSG_SIZE, Integer.toString(intValue));
        }
        this.appendElementXml(results, VENDOR, this.getVendor());
        this.appendElementXml(results, MODEL, this.getModel());
        this.appendElementXml(results, BROWSER_VERSION, this.getBrowserVersion());
        this.appendElementXml(results, RECIPIENT_APP_AGENT, this.getRecipientAppAgent());
        this.appendElementsXml(results, CCPP_ACCEPT_LANGUAGE, this.getCcppAcceptLanguage());
        this.appendElementsXml(results, DOWNLOADABLE_BROWSER_APPS, this.getDownloadableBrowserApps());
        this.appendElementsXml(results, SUPPORTED_BEARERS, this.getSupportedBearers());
        bValue = this.getStandardFontProportional();
        if (bValue != null) {
            this.appendElementXml(results, STANDARD_FONT_PROPORTIONAL, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getStandardFontProportional() != null) {
            this.appendElementXml(results, STANDARD_FONT_PROPORTIONAL, this.baseProfile_.getStandardFontProportional().toString());
        }
        this.appendElementXml(results, CPU, this.getCPU());
        intValue = this.getPDUSize();
        if (intValue >= 0) {
            this.appendElementXml(results, PDU_SIZE, Integer.toString(intValue));
        }
        this.appendElementXml(results, WAP_PUSH_MSG_PRIORITY, this.getWapPushMsgPriority());
        bValue = this.getPreferenceForFrames();
        if (bValue != null) {
            this.appendElementXml(results, PREFERENCE_FOR_FRAMES, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getPreferenceForFrames() != null) {
            this.appendElementXml(results, PREFERENCE_FOR_FRAMES, this.baseProfile_.getPreferenceForFrames().toString());
        }
        intValue = this.getBitsPerPixel();
        if (intValue >= 0) {
            this.appendElementXml(results, BITS_PER_PIXEL, Integer.toString(intValue));
        }
        this.appendElementsXml(results, OUTPUT_CHARSET, this.getOutputCharSet());
        this.appendElementsXml(results, CCPP_ACCEPT_CHARSET, this.getCcppAcceptCharSet());
        this.appendElementXml(results, SECURITY_SUPPORT, this.getSecuritySupport());
        this.appendElementsXml(results, WTAI_LIBRARIES, this.getWtaiLibraries());
        bValue = this.getTablesCapable();
        if (bValue != null) {
            this.appendElementXml(results, TABLES_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getTablesCapable() != null) {
            this.appendElementXml(results, TABLES_CAPABLE, this.baseProfile_.getTablesCapable().toString());
        }
        this.appendElementsXml(results, WML_VERSION, this.getWmlVersion());
        bValue = this.getTextInputCapable();
        if (bValue != null) {
            this.appendElementXml(results, TEXT_INPUT_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getTextInputCapable() != null) {
            this.appendElementXml(results, TEXT_INPUT_CAPABLE, this.baseProfile_.getTextInputCapable().toString());
        }
        this.appendElementXml(results, WAP_DEVICE_CLASS, this.getWapDeviceClass());
        this.appendElementXml(results, WAP_VERSION, this.getWapVersion());
        this.appendElementXml(results, OS_VENDOR, this.getOSVendor());
        this.appendElementsXml(results, CCPP_ACCEPT_ENCODING, this.getCcppAcceptEncoding());
        this.appendElementXml(results, OS_NAME, this.getOSName());
        this.appendElementXml(results, XHTML_VERSION, this.getXhtmlVersion());
        this.appendElementXml(results, HTML_VERSION, this.getHtmlVersion());
        intValue = this.getNumberOfSoftKeys();
        if (intValue >= 0) {
            this.appendElementXml(results, NUMBER_OF_SOFTKEYS, Integer.toString(intValue));
        }
        this.appendElementXml(results, MEXE_SPEC, this.getMexeSpec());
        bValue = this.getSoundOutputCapable();
        if (bValue != null) {
            this.appendElementXml(results, SOUND_OUTPUT_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getSoundOutputCapable() != null) {
            this.appendElementXml(results, SOUND_OUTPUT_CAPABLE, this.baseProfile_.getSoundOutputCapable().toString());
        }
        bValue = this.getColorCapable();
        if (bValue != null) {
            this.appendElementXml(results, COLOR_CAPABLE, bValue.toString());
        } else if (this.baseProfile_ != null && this.baseProfile_.getColorCapable() != null) {
            this.appendElementXml(results, COLOR_CAPABLE, this.baseProfile_.getColorCapable().toString());
        }
        this.appendElementsXml(results, XHTML_MODULES, this.getXhtmlModules());
        this.appendElementsXml(results, DOWNLOADABLE_SOFTWARE_SUPPORT, this.getDownloadableSoftwareSupport());
        this.appendElementXml(results, OS_VERSION, this.getOSVersion());
        this.appendElementsXml(results, JVM_VERSION, this.getJVMVersion());
        this.appendElementsXml(results, CCPP_ACCEPT, this.getCcppAccept());
        this.appendElementsXml(results, INPUT_CHARSET, this.getInputCharSet());
        this.appendElementXml(results, POINTING_RESOLUTION, this.getPointingResolution());
        this.appendElementXml(results, SOFTWARE_NUMBER, this.getSoftwareNumber());
        this.appendElementXml(results, SCREEN_SIZE, this.getScreenSize());
        this.appendElementXml(results, SCREEN_SIZE_CHAR, this.getScreenSizeChar());
        this.appendElementXml(results, PIXEL_ASPECT_RATIO, this.getPixelAspectRatio());
        this.appendAdditionalAttributesXml(results);
        results.append(END_LT);
        results.append(PROFILE_TAG);
        results.append(GT);
        return results.toString();
    }

    private void fromXml(XMLHDOM dom) throws XMLException {
        ParsePosition pos;
        Date date;
        StringBuffer key = new StringBuffer(PROFILE_PATH);
        key.append(AML_ID);
        this.setAmlID(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), XML_ID);
        this.setXmlID(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), DATE_CREATED);
        String value = dom.resolve(key.toString());
        if (value != null && (date = formatter.parse(value, pos = new ParsePosition(0))) != null) {
            this.setCreated(date);
        }
        key.replace(PROFILE_PATH.length(), key.length(), DATE_LAST_MODIFIED);
        value = dom.resolve(key.toString());
        if (value != null && (date = formatter.parse(value, pos = new ParsePosition(0))) != null) {
            this.setLastModified(date);
        }
        key.replace(PROFILE_PATH.length(), key.length(), LOCATION);
        this.setLocation(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), ALLOW_OVERRIDE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setAllowOverride(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), BASE_PROFILE_ID);
        this.setBaseProfileID(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), WML_SCRIPT_VERSION);
        this.setWmlScriptVersion(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), VIDEO_INPUT_ENCODER);
        this.setVideoInputEncoder(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), FRAMES_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setFramesCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), JAVA_SCRIPT_VERSION);
        this.setJavaScriptVersion(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), WML_SCRIPT_LIBRARIES);
        this.setWmlScriptLibraries(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), KEYBOARD);
        this.setKeyboard(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), BROWSER_NAME);
        this.setBrowserName(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), IMAGE_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setImageCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), ACCEPT_DOWNLOADABLE_SOFTWARE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setAcceptDownloadableSoftware(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), VOICE_INPUT_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setVoiceInputCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), AUDIO_INPUT_ENCODER);
        this.setAudioInputEncoder(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), MEXE_CLASSMARK);
        this.setMexeClassmark(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), WAP_PUSH_MSG_SIZE);
        value = dom.resolve(key.toString());
        if (value != null) {
            try {
                this.setWapPushMsgSize(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        key.replace(PROFILE_PATH.length(), key.length(), VENDOR);
        this.setVendor(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), MODEL);
        this.setModel(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), BROWSER_VERSION);
        this.setBrowserVersion(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), RECIPIENT_APP_AGENT);
        this.setRecipientAppAgent(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), CCPP_ACCEPT_LANGUAGE);
        this.setCcppAcceptLanguage(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), DOWNLOADABLE_BROWSER_APPS);
        this.setDownloadableBrowserApps(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), SUPPORTED_BEARERS);
        this.setSupportedBearers(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), STANDARD_FONT_PROPORTIONAL);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setStandardFontProportional(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), CPU);
        this.setCPU(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), PDU_SIZE);
        value = dom.resolve(key.toString());
        if (value != null) {
            try {
                this.setPDUSize(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        key.replace(PROFILE_PATH.length(), key.length(), WAP_PUSH_MSG_PRIORITY);
        this.setWapPushMsgPriority(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), PREFERENCE_FOR_FRAMES);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setPreferenceForFrames(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), BITS_PER_PIXEL);
        value = dom.resolve(key.toString());
        if (value != null) {
            try {
                this.setBitsPerPixel(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        key.replace(PROFILE_PATH.length(), key.length(), OUTPUT_CHARSET);
        this.setOutputCharSet(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), CCPP_ACCEPT_CHARSET);
        this.setCcppAcceptCharSet(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), SECURITY_SUPPORT);
        this.setSecuritySupport(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), WTAI_LIBRARIES);
        this.setWtaiLibraries(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), TABLES_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setTablesCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), WML_VERSION);
        this.setWmlVersion(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), TEXT_INPUT_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setTextInputCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), WAP_DEVICE_CLASS);
        this.setWapDeviceClass(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), WAP_VERSION);
        this.setWapVersion(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), OS_VENDOR);
        this.setOSVendor(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), CCPP_ACCEPT_ENCODING);
        this.setCcppAcceptEncoding(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), OS_NAME);
        this.setOSName(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), XHTML_VERSION);
        this.setXhtmlVersion(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), HTML_VERSION);
        this.setHtmlVersion(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), NUMBER_OF_SOFTKEYS);
        value = dom.resolve(key.toString());
        if (value != null) {
            try {
                this.setNumberOfSoftKeys(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        key.replace(PROFILE_PATH.length(), key.length(), MEXE_SPEC);
        this.setMexeSpec(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), SOUND_OUTPUT_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setSoundOutputCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), COLOR_CAPABLE);
        value = dom.resolve(key.toString());
        if (value != null) {
            this.setColorCapable(Boolean.valueOf(value));
        }
        key.replace(PROFILE_PATH.length(), key.length(), XHTML_MODULES);
        this.setXhtmlModules(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), DOWNLOADABLE_SOFTWARE_SUPPORT);
        this.setDownloadableSoftwareSupport(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), OS_VERSION);
        this.setOSVersion(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), JVM_VERSION);
        this.setJVMVersion(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), CCPP_ACCEPT);
        this.setCcppAccept(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), INPUT_CHARSET);
        this.setInputCharSet(this.getElements(dom, key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), POINTING_RESOLUTION);
        this.setPointingResolution(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), SOFTWARE_NUMBER);
        this.setSoftwareNumber(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), SCREEN_SIZE);
        this.setScreenSize(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), SCREEN_SIZE_CHAR);
        this.setScreenSizeChar(dom.resolve(key.toString()));
        key.replace(PROFILE_PATH.length(), key.length(), PIXEL_ASPECT_RATIO);
        this.setPixelAspectRatio(dom.resolve(key.toString()));
        this.getAdditionalAttributes(dom);
    }

    private String[] getElements(XMLHDOM dom, String key) {
        int count = dom.count(key);
        Vector<String> results = new Vector<String>();
        StringBuffer path = new StringBuffer(key);
        int i = 0;
        while (i < count) {
            path.replace(key.length(), path.length(), LEFT_BRACE);
            path.append(i);
            path.append(RIGHT_BRACE);
            String pathValue = dom.resolve(path.toString());
            if (pathValue != null && !pathValue.equals("")) {
                results.addElement(pathValue);
            }
            ++i;
        }
        if (results.size() > 0) {
            String[] strArray = new String[results.size()];
            int j = 0;
            while (j < results.size()) {
                strArray[j] = (String)results.elementAt(j);
                ++j;
            }
            return strArray;
        }
        return null;
    }

    private void getAdditionalAttributes(XMLHDOM dom) {
        StringBuffer origPath = new StringBuffer(PROFILE_PATH);
        origPath.append(FORWARD_SLASH);
        origPath.append(ADDITIONAL_ATTRIBUTES);
        origPath.append(FORWARD_SLASH);
        origPath.append(ATTRIBUTE);
        StringBuffer path = new StringBuffer(origPath.toString());
        int count = dom.count(origPath.toString());
        if (count > 0) {
            this.additionalAttrs_ = new HashMap();
            int i = 0;
            while (i < count) {
                path.replace(origPath.length(), path.length(), LEFT_BRACE);
                path.append(i);
                path.append(RIGHT_BRACE);
                path.append(ATTRIBUTE_NAME);
                String attrName = dom.resolve(path.toString());
                path.replace(path.length() - ATTRIBUTE_NAME.length(), path.length(), ATTRIBUTE_VALUE);
                String attrValue = dom.resolve(path.toString());
                if (attrName != null && !attrName.equals("") && attrValue != null && !attrValue.equals("")) {
                    this.additionalAttrs_.put(attrName, attrValue);
                }
                ++i;
            }
        }
    }

    private void appendElementsXml(StringBuffer buf, String tag, String[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                buf.append(LT);
                buf.append(tag);
                buf.append(GT);
                buf.append(elements[i]);
                buf.append(END_LT);
                buf.append(tag);
                buf.append(GT);
                ++i;
            }
        }
    }

    private void appendAdditionalAttributesXml(StringBuffer buf) {
        if (this.additionalAttrs_ != null && !this.additionalAttrs_.isEmpty()) {
            buf.append(LT);
            buf.append(ADDITIONAL_ATTRIBUTES);
            buf.append(GT);
            Iterator attributes = this.additionalAttrs_.keySet().iterator();
            while (attributes.hasNext()) {
                String name = (String)attributes.next();
                String value = (String)this.additionalAttrs_.get(name);
                buf.append(LT);
                buf.append(ATTRIBUTE);
                buf.append(GT);
                buf.append(LT);
                buf.append(ATTRIBUTE_NAME);
                buf.append(GT);
                buf.append(name);
                buf.append(END_LT);
                buf.append(ATTRIBUTE_NAME);
                buf.append(GT);
                buf.append(LT);
                buf.append(ATTRIBUTE_VALUE);
                buf.append(GT);
                buf.append(value);
                buf.append(END_LT);
                buf.append(ATTRIBUTE_VALUE);
                buf.append(GT);
                buf.append(END_LT);
                buf.append(ATTRIBUTE);
                buf.append(GT);
            }
            buf.append(END_LT);
            buf.append(ADDITIONAL_ATTRIBUTES);
            buf.append(GT);
        }
    }

    private void appendElementXml(StringBuffer buf, String tag, String element) {
        if (element != null) {
            buf.append(LT);
            buf.append(tag);
            buf.append(GT);
            buf.append(element);
            buf.append(END_LT);
            buf.append(tag);
            buf.append(GT);
        }
    }

    public String getXmlHeader() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        this.appendElementString(results, AML_ID, this.getAmlID());
        this.appendElementString(results, XML_ID, this.getXmlID());
        Date dateValue = this.getCreated();
        if (dateValue != null) {
            this.appendElementString(results, DATE_CREATED, formatter.format(dateValue));
        }
        if ((dateValue = this.getLastModified()) != null) {
            this.appendElementString(results, DATE_LAST_MODIFIED, formatter.format(dateValue));
        }
        this.appendElementString(results, LOCATION, this.getLocation());
        this.appendElementString(results, ALLOW_OVERRIDE, "" + this.allowOverride());
        this.appendElementString(results, BASE_PROFILE_ID, this.getBaseProfileID());
        this.appendElementsString(results, WML_SCRIPT_VERSION, this.getWmlScriptVersion());
        this.appendElementsString(results, VIDEO_INPUT_ENCODER, this.getVideoInputEncoder());
        this.appendElementString(results, FRAMES_CAPABLE, "" + this.isFramesCapable());
        this.appendElementString(results, JAVA_SCRIPT_VERSION, this.getJavaScriptVersion());
        this.appendElementsString(results, WML_SCRIPT_LIBRARIES, this.getWmlScriptLibraries());
        this.appendElementString(results, KEYBOARD, this.getKeyboard());
        this.appendElementString(results, BROWSER_NAME, this.getBrowserName());
        this.appendElementString(results, IMAGE_CAPABLE, "" + this.isImageCapable());
        this.appendElementString(results, ACCEPT_DOWNLOADABLE_SOFTWARE, "" + this.acceptDownloadableSoftware());
        this.appendElementString(results, VOICE_INPUT_CAPABLE, "" + this.isVoiceInputCapable());
        this.appendElementsString(results, AUDIO_INPUT_ENCODER, this.getAudioInputEncoder());
        this.appendElementString(results, MEXE_CLASSMARK, this.getMexeClassmark());
        int intValue = this.getWapPushMsgSize();
        if (intValue >= 0) {
            this.appendElementString(results, WAP_PUSH_MSG_SIZE, Integer.toString(intValue));
        }
        this.appendElementString(results, VENDOR, this.getVendor());
        this.appendElementString(results, MODEL, this.getModel());
        this.appendElementString(results, BROWSER_VERSION, this.getBrowserVersion());
        this.appendElementString(results, RECIPIENT_APP_AGENT, this.getRecipientAppAgent());
        this.appendElementsString(results, CCPP_ACCEPT_LANGUAGE, this.getCcppAcceptLanguage());
        this.appendElementsString(results, DOWNLOADABLE_BROWSER_APPS, this.getDownloadableBrowserApps());
        this.appendElementsString(results, SUPPORTED_BEARERS, this.getSupportedBearers());
        this.appendElementString(results, STANDARD_FONT_PROPORTIONAL, "" + this.isStandardFontProportional());
        this.appendElementString(results, CPU, this.getCPU());
        intValue = this.getPDUSize();
        if (intValue >= 0) {
            this.appendElementString(results, PDU_SIZE, Integer.toString(intValue));
        }
        this.appendElementString(results, WAP_PUSH_MSG_PRIORITY, this.getWapPushMsgPriority());
        this.appendElementString(results, PREFERENCE_FOR_FRAMES, "" + this.hasPreferenceForFrames());
        intValue = this.getBitsPerPixel();
        if (intValue >= 0) {
            this.appendElementString(results, BITS_PER_PIXEL, Integer.toString(intValue));
        }
        this.appendElementsString(results, OUTPUT_CHARSET, this.getOutputCharSet());
        this.appendElementsString(results, CCPP_ACCEPT_CHARSET, this.getOutputCharSet());
        this.appendElementString(results, SECURITY_SUPPORT, this.getSecuritySupport());
        this.appendElementsString(results, WTAI_LIBRARIES, this.getWtaiLibraries());
        this.appendElementString(results, TABLES_CAPABLE, "" + this.isTablesCapable());
        this.appendElementsString(results, WML_VERSION, this.getWmlVersion());
        this.appendElementString(results, TEXT_INPUT_CAPABLE, "" + this.isTextInputCapable());
        this.appendElementString(results, WAP_DEVICE_CLASS, this.getWapDeviceClass());
        this.appendElementString(results, WAP_VERSION, this.getWapVersion());
        this.appendElementString(results, OS_VENDOR, this.getOSVendor());
        this.appendElementsString(results, CCPP_ACCEPT_ENCODING, this.getCcppAcceptEncoding());
        this.appendElementString(results, OS_NAME, this.getOSName());
        this.appendElementString(results, XHTML_VERSION, this.getXhtmlVersion());
        this.appendElementString(results, HTML_VERSION, this.getHtmlVersion());
        intValue = this.getNumberOfSoftKeys();
        if (intValue >= 0) {
            this.appendElementString(results, NUMBER_OF_SOFTKEYS, Integer.toString(intValue));
        }
        this.appendElementString(results, MEXE_SPEC, this.getMexeSpec());
        this.appendElementString(results, SOUND_OUTPUT_CAPABLE, "" + this.isSoundOutputCapable());
        this.appendElementString(results, COLOR_CAPABLE, "" + this.isColorCapable());
        this.appendElementsString(results, XHTML_MODULES, this.getXhtmlModules());
        this.appendElementsString(results, DOWNLOADABLE_SOFTWARE_SUPPORT, this.getDownloadableSoftwareSupport());
        this.appendElementString(results, OS_VERSION, this.getOSVersion());
        this.appendElementsString(results, JVM_VERSION, this.getJVMVersion());
        this.appendElementsString(results, CCPP_ACCEPT, this.getCcppAccept());
        this.appendElementsString(results, INPUT_CHARSET, this.getInputCharSet());
        this.appendElementString(results, POINTING_RESOLUTION, this.getPointingResolution());
        this.appendElementString(results, SOFTWARE_NUMBER, this.getSoftwareNumber());
        this.appendElementString(results, SCREEN_SIZE, this.getScreenSize());
        this.appendElementString(results, SCREEN_SIZE_CHAR, this.getScreenSizeChar());
        this.appendElementString(results, PIXEL_ASPECT_RATIO, this.getPixelAspectRatio());
        results.append(this.additionalAttrs_);
        results.append(END_LT);
        results.append(PROFILE_TAG);
        results.append(GT);
        return results.toString();
    }

    private void appendElementsString(StringBuffer buf, String tag, String[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                buf.append(tag);
                buf.append(EQUAL);
                buf.append(elements[i]);
                buf.append(NEW_LINE);
                ++i;
            }
        }
    }

    private void appendElementString(StringBuffer buf, String tag, String element) {
        if (element != null) {
            buf.append(tag);
            buf.append(EQUAL);
            buf.append(element);
            buf.append(NEW_LINE);
        }
    }
}

