/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.parsing;

import com.aligo.parsing.XMLAttributes;
import com.aligo.parsing.XMLName;

public class XMLElement {
    int sindex;
    int eindex;
    XMLName name;
    XMLAttributes attrs;
    String data;
    boolean processingInstruction;

    public XMLElement(XMLName xname, XMLAttributes atts) {
        this.name = xname;
        this.attrs = atts;
        this.data = null;
        this.processingInstruction = false;
    }

    public void setStartingCharIndex(int idx) {
        this.sindex = idx;
    }

    public void setEndingCharIndex(int idx) {
        this.eindex = idx;
    }

    public int getStartingCharIndex() {
        return this.sindex;
    }

    public int getEndingCharIndex() {
        return this.eindex;
    }

    public void setProcessingInstruction(boolean flg) {
        this.processingInstruction = flg;
    }

    public boolean isProcessingInstruction() {
        return this.processingInstruction;
    }

    public void setData(String d) {
        this.data = d;
    }

    public void setCData(String cd) {
        this.attrs.setAttribute("CDATA", cd);
    }

    public String getData() {
        return this.data;
    }

    public String getAttribute(String name) {
        if (this.attrs != null) {
            return this.attrs.getAttribute(name);
        }
        return null;
    }

    public XMLAttributes getAttributes() {
        return this.attrs;
    }

    public String getName() {
        return this.name.toString();
    }

    public boolean equals(XMLElement el) {
        boolean ret = this.name.equals(el.name);
        return ret;
    }

    public String toString() {
        if (this.attrs != null) {
            if (this.data != null) {
                return "<" + this.name.toString() + " " + this.attrs.toString() + ">" + this.data + "</" + this.name.toString() + ">";
            }
            if (this.isProcessingInstruction()) {
                return "<?" + this.name.toString() + " " + this.attrs.toString() + "?>";
            }
            return "<" + this.name.toString() + " " + this.attrs.toString() + "/>";
        }
        if (this.data == null) {
            if (this.isProcessingInstruction()) {
                return "<?" + this.name.toString() + "?>";
            }
            return "<" + this.name.toString() + "/>";
        }
        return "<" + this.name.toString() + ">" + this.data + "</" + this.name.toString() + ">";
    }

    public String toStringElementOpen() {
        if (this.attrs != null) {
            if (this.data != null) {
                return "<" + this.name.toString() + this.attrs.toString() + ">" + this.data;
            }
            if (this.isProcessingInstruction()) {
                return "<?" + this.name.toString() + this.attrs.toString() + "?>";
            }
            return "<" + this.name.toString() + this.attrs.toString() + ">";
        }
        if (this.data == null) {
            if (this.isProcessingInstruction()) {
                return "<?" + this.name.toString() + "?>";
            }
            return "<" + this.name.toString() + "/>";
        }
        return "<" + this.name.toString() + ">" + this.data;
    }

    public String toStringElementClose() {
        if (!this.isProcessingInstruction()) {
            return "</" + this.name.toString() + ">";
        }
        return "";
    }

    public int length() {
        return this.name.length();
    }

    public void update(XMLElement el) {
        this.data = el.data;
        this.attrs = el.attrs;
    }
}

