/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.parsing;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMParser
implements ErrorHandler {
    DocumentBuilder builder;

    public DOMParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException p) {
            System.out.println("error in getting builder");
        }
        this.builder.setErrorHandler(this);
    }

    public Document parse(String uri) throws Exception {
        return this.builder.parse(uri);
    }

    public Document parse(char[] stream) throws Exception {
        CharArrayReader reader = new CharArrayReader(stream);
        return this.builder.parse(new InputSource(reader));
    }

    public Document parse(File xmlFile) throws Exception {
        FileReader reader = new FileReader(xmlFile);
        return this.builder.parse(new InputSource(reader));
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }
}

