/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.paths;

import com.aligo.modules.xhtml.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.xhtml.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.xhtml.paths.interfaces.AmlPathInterface;
import java.util.Enumeration;
import java.util.Vector;

public class AmlPath
implements AmlPathInterface,
Cloneable {
    Vector oAmlPathContainer;
    int iRealm;
    String oPathIndexString;
    boolean dirtyFlag = false;

    public AmlPath() {
        this.oAmlPathContainer = new Vector();
        this.setRealm(0);
    }

    public AmlPath(Vector pathContainer) {
        this.setAmlPathContainer(pathContainer);
    }

    public void setAmlPathContainer(Vector pathContainer) {
        this.oAmlPathContainer = pathContainer;
    }

    public void addAmlPathComponent(AmlPathComponentInterface component) {
        this.oAmlPathContainer.addElement(component);
    }

    public void addAmlPathComponentAt(AmlPathComponentInterface component, int index) throws AmlPathIndexOutOfBoundsException {
        try {
            this.oAmlPathContainer.insertElementAt(component, index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new AmlPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public Enumeration getAmlPathComponents() {
        return this.oAmlPathContainer.elements();
    }

    public int getNumberAmlPathComponents() {
        return this.oAmlPathContainer.size();
    }

    public AmlPathComponentInterface getAmlPathComponentAt(int i) throws AmlPathIndexOutOfBoundsException {
        try {
            return (AmlPathComponentInterface)this.oAmlPathContainer.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new AmlPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public AmlPathComponentInterface getFirstAmlPathComponent() throws AmlPathIndexOutOfBoundsException {
        return this.getAmlPathComponentAt(0);
    }

    public AmlPathInterface getNextAmlPath() {
        AmlPath remainingAmlPath = new AmlPath();
        int numberElements = this.getNumberAmlPathComponents();
        int i = 1;
        while (i < numberElements) {
            AmlPathComponentInterface component = (AmlPathComponentInterface)this.oAmlPathContainer.elementAt(i);
            remainingAmlPath.addAmlPathComponent(component);
            ++i;
        }
        return remainingAmlPath;
    }

    public boolean hasMoreAmlPathComponents() {
        boolean moreComponents = false;
        int numberElements = this.oAmlPathContainer.size();
        if (numberElements > 0) {
            moreComponents = true;
        }
        return moreComponents;
    }

    public AmlPathInterface newPath() {
        return new AmlPath();
    }

    public AmlPathInterface duplicate() {
        AmlPathInterface amlPath = null;
        try {
            amlPath = (AmlPathInterface)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return amlPath;
    }

    public boolean equals(AmlPathInterface amlPath) {
        boolean isEqual = false;
        try {
            int numberGPathComponents = amlPath.getNumberAmlPathComponents();
            int numberPathComponents = this.getNumberAmlPathComponents();
            if (numberPathComponents == numberGPathComponents) {
                boolean noMatch = false;
                int i = 0;
                while (i < numberPathComponents && !noMatch) {
                    AmlPathComponentInterface amlGPathComponent;
                    AmlPathComponentInterface amlPathComponent = this.getAmlPathComponentAt(i);
                    if (!amlPathComponent.equals(amlGPathComponent = amlPath.getAmlPathComponentAt(i))) {
                        noMatch = true;
                    }
                    ++i;
                }
                if (!noMatch) {
                    isEqual = true;
                }
            }
        }
        catch (AmlPathIndexOutOfBoundsException amlPathIndexOutOfBoundsException) {
            // empty catch block
        }
        return isEqual;
    }

    public String toString() {
        if (this.dirtyFlag) {
            StringBuffer string = new StringBuffer(this.getCanonicalPath());
            string.append("@");
            string.append(this.iRealm);
            this.oPathIndexString = string.toString();
            this.dirtyFlag = false;
        }
        return this.oPathIndexString;
    }

    public void setRealm(int realm) {
        this.iRealm = realm;
        this.dirtyFlag = true;
    }

    public int getRealm() {
        return this.iRealm;
    }

    public String getCanonicalPath() {
        StringBuffer canonicalPath = new StringBuffer("");
        try {
            int numberPathComponents = this.getNumberAmlPathComponents();
            int i = 0;
            while (i < numberPathComponents) {
                AmlPathComponentInterface amlPathComponent = this.getAmlPathComponentAt(i);
                canonicalPath.append("/");
                canonicalPath.append(amlPathComponent.toString());
                ++i;
            }
        }
        catch (AmlPathIndexOutOfBoundsException amlPathIndexOutOfBoundsException) {
            // empty catch block
        }
        return canonicalPath.toString();
    }
}

