/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.amlhandlets;

import com.aligo.axml.AxmlBr;
import com.aligo.axml.AxmlImage;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.xhtml.amlhandlets.events.XHtmlAmlGotTextHandletEvent;
import com.aligo.modules.xhtml.amlhandlets.events.XHtmlAmlTextHandletEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetXHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.exceptions.XHtmlAmlInsufficientMemoryException;
import com.aligo.modules.xhtml.handlets.XHtmlAmlStylePathHandlet;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.xhtml.XHtmlContainer;
import com.aligo.xhtml.exceptions.XHtmlElementNotFoundException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Vector;

public class XHtmlAmlTextHandlet
extends XHtmlAmlStylePathHandlet {
    protected AxmlElement oCurrentAxmlElement;
    protected XHtmlElement xhtmlElement;
    protected int iChildIndex = 0;

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlTextHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlStylePathRelevance() {
        long currentXHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlTextHandletEvent) {
            currentXHtmlAmlStylePathRelevance = 20L;
        }
        return currentXHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean flag = true;
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof XHtmlAmlTextHandletEvent) {
            try {
                XHtmlAmlTextHandletEvent xhtmlAmlTextHandletEvent = (XHtmlAmlTextHandletEvent)this.oCurrentEvent;
                XHtmlElement xhtmlTextElement = xhtmlAmlTextHandletEvent.getXHtmlTextElement();
                XHtmlElement textParentElement = xhtmlTextElement.getXHtmlParentElement();
                XHtmlElement textParentsParentElement = null;
                int position = -1;
                AmlPathInterface currentPath = xhtmlAmlTextHandletEvent.getAmlPath();
                AmlPathInterface parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentPath);
                AmlPathInterface previousPath = this.getPreviousPath(currentPath);
                if (previousPath != null) {
                    XHtmlAmlGetXHtmlChildContainerStateHandlerEvent xhtmlAmlGetXHtmlChildContainerStateHandlerEvent = new XHtmlAmlGetXHtmlChildContainerStateHandlerEvent(parentPath);
                    this.oHandlerManager.postEventNow(xhtmlAmlGetXHtmlChildContainerStateHandlerEvent);
                    textParentsParentElement = xhtmlAmlGetXHtmlChildContainerStateHandlerEvent.getXHtmlElement();
                    this.oHandlerLogger.logDebug("text parent" + textParentElement + " its parent " + textParentsParentElement);
                    if (textParentsParentElement != null) {
                        try {
                            position = textParentsParentElement.xhtmlElementIndex(textParentElement);
                        }
                        catch (XHtmlElementNotFoundException we) {
                            // empty catch block
                        }
                    }
                }
                if (previousPath != null) {
                    XHtmlElement previousTextContainerElement;
                    AxmlElement previousElement = AmlPathUtils.getAmlElement(this.oHandlerManager, previousPath);
                    this.oHandlerLogger.logDebug("position = " + position);
                    if (position > 0 && (previousTextContainerElement = textParentsParentElement.xhtmlElementAt(position - 1)) instanceof XHtmlContainer && previousTextContainerElement.getNumberElements() > 0 && (previousElement instanceof AxmlText || previousElement instanceof AxmlImage || previousElement instanceof AxmlBr)) {
                        this.oHandlerLogger.logDebug("posting got text");
                        XHtmlAmlGotTextHandletEvent xhtmlAmlGotTextHandletEvent = new XHtmlAmlGotTextHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, xhtmlAmlTextHandletEvent.getXHtmlElement(), xhtmlTextElement, previousTextContainerElement);
                        this.oHandlerManager.postEvent(xhtmlAmlGotTextHandletEvent);
                        flag = false;
                    }
                }
                if (flag) {
                    XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, xhtmlTextElement, xhtmlAmlTextHandletEvent.getXHtmlElement());
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof XHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                XHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new XHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else if (flag) {
                XHtmlAmlAddElementHandledHandletEvent xhtmlAddElementHandledEvent = new XHtmlAmlAddElementHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEvent(xhtmlAddElementHandledEvent);
            }
        }
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath) throws HandlerError {
        AmlPathInterface previousPath = null;
        int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        XHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new XHtmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
        this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
        int previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }
}

