/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.amlhandlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.xhtml.errors.XHtmlAmlHandlerError;
import com.aligo.modules.xhtml.events.XHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.xhtml.exceptions.XHtmlAmlInsufficientMemoryException;
import com.aligo.modules.xhtml.handlets.XHtmlAmlStylePathHandlet;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddXmlXHtmlAttributeHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.util.xhtml.TextUtils;
import com.aligo.xhtml.XHtmlPCData;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlAmlTextAttributeHandlet
extends XHtmlAmlStylePathHandlet {
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlStylePathRelevance() {
        long currentXHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            XHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (XHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                AmlPathInterface currentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
                XHtmlElement xhtmlElement = XHtmlAmlElementUtils.getXHtmlElement(this.oHandlerManager, currentAmlPath, styleXmlElement);
                String xhtmlName = addAttributeEvent.getXHtmlName();
                if (currentAmlElement instanceof AxmlText && xhtmlElement instanceof XHtmlPCData && xhtmlName.equals("text")) {
                    currentXHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentXHtmlAmlStylePathRelevance;
    }

    public long xhtmlAmlRelevance() {
        long currentXHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentXHtmlAmlRelevance = 30L;
            }
        } else {
            currentXHtmlAmlRelevance = this.oCurrentEvent instanceof XHtmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof XHtmlAmlResetTextStateHandlerEvent ? 20L : super.xhtmlAmlRelevance());
        }
        return currentXHtmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof XHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            XHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (XHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            boolean memoryError = false;
            try {
                XHtmlAmlXmlXHtmlElementHandletEvent getXHtmlElementEvent = new XHtmlAmlXmlXHtmlElementHandletEvent("Get", this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEventNow(getXHtmlElementEvent);
                XHtmlElement xhtmlElement = getXHtmlElementEvent.getXHtmlElement();
                String xhtmlName = addAttributeEvent.getXHtmlName();
                String xhtmlValue = addAttributeEvent.getXHtmlValue();
                if (xhtmlValue != null) {
                    String value = "";
                    AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    if (currentAmlElement instanceof AxmlText && xhtmlElement instanceof XHtmlPCData && xhtmlName.equals("text")) {
                        int lastIndex;
                        Integer iLastIndex;
                        String pathString = this.oCurrentAmlPath.getCanonicalPath();
                        Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                        if (strContainer == null) {
                            strContainer = new Vector();
                            String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                            boolean encode = true;
                            if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                encode = false;
                            }
                            TextUtils.prepareOutput(xhtmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                            this.oOutputContainers.put(pathString, strContainer);
                        }
                        if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                            lastIndex = 0;
                            iLastIndex = new Integer(lastIndex);
                            this.oTextIndices.put(pathString, iLastIndex);
                        } else {
                            lastIndex = iLastIndex;
                        }
                        XHtmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new XHtmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                        this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                        long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                        int numberElements = strContainer.size();
                        long memory = 0L;
                        boolean done = false;
                        boolean detach = false;
                        int i = lastIndex;
                        while (i < numberElements && !done) {
                            String element = (String)strContainer.elementAt(i);
                            long elementMemory = element.getBytes().length;
                            if ((memory += elementMemory) > remainingMemory) {
                                done = true;
                                if (i == lastIndex) {
                                    detach = true;
                                }
                                lastIndex = i;
                            } else {
                                value = value + element;
                            }
                            ++i;
                        }
                        this.oDetachFlags.put(pathString, new Boolean(detach));
                        if (done) {
                            this.oTextIndices.put(pathString, new Integer(lastIndex));
                            memoryError = true;
                        } else {
                            this.clearState(this.oCurrentAmlPath);
                        }
                        XHtmlAmlAddXmlXHtmlAttributeHandletEvent addXmlXHtmlAttributeEvent = new XHtmlAmlAddXmlXHtmlAttributeHandletEvent(this.oCurrentAmlPath, xhtmlElement, xhtmlName, value);
                        this.oHandlerManager.postEventNow(addXmlXHtmlAttributeEvent);
                    }
                }
                if (memoryError) {
                    throw new HandlerError(new XHtmlAmlInsufficientMemoryException());
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            HandlerError he = (HandlerError)ex;
            Exception eex = he.getException();
            if (eex instanceof XHtmlAmlInsufficientMemoryException) {
                throw he;
            }
        } else {
            this.oHandlerLogger.logError(ex);
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof XHtmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof XHtmlAmlShouldDetachTextMemoryHandlerEvent) {
                XHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (XHtmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof XHtmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((XHtmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new XHtmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

