/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.xhtml.events.XHtmlAmlGetStyleIDStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.exceptions.XHtmlAmlInsufficientMemoryException;
import com.aligo.modules.xhtml.handlets.XHtmlAmlStylePathHandlet;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.xhtml.XHtmlContainer;
import com.aligo.xhtml.XHtmlInput;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Vector;

public class XHtmlAmlSeparatePidFromFormsUrlHandlet
extends XHtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    XHtmlElement xhtmlElement;
    boolean style_id = false;
    private static final String HIDDEN = "hidden";
    private static final String URL = "url";
    private static final String QUESTION_MARK = "?";
    private static final String EQUAL_TO = "=";
    private static final String ACTION = "action";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlStylePathRelevance() {
        long currentXHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlAddAttributeHandletEvent) {
            XHtmlAmlAddAttributeHandletEvent addAttributeEvent = (XHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                XmlStyleID xmlStyleID;
                String name;
                AligoEventInterface event = this.oCurrentEvent;
                XHtmlAmlXmlXHtmlElementHandletEvent getXHtmlElementEvent = new XHtmlAmlXmlXHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getXHtmlElementEvent);
                this.oCurrentEvent = event;
                this.xhtmlElement = getXHtmlElementEvent.getXHtmlElement();
                XHtmlAmlGetStyleIDStateHandlerEvent getStyleIDStateEvent = new XHtmlAmlGetStyleIDStateHandlerEvent(addAttributeEvent.getAmlPath());
                this.oHandlerManager.postEventNow(getStyleIDStateEvent);
                StyleIDInterface styleID = getStyleIDStateEvent.getStyleID();
                if (styleID instanceof XmlStyleID && (name = (xmlStyleID = (XmlStyleID)styleID).getName()) != null && name.equals("XHtml_2")) {
                    this.style_id = true;
                }
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.xhtmlElement instanceof XHtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(HIDDEN)) {
                        currentXHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentXHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof XHtmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.xhtmlElement instanceof XHtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    Object previousXHtmlElement = null;
                    AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    String amlAttributeValue = axmlElement.getAxmlAttributeValue(URL);
                    if (amlAttributeName.toLowerCase().equals(HIDDEN) && amlAttributeValue.indexOf(QUESTION_MARK) != -1) {
                        int position = amlAttributeValue.indexOf(QUESTION_MARK);
                        String formUrl = amlAttributeValue.substring(0, position);
                        String sessionIdInfo = amlAttributeValue.substring(position + 1);
                        if (sessionIdInfo.indexOf(EQUAL_TO) != -1) {
                            int eqPosition = sessionIdInfo.indexOf(EQUAL_TO);
                            XHtmlElement topElement = XHtmlAmlElementUtils.getTopXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                            XHtmlElement containerElement = topElement.xhtmlElementAt(0);
                            XHtmlElement formElement = containerElement.xhtmlElementAt(0);
                            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, formElement, ACTION, formUrl);
                            XHtmlInput input = new XHtmlInput();
                            input.addXHtmlAttribute(TYPE, HIDDEN);
                            input.addXHtmlAttribute(NAME, sessionIdInfo.substring(0, eqPosition));
                            input.addXHtmlAttribute(VALUE, sessionIdInfo.substring(eqPosition + 1));
                            XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, formElement, input);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof XHtmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    XHtmlAmlElementUtils.removeXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.xhtmlElement.getXHtmlParentElement(), this.xhtmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                XHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new XHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                XHtmlAmlAddAttributeHandledHandletEvent xhtmlAmlAddAttributeHandledHandletEvent = new XHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(xhtmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

