/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.xhtml.XHtmlAmlPathHandler;
import com.aligo.modules.xhtml.errors.XHtmlAmlHandlerError;
import com.aligo.modules.xhtml.events.XHtmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCreateNextElementHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetControlMenuParentContainerHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.xhtml.exceptions.XHtmlAmlInsufficientMemoryException;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.modules.xhtml.util.exceptions.XHtmlAmlGetRootElementFailedException;
import com.aligo.xhtml.XHtmlContainer;
import com.aligo.xhtml.XHtmlDiv;
import com.aligo.xhtml.XHtmlElementCollection;
import com.aligo.xhtml.exceptions.XHtmlAttributeCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementIndexOutOfBoundsException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlAmlControlMenuHandler
extends XHtmlAmlPathHandler {
    private static final String SPACE = "&nbsp;";
    private static final String ERICSSON = "Ericsson";
    private static final String T68 = "T68";
    private Hashtable oControlMenuPresentTable = new Hashtable();
    private Hashtable oControlMenuContainerTable = new Hashtable();
    private Hashtable oCMTBNeedCopyTable = new Hashtable();
    private boolean bNoHandleCNEHandlerEvent = false;
    private Hashtable oNumberCMAddedTable = new Hashtable();

    private boolean isControlMenuPresent(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bPresent;
        boolean present = false;
        if (currentAmlPath != null && (bPresent = (Boolean)this.oControlMenuPresentTable.get(pathString = currentAmlPath.toString())) != null) {
            present = bPresent;
        }
        return present;
    }

    private void setControlMenuPresent(AmlPathInterface currentAmlPath, boolean present) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuPresentTable.put(pathString, new Boolean(present));
    }

    private XHtmlElement getControlMenuContainer(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        XHtmlElement xhtmlElement = (XHtmlElement)this.oControlMenuContainerTable.get(pathString);
        return xhtmlElement;
    }

    private void setControlMenuContainer(AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuContainerTable.put(pathString, xhtmlElement);
    }

    private boolean doesCMTBNeedCopy(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bNeedCopy;
        boolean needCopy = false;
        if (currentAmlPath != null && (bNeedCopy = (Boolean)this.oCMTBNeedCopyTable.get(pathString = currentAmlPath.toString())) != null) {
            needCopy = bNeedCopy;
        }
        return needCopy;
    }

    private void setCMTBNeedCopy(AmlPathInterface currentAmlPath, boolean needCopy) {
        String pathString = currentAmlPath.toString();
        this.oCMTBNeedCopyTable.put(pathString, new Boolean(needCopy));
    }

    private int getNumberCMAdded(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        int numAdded = 0;
        Integer inNumAdded = (Integer)this.oNumberCMAddedTable.get(pathString);
        if (inNumAdded != null) {
            numAdded = inNumAdded;
        }
        return numAdded;
    }

    private void incNumberCMAdded(AmlPathInterface currentAmlPath) {
        int numAdded = this.getNumberCMAdded(currentAmlPath);
        String pathString = currentAmlPath.toString();
        this.oNumberCMAddedTable.put(pathString, new Integer(++numAdded));
    }

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddControlMenuElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlGetControlMenuParentContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlCreateNextElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlIsPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlPathRelevance() {
        long currentXHtmlAmlPathRelevance;
        block21: {
            currentXHtmlAmlPathRelevance = 0L;
            if (this.oCurrentEvent instanceof XHtmlAmlAddChildContainerHandlerEvent) {
                try {
                    AmlPathInterface parentAmlPath;
                    AxmlElement parentAmlElement;
                    AmlPathInterface currentAmlPath = ((XHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) instanceof AxmlPage) {
                        currentXHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof XHtmlAmlControlMenuOffsetHandlerEvent) {
                currentXHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof XHtmlAmlAddControlMenuElementHandlerEvent) {
                currentXHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof XHtmlAmlGetControlMenuParentContainerHandlerEvent) {
                currentXHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof XHtmlAmlCreateNextElementHandlerEvent) {
                try {
                    if (!this.bNoHandleCNEHandlerEvent) {
                        int numberCM;
                        AmlPathInterface parentAmlPath;
                        int numCMAdded;
                        XHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (XHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
                        AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                        if (amlElement instanceof AxmlControlMenu && (numCMAdded = this.getNumberCMAdded(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) == (numberCM = this.getTotalControlMenus(parentAmlPath)) && this.doesCMTBNeedCopy(parentAmlPath)) {
                            currentXHtmlAmlPathRelevance = 30L;
                        }
                        break block21;
                    }
                    this.bNoHandleCNEHandlerEvent = false;
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof XHtmlAmlIsPersistentHandlerEvent) {
                try {
                    XHtmlAmlIsPersistentHandlerEvent isPersistentElementEvent = (XHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent;
                    AmlPathInterface currentAmlPath = isPersistentElementEvent.getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu) {
                        currentXHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return currentXHtmlAmlPathRelevance;
    }

    private int getTotalControlMenus(AmlPathInterface parentAmlPath) throws XHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        int numberMenus = 0;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
        int numberChildren = amlElement.getNumberElements();
        int i = 0;
        while (i < numberChildren) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws XHtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        AmlPathInterface parentAmlPath;
        AxmlElement amlElement;
        int numberChildren;
        int numberMenus = 0;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        if (childIndex > (numberChildren = (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))).getNumberElements()) - 1) {
            childIndex = numberChildren - 1;
        }
        int i = 0;
        while (i < childIndex) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private void createControlMenuContainer(AmlPathInterface amlPath, XHtmlElement xhtmlElement) throws HandlerError {
        XHtmlElement controlMenuContainer = null;
        boolean oneElement = false;
        if (xhtmlElement instanceof XHtmlElementCollection) {
            int numberElements = xhtmlElement.getNumberElements();
            if (numberElements > 1) {
                controlMenuContainer = new XHtmlElementCollection();
                int i = 0;
                while (i < numberElements) {
                    try {
                        XHtmlElement cmParentContainer = xhtmlElement.xhtmlElementAt(i);
                        XHtmlElement tCMContainer = this.createCMContainerElement(amlPath, cmParentContainer);
                        controlMenuContainer.addXHtmlElement(tCMContainer);
                    }
                    catch (XHtmlElementIndexOutOfBoundsException je) {
                    }
                    catch (XHtmlElementCannotBeAddedException je) {
                        // empty catch block
                    }
                    ++i;
                }
                this.setCMTBNeedCopy(amlPath, true);
            } else {
                try {
                    xhtmlElement = xhtmlElement.xhtmlElementAt(0);
                    oneElement = true;
                }
                catch (XHtmlElementIndexOutOfBoundsException je) {}
            }
        } else {
            oneElement = true;
        }
        if (oneElement) {
            controlMenuContainer = this.createCMContainerElement(amlPath, xhtmlElement);
        }
        this.setControlMenuPresent(amlPath, true);
        this.setControlMenuContainer(amlPath, controlMenuContainer);
    }

    private XHtmlElement createCMContainerElement(AmlPathInterface amlPath, XHtmlElement xhtmlElement) throws HandlerError {
        XHtmlDiv xhtmlDiv = new XHtmlDiv();
        try {
            XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, amlPath, xhtmlElement, xhtmlDiv, 0);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        return xhtmlDiv;
    }

    private XHtmlElement composeSpace() {
        XHtmlContainer xhtmlContainer = new XHtmlContainer();
        try {
            xhtmlContainer.addXHtmlAttribute("text", SPACE);
        }
        catch (XHtmlAttributeCannotBeAddedException xHtmlAttributeCannotBeAddedException) {
            // empty catch block
        }
        return xhtmlContainer;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof XHtmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof XHtmlAmlCreateNextElementHandlerEvent) {
            XHtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (XHtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
            boolean memoryError = false;
            try {
                int numberElements;
                XHtmlElement cmContainer;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                if (this.doesCMTBNeedCopy(parentAmlPath) && (cmContainer = this.getControlMenuContainer(parentAmlPath)) instanceof XHtmlElementCollection && (numberElements = cmContainer.getNumberElements()) > 1) {
                    XHtmlElement filledECMContainer = cmContainer.xhtmlElementAt(0);
                    int i = 1;
                    while (i < numberElements) {
                        XHtmlElement eCMContainer = cmContainer.xhtmlElementAt(i);
                        int numberChildren = filledECMContainer.getNumberElements();
                        int j = 0;
                        while (j < numberChildren) {
                            XHtmlElement childXHtmlElement = filledECMContainer.xhtmlElementAt(j);
                            XHtmlElement clChildXHtmlElement = childXHtmlElement.cloneXHtmlElement();
                            XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, parentAmlPath, eCMContainer, clChildXHtmlElement);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof XHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.bNoHandleCNEHandlerEvent = true;
            if (memoryError) {
                XHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new XHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                XHtmlAmlCreateNextElementHandlerEvent postAgainCNEEvent = new XHtmlAmlCreateNextElementHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(postAgainCNEEvent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof XHtmlAmlAddChildContainerHandlerEvent) {
            try {
                int numberElements;
                XHtmlAmlAddChildContainerHandlerEvent xhtmlAmlAddChildContainerHandlerEvent = (XHtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
                XHtmlElement childXHtmlElement = xhtmlAmlAddChildContainerHandlerEvent.getXHtmlElement();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (!(amlElement instanceof AxmlControlMenu)) return;
                boolean firstControlMenu = false;
                if (!this.isControlMenuPresent(parentAmlPath)) {
                    XHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new XHtmlAmlGetControlMenuParentContainerHandlerEvent(this.oCurrentAmlPath);
                    this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                    XHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getXHtmlElement();
                    this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                    firstControlMenu = true;
                }
                XHtmlElement xhtmlElement = this.getControlMenuContainer(parentAmlPath);
                int childIndex = xhtmlAmlAddChildContainerHandlerEvent.getChildIndex();
                if (xhtmlElement instanceof XHtmlElementCollection && (numberElements = xhtmlElement.getNumberElements()) >= 1) {
                    xhtmlElement = xhtmlElement.xhtmlElementAt(0);
                }
                this.incNumberCMAdded(parentAmlPath);
                this.addCMElement(parentAmlPath, firstControlMenu, xhtmlElement, childXHtmlElement, childIndex);
                return;
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof XHtmlAmlInsufficientMemoryException)) return;
                throw he;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (this.oCurrentEvent instanceof XHtmlAmlControlMenuOffsetHandlerEvent) {
            XHtmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (XHtmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int childIndex = controlMenuOffsetEvent.getChildIndex();
            int offsetChildIndex = -1;
            try {
                AmlPathInterface parentAmlPath;
                if (this.oCurrentAmlPath != null && this.isControlMenuPresent(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath))) {
                    int numberControlMenus = this.getNumberControlMenus(this.oCurrentAmlPath);
                    offsetChildIndex = childIndex - numberControlMenus;
                }
            }
            catch (Exception ex) {
                offsetChildIndex = 0;
            }
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
            return;
        }
        if (this.oCurrentEvent instanceof XHtmlAmlAddControlMenuElementHandlerEvent) {
            XHtmlElement xhtmlElement;
            XHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = (XHtmlAmlAddControlMenuElementHandlerEvent)this.oCurrentEvent;
            XHtmlElement childXHtmlElement = addControlMenuElementEvent.getXHtmlElement();
            AmlPathInterface parentAmlPath = this.oCurrentAmlPath;
            boolean firstControlMenu = false;
            if (!this.isControlMenuPresent(parentAmlPath)) {
                XHtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new XHtmlAmlGetControlMenuParentContainerHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                XHtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getXHtmlElement();
                this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                firstControlMenu = true;
            }
            if ((xhtmlElement = this.getControlMenuContainer(parentAmlPath)) instanceof XHtmlElementCollection) {
                int numberElements = xhtmlElement.getNumberElements();
                int i = 0;
                while (i < numberElements) {
                    try {
                        XHtmlElement containerElement = xhtmlElement.xhtmlElementAt(i);
                        this.addCMNMCElement(parentAmlPath, firstControlMenu, containerElement, childXHtmlElement);
                    }
                    catch (XHtmlElementIndexOutOfBoundsException je) {
                        // empty catch block
                    }
                    ++i;
                }
                return;
            }
            this.addCMNMCElement(parentAmlPath, firstControlMenu, xhtmlElement, childXHtmlElement);
            return;
        }
        if (this.oCurrentEvent instanceof XHtmlAmlGetControlMenuParentContainerHandlerEvent) {
            XHtmlAmlGetControlMenuParentContainerHandlerEvent controlMenuParentContainerEvent = (XHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent;
            XHtmlElement xhtmlElement = null;
            try {
                AmlPathInterface currentAmlPath = ((XHtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                xhtmlElement = XHtmlAmlElementUtils.getChildContainerXHtmlElement(this.oHandlerManager, parentAmlPath);
            }
            catch (HandlerError he) {
                throw he;
            }
            catch (Exception ex) {
                throw new XHtmlAmlHandlerError(ex);
            }
            controlMenuParentContainerEvent.setXHtmlElement(xhtmlElement);
            return;
        }
        if (!(this.oCurrentEvent instanceof XHtmlAmlIsPersistentHandlerEvent)) return;
        ((XHtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent).setPersistent(true);
    }

    private void addCMElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, XHtmlElement xhtmlElement, XHtmlElement childXHtmlElement, int childIndex) throws HandlerError {
        if (!firstControlMenu && !this.isEricssonT68()) {
            XHtmlElement spaceElement = this.composeSpace();
            XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, parentAmlPath, xhtmlElement, spaceElement, childIndex);
            if (childIndex != -1) {
                ++childIndex;
            }
        }
        XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, parentAmlPath, xhtmlElement, childXHtmlElement, childIndex);
    }

    private void addCMNMCElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, XHtmlElement xhtmlElement, XHtmlElement childXHtmlElement) throws HandlerError {
        try {
            if (!firstControlMenu && !this.isEricssonT68()) {
                XHtmlElement spaceElement = this.composeSpace();
                XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, parentAmlPath, xhtmlElement, spaceElement);
            }
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        try {
            XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, parentAmlPath, xhtmlElement, childXHtmlElement);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
    }

    public boolean isEricssonT68() {
        boolean ericsson = false;
        String recipientAppAgent = this.oUAProfile.getRecipientAppAgent();
        if (recipientAppAgent != null && recipientAppAgent.indexOf(ERICSSON) != -1 && recipientAppAgent.indexOf(T68) != -1) {
            ericsson = true;
        }
        return ericsson;
    }
}

