/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.util;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.engine.logging.LoggerContainer;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.wml.events.WmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetTopWmlElementStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetWmlChildContainerStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddXmlWmlAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddXmlWmlElementHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlRemoveXmlWmlAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlRemoveXmlWmlElementHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlResetXmlWmlTextHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlSetXmlWmlTextHandletEvent;
import com.aligo.modules.wml.util.exceptions.WmlAmlGetRootElementFailedException;
import com.aligo.modules.wml.util.exceptions.WmlAmlSetRootElementFailedException;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.ClassUtils;
import com.aligo.wml.interfaces.WmlElement;
import java.util.HashMap;

public class WmlAmlElementUtils {
    private static int MAXSIZE = Integer.MAX_VALUE;
    private static final String NOKIA = "Nokia";
    private static final String ROOT_ELEMENT = "ROOT_ELEMENT";
    private static final String WML_ELEMENT = "WML_ELEMENT";
    private static final String WML_PREFIX = "com.aligo.wml.Wml";
    private static final String PRESENTATION_ELEMENTS = "PRESENTATION_ELEMENTS";

    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            WmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new WmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws WmlAmlGetRootElementFailedException {
        return (AxmlElement)handlerManager.retrieveState(ROOT_ELEMENT);
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws WmlAmlSetRootElementFailedException {
        handlerManager.storeState(ROOT_ELEMENT, rootAmlElement);
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        WmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new WmlAmlIsSufficientMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static WmlElement getTopWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        WmlAmlGetTopWmlElementStateHandlerEvent getTopWmlElementStateEvent = new WmlAmlGetTopWmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopWmlElementStateEvent);
        return getTopWmlElementStateEvent.getWmlElement();
    }

    public static void detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        WmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new WmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        WmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new WmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static WmlElement getChildContainerWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        WmlAmlGetWmlChildContainerStateHandlerEvent getWmlChildContainerStateEvent = new WmlAmlGetWmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getWmlChildContainerStateEvent);
        return getWmlChildContainerStateEvent.getWmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        WmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new WmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = WmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static void setWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement, WmlElement wmlElement) throws HandlerError {
        String strAmlPath;
        HashMap<XmlElementInterface, WmlElement> pwmlElements;
        HashMap<String, HashMap<XmlElementInterface, WmlElement>> wmlElements = (HashMap<String, HashMap<XmlElementInterface, WmlElement>>)handlerManager.retrieveState(WML_ELEMENT);
        if (wmlElements == null) {
            wmlElements = new HashMap<String, HashMap<XmlElementInterface, WmlElement>>();
            handlerManager.storeState(WML_ELEMENT, wmlElements);
        }
        if ((pwmlElements = (HashMap<XmlElementInterface, WmlElement>)wmlElements.get(strAmlPath = currentAmlPath.toString())) == null) {
            pwmlElements = new HashMap<XmlElementInterface, WmlElement>();
            wmlElements.put(strAmlPath, pwmlElements);
        }
        pwmlElements.put(xmlElement, wmlElement);
    }

    public static WmlElement getWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        HashMap pwmlElements;
        WmlElement wmlElement = null;
        HashMap wmlElements = (HashMap)handlerManager.retrieveState(WML_ELEMENT);
        if (wmlElements != null && (pwmlElements = (HashMap)wmlElements.get(currentAmlPath.toString())) != null) {
            wmlElement = (WmlElement)pwmlElements.get(xmlElement);
        }
        return wmlElement;
    }

    public static WmlElement createWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws Exception {
        return (WmlElement)ClassUtils.createElementWithThrow(WML_PREFIX + name);
    }

    public static void addWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement, WmlElement childWmlElement) throws HandlerError {
        WmlAmlElementUtils.addWmlElement(handlerManager, currentAmlPath, wmlElement, childWmlElement, -1);
    }

    public static void addWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement, WmlElement childWmlElement, int childIndex) throws HandlerError {
        WmlAmlAddXmlWmlElementHandletEvent addXmlWmlElementEvent = new WmlAmlAddXmlWmlElementHandletEvent(currentAmlPath, wmlElement, childWmlElement, childIndex);
        handlerManager.postEventNow(addXmlWmlElementEvent);
    }

    public static void addWmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement, String name, String value) throws HandlerError {
        WmlAmlAddXmlWmlAttributeHandletEvent addXmlWmlAttributeEvent = new WmlAmlAddXmlWmlAttributeHandletEvent(currentAmlPath, wmlElement, name, value);
        handlerManager.postEventNow(addXmlWmlAttributeEvent);
    }

    public static void setWmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement, String text) throws HandlerError {
        WmlAmlSetXmlWmlTextHandletEvent setXmlWmlTextEvent = new WmlAmlSetXmlWmlTextHandletEvent(currentAmlPath, wmlElement, text);
        handlerManager.postEventNow(setXmlWmlTextEvent);
    }

    public static void removeWmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement, WmlElement childWmlElement) throws HandlerError {
        WmlAmlRemoveXmlWmlElementHandletEvent removeXmlWmlElementEvent = new WmlAmlRemoveXmlWmlElementHandletEvent(currentAmlPath, wmlElement, childWmlElement);
        handlerManager.postEventNow(removeXmlWmlElementEvent);
    }

    public static void removeWmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement, String name) throws HandlerError {
        WmlAmlRemoveXmlWmlAttributeHandletEvent removeXmlWmlAttributeEvent = new WmlAmlRemoveXmlWmlAttributeHandletEvent(currentAmlPath, wmlElement, name);
        handlerManager.postEventNow(removeXmlWmlAttributeEvent);
    }

    public static void resetWmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, WmlElement wmlElement) throws HandlerError {
        WmlAmlResetXmlWmlTextHandletEvent resetXmlWmlTextEvent = new WmlAmlResetXmlWmlTextHandletEvent(currentAmlPath, wmlElement);
        handlerManager.postEventNow(resetXmlWmlTextEvent);
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, WmlElement wmlElement) throws HandlerError {
        boolean present = false;
        HashMap wmlElements = WmlAmlElementUtils.getPresentationElements(handlerManager);
        if (wmlElements.get(wmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static HashMap getPresentationElements(HandlerManagerInterface handlerManager) {
        HashMap presentationElements = (HashMap)handlerManager.retrieveState(PRESENTATION_ELEMENTS);
        if (presentationElements == null) {
            presentationElements = new HashMap();
            handlerManager.storeState(PRESENTATION_ELEMENTS, presentationElements);
        }
        return presentationElements;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, WmlElement wmlElement) throws HandlerError {
        HashMap wmlElements = WmlAmlElementUtils.getPresentationElements(handlerManager);
        WmlAmlElementUtils.addPresentationElement(wmlElements, wmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, WmlElement wmlElement) throws HandlerError {
        HashMap wmlElements = WmlAmlElementUtils.getPresentationElements(handlerManager);
        WmlAmlElementUtils.removePresentationElement(wmlElements, wmlElement);
    }

    public static void addPresentationElement(HashMap wmlElements, WmlElement wmlElement) {
        wmlElements.put(wmlElement, wmlElement);
    }

    public static void removePresentationElement(HashMap wmlElements, WmlElement wmlElement) {
        wmlElements.remove(wmlElement);
    }

    public static boolean isCachable(HandlerManagerInterface handlerManager, UAProfile uaProfile) {
        boolean cache = true;
        int size = uaProfile.getPDUSize();
        if (size == MAXSIZE) {
            cache = false;
        }
        return cache;
    }

    public static boolean isCompleteDocument(HandlerManagerInterface handlerManager) {
        boolean document = false;
        try {
            AxmlElement amlElement = WmlAmlElementUtils.getRootAmlElement(handlerManager);
            if (amlElement instanceof AxmlDocument) {
                document = true;
            }
        }
        catch (WmlAmlGetRootElementFailedException we) {
            LoggerContainer.getDefaultLogger().logError(we);
        }
        return document;
    }

    public static boolean isNokia(UAProfile uaProfile) {
        boolean nokia = false;
        String amlID = uaProfile.getAmlID();
        if (amlID != null && amlID.equals(NOKIA)) {
            nokia = true;
        }
        return nokia;
    }
}

