/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.wml.state.exceptions.WmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.wml.state.exceptions.WmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.wml.state.interfaces.WmlAmlStateKeeperInterface;
import com.aligo.wml.WmlElementCollection;
import com.aligo.wml.exceptions.WmlElementCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlStateKeeper
implements WmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private WmlElement oWmlChildContainerElement;
    private WmlElement oWmlElements = new WmlElementCollection();
    private WmlElement oWmlTopElement;
    private WmlElement oWmlEndElements = new WmlElementCollection();
    private int iWmlChildPosition = -1;
    private Hashtable oWmlAttrTable = new Hashtable();
    private WmlElement oWmlTextElements = new WmlElementCollection();
    private XmlElementInterface oTopStyleElement;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setWmlChildContainerElement(WmlElement wmlChildContainerElement) {
        this.oWmlChildContainerElement = wmlChildContainerElement;
    }

    public WmlElement getWmlChildContainerElement() {
        return this.oWmlChildContainerElement;
    }

    public void setWmlChildPosition(int wmlChildPosition) {
        this.iWmlChildPosition = wmlChildPosition;
    }

    public int getWmlChildPosition() {
        return this.iWmlChildPosition;
    }

    public void setTopWmlElement(WmlElement wmlTopElement) {
        this.oWmlTopElement = wmlTopElement;
    }

    public WmlElement getTopWmlElement() {
        return this.oWmlTopElement;
    }

    public void addEndWmlElement(WmlElement wmlEndElement) {
        try {
            this.oWmlEndElements.addWmlElement(wmlEndElement);
        }
        catch (WmlElementCannotBeAddedException wmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public WmlElement getEndWmlElements() {
        return this.oWmlEndElements;
    }

    public void removeAllEndWmlElements() {
        this.oWmlEndElements.removeAll();
    }

    public void removeEndWmlElement(WmlElement wmlElement) throws WmlAmlStateKeeperElementNotFoundException {
        try {
            this.oWmlEndElements.removeWmlElement(wmlElement);
        }
        catch (WmlElementNotFoundException we) {
            throw new WmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addWmlElement(WmlElement wmlElement) {
        try {
            this.oWmlElements.addWmlElement(wmlElement);
        }
        catch (WmlElementCannotBeAddedException wmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public WmlElement getWmlElements() {
        return this.oWmlElements;
    }

    public void removeAllWmlElements() {
        this.oWmlElements.removeAll();
    }

    public void removeWmlElement(WmlElement wmlElement) throws WmlAmlStateKeeperElementNotFoundException {
        try {
            this.oWmlElements.removeWmlElement(wmlElement);
        }
        catch (WmlElementNotFoundException we) {
            throw new WmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createWmlAttributeVector(WmlElement wmlElement) {
        Vector attributeVector = new Vector();
        this.oWmlAttrTable.put(wmlElement, attributeVector);
        return attributeVector;
    }

    public void addWmlAttribute(WmlElement wmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oWmlAttrTable.get(wmlElement);
        if (attributeVector == null) {
            attributeVector = this.createWmlAttributeVector(wmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public WmlElement getWmlAttributeElements() {
        WmlElementCollection attributeElements = new WmlElementCollection();
        Enumeration keys = this.oWmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                WmlElement wmlElement = (WmlElement)keys.nextElement();
                attributeElements.addWmlElement(wmlElement);
            }
            catch (WmlElementCannotBeAddedException wmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getWmlAttributes(WmlElement wmlElement) throws WmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oWmlAttrTable.get(wmlElement);
        if (attributeVector == null) {
            throw new WmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllWmlAttributes() {
        this.oWmlAttrTable.clear();
    }

    public void removeWmlAttributes(WmlElement wmlElement) throws WmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oWmlAttrTable.get(wmlElement);
        if (attributeVector == null) {
            throw new WmlAmlStateKeeperElementNotFoundException();
        }
        this.oWmlAttrTable.remove(wmlElement);
    }

    public void removeWmlAttribute(WmlElement wmlElement, String wmlAttrName) throws WmlAmlStateKeeperElementNotFoundException, WmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oWmlAttrTable.get(wmlElement);
        if (attributeVector == null) {
            throw new WmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(wmlAttrName);
        if (!present) {
            throw new WmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addWmlText(WmlElement wmlElement) {
        try {
            this.oWmlTextElements.addWmlElement(wmlElement);
        }
        catch (WmlElementCannotBeAddedException wmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public WmlElement getWmlTextElements() {
        return this.oWmlTextElements;
    }

    public void removeAllWmlTextElements() {
        this.oWmlTextElements.removeAll();
    }

    public void removeWmlText(WmlElement wmlElement) throws WmlAmlStateKeeperElementNotFoundException {
        try {
            this.oWmlTextElements.removeWmlElement(wmlElement);
        }
        catch (WmlElementNotFoundException we) {
            throw new WmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }
}

